/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.engine.header.Header;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jaxrs.internal.core.CallContext;
import org.restlet.ext.jaxrs.internal.core.PathSegmentImpl;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedUriInfo;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertCookieParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertHeaderParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertMatrixParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertParameterException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertPathParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertQueryParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.params.ContextHolder;
import org.restlet.ext.jaxrs.internal.wrappers.params.ContextInjector;
import org.restlet.ext.jaxrs.internal.wrappers.params.EntityGetter;
import org.restlet.ext.jaxrs.internal.wrappers.params.NamedValuesIter;
import org.restlet.ext.jaxrs.internal.wrappers.params.ReprEntityGetter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.NamedValue;
import org.restlet.util.Series;

public class ParameterList {
    private static final String COLL_PARAM_NOT_DEFAULT = "The collection type Collection is not supported for parameters. Use List, Set or SortedSet";
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Byte DEFAULT_BYTE = 0;
    private static final Character DEFAULT_CHAR = new Character('\u0000');
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Integer DEFAULT_INT = 0;
    private static final Long DEFAULT_LONG = new Long(0L);
    private static final Short DEFAULT_SHORT = 0;
    private static final Logger localLogger = Context.getCurrentLogger();
    private static final Collection<Class<? extends Annotation>> VALID_ANNOTATIONS = ParameterList.createValidAnnotations();
    private final int entityPosition;
    private final int paramCount;
    private final ParamGetter[] parameters;

    private static Class<Collection<?>> collType(ParameterizedType type) {
        Type rawType = type.getRawType();
        if (rawType.equals(List.class)) {
            return ArrayList.class;
        }
        if (rawType.equals(Set.class)) {
            return HashSet.class;
        }
        if (rawType.equals(SortedSet.class)) {
            return TreeSet.class;
        }
        if (rawType.equals(Collection.class)) {
            localLogger.config(COLL_PARAM_NOT_DEFAULT);
            return ArrayList.class;
        }
        return null;
    }

    static Collection<Class<? extends Annotation>> createValidAnnotations() {
        return Arrays.asList(javax.ws.rs.core.Context.class, HeaderParam.class, MatrixParam.class, QueryParam.class, PathParam.class, CookieParam.class);
    }

    static <A extends Annotation> A getAnno(Annotation[] annotations, Class<A> annoType) {
        for (Annotation annot : annotations) {
            Class<? extends Annotation> annotationType = annot.annotationType();
            if (!annotationType.equals(annoType)) continue;
            return (A)annot;
        }
        return null;
    }

    static boolean getLeaveEncoded(Annotation[] annotations) {
        for (Annotation annot : annotations) {
            Class<? extends Annotation> annotationType = annot.annotationType();
            if (!annotationType.equals(Encoded.class)) continue;
            return true;
        }
        return false;
    }

    private ParameterList(Class<?>[] parameterTypes, Type[] genParamTypes, Annotation[][] paramAnnoss, ThreadLocalizedContext tlContext, boolean leaveAllEncoded, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, boolean paramsAllowed, boolean entityAllowed, Logger logger, boolean allMustBeAvailable) throws MissingAnnotationException, IllegalTypeException, IllegalPathParamTypeException {
        this.paramCount = parameterTypes.length;
        this.parameters = new ParamGetter[this.paramCount];
        boolean entityAlreadyRead = false;
        int entityPosition = -1;
        for (int i = 0; i < this.paramCount; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Type genParamType = genParamTypes[i];
            Annotation[] paramAnnos = paramAnnoss[i];
            javax.ws.rs.core.Context conntextAnno = ParameterList.getAnno(paramAnnos, javax.ws.rs.core.Context.class);
            if (conntextAnno != null) {
                if (parameterType.equals(UriInfo.class)) {
                    this.parameters[i] = new UriInfoGetter(tlContext, allMustBeAvailable);
                    continue;
                }
                this.parameters[i] = new ContextHolder(ContextInjector.getInjectObject(parameterType, tlContext, jaxRsProviders, extensionBackwardMapping));
                continue;
            }
            if (paramsAllowed) {
                boolean leaveThisEncoded = ParameterList.getLeaveEncoded(paramAnnos);
                DefaultValue defValue = ParameterList.getAnno(paramAnnos, DefaultValue.class);
                CookieParam cookieParam = ParameterList.getAnno(paramAnnos, CookieParam.class);
                HeaderParam headerParam = ParameterList.getAnno(paramAnnos, HeaderParam.class);
                MatrixParam matrixParam = ParameterList.getAnno(paramAnnos, MatrixParam.class);
                PathParam pathParam = ParameterList.getAnno(paramAnnos, PathParam.class);
                QueryParam queryParam = ParameterList.getAnno(paramAnnos, QueryParam.class);
                FormParam formParam = ParameterList.getAnno(paramAnnos, FormParam.class);
                if (pathParam != null) {
                    this.parameters[i] = new PathParamGetter(pathParam, defValue, parameterType, genParamType, tlContext, leaveAllEncoded || leaveThisEncoded);
                    continue;
                }
                if (cookieParam != null) {
                    this.parameters[i] = new CookieParamGetter(cookieParam, defValue, parameterType, genParamType, tlContext, leaveThisEncoded);
                    continue;
                }
                if (headerParam != null) {
                    this.parameters[i] = new HeaderParamGetter(headerParam, defValue, parameterType, genParamType, tlContext, leaveThisEncoded);
                    continue;
                }
                if (matrixParam != null) {
                    this.parameters[i] = new MatrixParamGetter(matrixParam, defValue, parameterType, genParamType, tlContext, leaveAllEncoded || leaveThisEncoded);
                    continue;
                }
                if (queryParam != null) {
                    this.parameters[i] = new QueryParamGetter(queryParam, defValue, parameterType, genParamType, tlContext, leaveAllEncoded || leaveThisEncoded);
                    continue;
                }
                if (formParam != null) {
                    this.parameters[i] = new FormParamGetter(formParam, defValue, parameterType, genParamType, tlContext, leaveAllEncoded || leaveThisEncoded);
                    continue;
                }
            }
            if (!entityAllowed) {
                throw new MissingAnnotationException("All parameters requires one of the following annotations: " + VALID_ANNOTATIONS);
            }
            if (entityAlreadyRead) {
                throw new MissingAnnotationException("The entity is already read.  The " + i + ". parameter requires one of " + "the following annotations: " + VALID_ANNOTATIONS);
            }
            if (Representation.class.isAssignableFrom(parameterType)) {
                this.parameters[i] = ReprEntityGetter.create(parameterType, genParamType, logger);
            }
            if (this.parameters[i] == null) {
                this.parameters[i] = new EntityGetter(parameterType, genParamType, tlContext, jaxRsProviders, paramAnnos);
            }
            entityPosition = i;
            entityAlreadyRead = true;
        }
        this.entityPosition = entityPosition;
    }

    public ParameterList(Constructor<?> constr, ThreadLocalizedContext tlContext, boolean leaveEncoded, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, boolean paramsAllowed, Logger logger, boolean allMustBeAvailable) throws MissingAnnotationException, IllegalTypeException, IllegalPathParamTypeException {
        this(constr.getParameterTypes(), constr.getGenericParameterTypes(), constr.getParameterAnnotations(), tlContext, leaveEncoded, jaxRsProviders, extensionBackwardMapping, paramsAllowed, false, logger, allMustBeAvailable);
    }

    public ParameterList(Method executeMethod, Method annotatedMethod, ThreadLocalizedContext tlContext, boolean leaveEncoded, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, boolean entityAllowed, Logger logger) throws MissingAnnotationException, IllegalTypeException, IllegalPathParamTypeException {
        this(executeMethod.getParameterTypes(), executeMethod.getGenericParameterTypes(), annotatedMethod.getParameterAnnotations(), tlContext, leaveEncoded, jaxRsProviders, extensionBackwardMapping, true, entityAllowed, logger, true);
    }

    public Object[] get() throws ConvertRepresentationException, InvocationTargetException, WebApplicationException {
        Object[] args = new Object[this.parameters.length];
        if (this.entityPosition >= 0) {
            args[this.entityPosition] = this.parameters[this.entityPosition].getValue();
        }
        for (int i = 0; i < this.paramCount; ++i) {
            if (i == this.entityPosition) continue;
            args[i] = this.parameters[i].getValue();
        }
        return args;
    }

    private static class UriInfoGetter
    implements ParamGetter {
        private final boolean availableMandatory;
        private final ThreadLocalizedUriInfo uriInfo;

        private UriInfoGetter(ThreadLocalizedContext tlContext, boolean availableMandatory) {
            this.uriInfo = new ThreadLocalizedUriInfo(tlContext);
            this.availableMandatory = availableMandatory;
        }

        @Override
        public Object getValue() throws InvocationTargetException, ConvertRepresentationException, WebApplicationException {
            this.uriInfo.saveStateForCurrentThread(this.availableMandatory);
            return this.uriInfo;
        }
    }

    static class QueryParamGetter
    extends FormOrQueryParamGetter {
        private final QueryParam queryParam;

        QueryParamGetter(QueryParam queryParam, DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext, leaveEncoded);
            this.queryParam = queryParam;
        }

        @Override
        public Object getParamValue() {
            Reference resourceRef = this.tlContext.get().getRequest().getResourceRef();
            String queryString = resourceRef.getQuery();
            Form form = Converter.toFormEncoded(queryString);
            String paramName = this.queryParam.value();
            try {
                return super.getParamValue((Series<Parameter>)form, paramName);
            }
            catch (ConvertParameterException e) {
                throw new ConvertQueryParamException(e);
            }
        }
    }

    static class PathParamGetter
    extends EncParamGetter {
        private final PathParam pathParam;

        PathParamGetter(PathParam pathParam, DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) throws IllegalPathParamTypeException {
            super(defaultValue, convToCl, convToGen, tlContext, leaveEncoded);
            if (this.collType != null && !this.convertTo.equals(PathSegment.class)) {
                throw new IllegalPathParamTypeException("The type of a @PathParam annotated parameter etc. must not be a collection type or array, if the type parameter is not PathSegment");
            }
            this.pathParam = pathParam;
        }

        private PathSegment createPathSegment(String pathSegmentEnc) throws IllegalArgumentException {
            return new PathSegmentImpl(pathSegmentEnc, this.decoding(), -1);
        }

        @Override
        public Object getParamValue() {
            CallContext callContext = this.tlContext.get();
            if (this.convertTo.equals(PathSegment.class)) {
                if (this.collType == null) {
                    String pathSegmentEnc = callContext.getLastPathSegmentEnc(this.pathParam);
                    return this.createPathSegment(pathSegmentEnc);
                }
                Iterator<String> pathSegmentEncIter = callContext.pathSegementEncIter(this.pathParam);
                Collection coll = this.createColl();
                while (pathSegmentEncIter.hasNext()) {
                    String pathSegmentEnc = pathSegmentEncIter.next();
                    coll.add(this.createPathSegment(pathSegmentEnc));
                }
                if (this.isArray) {
                    return Util.toArray(coll, this.convertTo);
                }
                return this.unmodifiable(coll);
            }
            try {
                String pathParamValue = callContext.getLastPathParamEnc(this.pathParam);
                return this.convertParamValue(pathParamValue);
            }
            catch (ConvertParameterException e) {
                throw new ConvertPathParamException(e);
            }
        }
    }

    static interface ParamGetter {
        public Object getValue() throws InvocationTargetException, ConvertRepresentationException, WebApplicationException;
    }

    static abstract class NoEncParamGetter
    extends AbstractParamGetter {
        NoEncParamGetter(DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean annoSaysLeaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext);
            this.checkForEncodedAnno(annoSaysLeaveEncoded);
        }

        void checkForEncodedAnno(AccessibleObject fieldOrBeanSetter) {
            this.checkForEncodedAnno(fieldOrBeanSetter.isAnnotationPresent(Encoded.class));
        }

        void checkForEncodedAnno(boolean annoSaysLeaveEncoded) {
            if (annoSaysLeaveEncoded) {
                localLogger.warning("You should not use @Encoded on a @HeaderParam or @CookieParam. Will ignore it");
            }
        }

        @Override
        protected boolean decoding() {
            return false;
        }
    }

    static class MatrixParamGetter
    extends EncParamGetter {
        private final MatrixParam matrixParam;

        MatrixParamGetter(MatrixParam matrixParam, DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext, leaveEncoded);
            this.matrixParam = matrixParam;
        }

        @Override
        public Object getParamValue() {
            CallContext callContext = this.tlContext.get();
            try {
                if (this.collType == null) {
                    String matrixParamValue = callContext.getLastMatrixParamEnc(this.matrixParam);
                    return this.convertParamValue(matrixParamValue);
                }
                Iterator<String> matrixParamValues = callContext.matrixParamEncIter(this.matrixParam);
                return this.convertParamValues(matrixParamValues);
            }
            catch (ConvertParameterException e) {
                throw new ConvertMatrixParamException(e);
            }
        }
    }

    static class HeaderParamGetter
    extends NoEncParamGetter {
        private final HeaderParam headerParam;

        HeaderParamGetter(HeaderParam headerParam, DefaultValue defaultValue, Class<?> convToCl, Type paramGenericType, ThreadLocalizedContext tlContext, boolean annoSaysLeaveClassEncoded) {
            super(defaultValue, convToCl, paramGenericType, tlContext, annoSaysLeaveClassEncoded);
            this.headerParam = headerParam;
        }

        @Override
        public Object getParamValue() {
            Series<Header> httpHeaders = Util.getHttpHeaders(this.tlContext.get().getRequest());
            String headerName = this.headerParam.value();
            try {
                if (this.collType == null) {
                    String firstHeader = WrapperUtil.getValue((NamedValue<String>)httpHeaders.getFirst(headerName, true));
                    return this.convertParamValue(firstHeader);
                }
                return this.convertParamValues(new NamedValuesIter((Iterable<? extends NamedValue<String>>)httpHeaders.subList(headerName, true)));
            }
            catch (ConvertParameterException e) {
                throw new ConvertHeaderParamException(e);
            }
        }
    }

    static class FormParamGetter
    extends FormOrQueryParamGetter {
        private final FormParam formParam;
        private static Form form;

        FormParamGetter(FormParam formParam, DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext, leaveEncoded);
            this.formParam = formParam;
        }

        @Override
        public Object getParamValue() {
            Representation entity = this.tlContext.get().getRequest().getEntity();
            if (entity != null && entity.isAvailable()) {
                form = new Form(entity);
            }
            String paramName = this.formParam.value();
            try {
                return super.getParamValue((Series<Parameter>)form, paramName);
            }
            catch (ConvertParameterException e) {
                throw new ConvertQueryParamException(e);
            }
        }
    }

    static abstract class FormOrQueryParamGetter
    extends EncParamGetter {
        FormOrQueryParamGetter(DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext, leaveEncoded);
        }

        Object getParamValue(Series<Parameter> params, String paramName) throws ConvertParameterException {
            Series parameters = params.subList(paramName);
            if (this.collType == null) {
                Parameter firstFormParam = (Parameter)params.getFirst(paramName);
                String queryParamValue = WrapperUtil.getValue((NamedValue<String>)firstFormParam);
                return this.convertParamValue(queryParamValue);
            }
            NamedValuesIter queryParamValueIter = new NamedValuesIter((Iterable<? extends NamedValue<String>>)parameters);
            return this.convertParamValues(queryParamValueIter);
        }
    }

    static abstract class EncParamGetter
    extends AbstractParamGetter {
        private final boolean decoding;

        EncParamGetter(DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean leaveEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext);
            this.decoding = !leaveEncoded;
        }

        @Override
        protected boolean decoding() {
            return this.decoding;
        }
    }

    static class CookieParamGetter
    extends NoEncParamGetter {
        private final CookieParam cookieParam;

        CookieParamGetter(CookieParam cookieParam, DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, boolean annoSaysLeaveClassEncoded) {
            super(defaultValue, convToCl, convToGen, tlContext, annoSaysLeaveClassEncoded);
            this.cookieParam = cookieParam;
        }

        @Override
        public Object getParamValue() {
            String cookieName = this.cookieParam.value();
            Series cookies = this.tlContext.get().getRequest().getCookies();
            if (this.convertTo.equals(Cookie.class)) {
                Collection coll = this.createColl();
                for (org.restlet.data.Cookie rc : cookies) {
                    if (!rc.getName().equals(cookieName)) continue;
                    Cookie cookie = Converter.toJaxRsCookie(rc);
                    if (coll == null) {
                        return cookie;
                    }
                    coll.add(cookie);
                }
                if (coll == null) {
                    return null;
                }
                if (coll.isEmpty()) {
                    String value = this.defaultValue.value();
                    coll.add(new Cookie(cookieName, value));
                }
                if (this.isArray) {
                    return Util.toArray(coll, Cookie.class);
                }
                return coll;
            }
            try {
                if (this.collType == null) {
                    String firstCookieValue = WrapperUtil.getValue((NamedValue<String>)cookies.getFirst(cookieName));
                    return this.convertParamValue(firstCookieValue);
                }
                return this.convertParamValues(new NamedValuesIter((Iterable<? extends NamedValue<String>>)cookies.subList(cookieName)));
            }
            catch (ConvertParameterException e) {
                throw new ConvertCookieParamException(e);
            }
        }
    }

    static abstract class AbstractParamGetter
    implements ParamGetter {
        protected final Class<Collection<?>> collType;
        protected final Class<?> convertTo;
        protected final DefaultValue defaultValue;
        protected final boolean isArray;
        protected final ThreadLocalizedContext tlContext;

        AbstractParamGetter(DefaultValue defaultValue, Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext) {
            this.tlContext = tlContext;
            this.defaultValue = defaultValue;
            if (convToCl.isArray()) {
                this.convertTo = convToCl.getComponentType();
                this.collType = ArrayList.class;
                this.isArray = true;
            } else if (convToGen instanceof ParameterizedType) {
                ParameterizedType parametrizedType = (ParameterizedType)convToGen;
                Type[] argTypes = parametrizedType.getActualTypeArguments();
                if (!(argTypes[0] instanceof Class)) {
                    throw new NotYetImplementedException("Sorry, only Class is supported, but is " + argTypes[0]);
                }
                this.convertTo = (Class)argTypes[0];
                this.collType = ParameterList.collType(parametrizedType);
                this.isArray = false;
            } else {
                this.convertTo = convToCl;
                this.collType = null;
                this.isArray = false;
            }
        }

        protected Object convertParamValue(String firstHeader) throws ConvertParameterException {
            return this.convertParamValue(firstHeader, this.defaultValue);
        }

        protected Object convertParamValue(String paramValue, DefaultValue defaultValue) throws ConvertParameterException {
            if (this.decoding() && paramValue != null) {
                paramValue = Reference.decode((String)paramValue);
            } else if (paramValue == null && defaultValue != null) {
                paramValue = defaultValue.value();
            }
            if (this.convertTo.equals(String.class)) {
                return paramValue;
            }
            if (this.convertTo.isPrimitive()) {
                if (paramValue != null && paramValue.length() <= 0) {
                    paramValue = defaultValue.value();
                }
                return this.getParamValueForPrimitive(paramValue);
            }
            return this.convertParamValueInner(paramValue, defaultValue);
        }

        private Object convertParamValueInner(String paramValue, DefaultValue defaultValue) throws ConvertParameterException, WebApplicationException {
            Object convertWithConverterUtils = this.convertWithConverterUtils(paramValue);
            if (convertWithConverterUtils != null) {
                return convertWithConverterUtils;
            }
            String value = paramValue;
            if (StringUtils.isEmpty((String)paramValue)) {
                if (defaultValue == null || defaultValue.value() == null) {
                    return null;
                }
                value = defaultValue.value();
            }
            try {
                return ConstructorUtils.invokeConstructor(this.convertTo, (Object)value);
            }
            catch (Exception e) {
                this.handleExceptionOnInvocation(value, e);
                try {
                    return MethodUtils.invokeStaticMethod(this.convertTo, (String)(this.convertTo.isEnum() ? "fromString" : "valueOf"), (Object)value);
                }
                catch (Exception e2) {
                    this.handleExceptionOnInvocation(value, e2);
                    try {
                        return MethodUtils.invokeStaticMethod(this.convertTo, (String)(this.convertTo.isEnum() ? "valueOf" : "fromString"), (Object)value);
                    }
                    catch (Exception e3) {
                        this.handleExceptionOnInvocation(value, e3);
                        throw ConvertParameterException.object(this.convertTo, value, new Exception("Target object has no String constructor, valueOf or fromString method."));
                    }
                }
            }
        }

        private void handleExceptionOnInvocation(String value, Exception e) throws ConvertParameterException {
            Throwable cause = e.getCause();
            if (e instanceof WebApplicationException || cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            if (!(e instanceof NoSuchMethodException || e instanceof IllegalAccessException || e instanceof InvocationTargetException || e instanceof InstantiationException || e instanceof NoSuchMethodException)) {
                throw ConvertParameterException.object(this.convertTo, value, e);
            }
        }

        private Object convertWithConverterUtils(String paramValue) {
            Object result = null;
            if (this.tlContext.get().getRequest().getEntity() != null && paramValue != null) {
                try {
                    ConverterHelper converterHelper = ConverterUtils.getBestHelper((Representation)this.tlContext.get().getRequest().getEntity(), this.convertTo, null);
                    List variants = converterHelper.getVariants(this.convertTo);
                    for (int i = 0; result == null && i < variants.size(); ++i) {
                        result = converterHelper.toObject((Representation)new StringRepresentation((CharSequence)paramValue, ((VariantInfo)variants.get(i)).getMediaType()), this.convertTo, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return result;
        }

        protected Object convertParamValues(Iterator<String> paramValueIter) throws ConvertParameterException {
            Collection coll = this.createColl();
            while (paramValueIter.hasNext()) {
                String queryParamValue = paramValueIter.next();
                Object convertedValue = this.convertParamValue(queryParamValue, null);
                if (convertedValue == null) continue;
                coll.add(convertedValue);
            }
            if (coll.isEmpty()) {
                coll.add(this.convertParamValue(null));
            }
            if (this.isArray) {
                return Util.toArray(coll, this.convertTo);
            }
            return this.unmodifiable(coll);
        }

        protected <A> Collection<A> createColl() {
            try {
                if (this.collType != null) {
                    return this.collType.newInstance();
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate the collection type " + this.collType, e);
            }
        }

        protected <A> Collection<A> unmodifiable(Collection<A> coll) {
            if (coll instanceof List) {
                return Collections.unmodifiableList((List)coll);
            }
            if (coll instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)coll);
            }
            if (coll instanceof Set) {
                return Collections.unmodifiableSet((Set)coll);
            }
            return Collections.unmodifiableCollection(coll);
        }

        protected abstract boolean decoding();

        public abstract Object getParamValue();

        protected Object getParamValueForPrimitive(String paramValue) throws ConvertParameterException {
            try {
                if (this.convertTo == Integer.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_INT;
                    }
                    return new Integer(paramValue);
                }
                if (this.convertTo == Double.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_DOUBLE;
                    }
                    return new Double(paramValue);
                }
                if (this.convertTo == Float.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_FLOAT;
                    }
                    return new Float(paramValue);
                }
                if (this.convertTo == Byte.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_BYTE;
                    }
                    return new Byte(paramValue);
                }
                if (this.convertTo == Long.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_LONG;
                    }
                    return new Long(paramValue);
                }
                if (this.convertTo == Short.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_SHORT;
                    }
                    return new Short(paramValue);
                }
                if (this.convertTo == Character.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_CHAR;
                    }
                    if (paramValue.length() == 1) {
                        return Character.valueOf(paramValue.charAt(0));
                    }
                    throw ConvertParameterException.primitive(this.convertTo, paramValue, null);
                }
                if (this.convertTo == Boolean.TYPE) {
                    if (paramValue == null || paramValue.length() <= 0) {
                        return DEFAULT_BOOLEAN;
                    }
                    if (paramValue.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (paramValue.equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                    throw ConvertParameterException.primitive(this.convertTo, paramValue, null);
                }
            }
            catch (IllegalArgumentException e) {
                throw ConvertParameterException.primitive(this.convertTo, paramValue, e);
            }
            String warning = this.convertTo == Void.TYPE ? "an object should be converted to a void; but this could not be here" : "an object should be converted to a " + this.convertTo + ", but here are only primitives allowed.";
            localLogger.warning(warning);
            Response.ResponseBuilder rb = Response.serverError();
            rb.entity((Object)warning);
            throw new WebApplicationException(rb.build());
        }

        @Override
        public Object getValue() {
            return this.getParamValue();
        }
    }
}

