/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.rowset.WebRowSet;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jdbc.JdbcResult;
import org.restlet.representation.WriterRepresentation;

public class RowSetRepresentation
extends WriterRepresentation {
    private volatile JdbcResult jdbcResult;
    private volatile WebRowSet webRowSet;

    private static WebRowSet create(ResultSet resultSet, int start, int limit) throws SQLException {
        WebRowSet result = null;
        try {
            result = (WebRowSet)Class.forName("com.sun.rowset.WebRowSetImpl").newInstance();
        }
        catch (Throwable t) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to instantiate the Sun's WebRowSet implementation", t);
        }
        if (resultSet != null) {
            if (limit > -1) {
                result.setPageSize(limit);
                result.setMaxRows(limit);
            }
            result.populate(resultSet, start < 0 ? 1 : start + 1);
        }
        return result;
    }

    public RowSetRepresentation(JdbcResult jdbcResult) throws SQLException {
        this(jdbcResult, -1, -1);
    }

    public RowSetRepresentation(JdbcResult jdbcResult, int start, int limit) throws SQLException {
        this(RowSetRepresentation.create(jdbcResult == null ? null : jdbcResult.getResultSet(), start, limit));
        this.jdbcResult = jdbcResult;
    }

    public RowSetRepresentation(ResultSet resultSet) throws SQLException {
        this(resultSet, -1, -1);
    }

    public RowSetRepresentation(ResultSet resultSet, int start, int limit) throws SQLException {
        this(RowSetRepresentation.create(resultSet, start, limit));
    }

    public RowSetRepresentation(WebRowSet webRowSet) {
        super(MediaType.TEXT_XML);
        this.webRowSet = webRowSet;
    }

    public JdbcResult getJdbcResult() {
        return this.jdbcResult;
    }

    public WebRowSet getWebRowSet() {
        return this.webRowSet;
    }

    public void write(Writer writer) throws IOException {
        try {
            this.webRowSet.writeXml(writer);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
        try {
            if (this.jdbcResult != null) {
                this.jdbcResult.release();
            }
        }
        catch (SQLException se) {
            throw new IOException("SQL exception while releasing the JdbcResult instance after writing the representation. " + se.getMessage());
        }
        try {
            if (this.webRowSet != null) {
                this.webRowSet.release();
                this.webRowSet.close();
            }
        }
        catch (SQLException se) {
            throw new IOException("Error while releasing the WebRowSet instance after writing the representation. " + se.getMessage());
        }
    }
}

