/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.solr.request.JSONResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.XMLResponseWriter;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.OutputRepresentation;

public class SolrRepresentation
extends OutputRepresentation {
    protected SolrQueryRequest solrQueryRequest;
    protected SolrQueryResponse solrQueryResponse;

    public SolrRepresentation(MediaType mediaType, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(mediaType);
        this.setCharacterSet(CharacterSet.UTF_8);
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    public SolrRepresentation(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this(null, solrQueryRequest, solrQueryResponse);
    }

    public void write(OutputStream outputStream) throws IOException {
        Object writer = MediaType.APPLICATION_JSON.isCompatible((Metadata)this.getMediaType()) || MediaType.APPLICATION_JAVASCRIPT.isCompatible((Metadata)this.getMediaType()) ? new JSONResponseWriter() : new XMLResponseWriter();
        OutputStreamWriter out = this.getCharacterSet() != null ? new OutputStreamWriter(outputStream, this.getCharacterSet().getName()) : new OutputStreamWriter(outputStream, "UTF-8");
        writer.write((Writer)out, this.solrQueryRequest, this.solrQueryResponse);
        out.close();
    }
}

