/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.engine.http.ServerCall;
import org.restlet.engine.http.io.ChunkedInputStream;
import org.restlet.engine.http.io.ChunkedOutputStream;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyServerCall
extends ServerCall {
    private final HttpRequest request;
    private HttpResponse response;
    private final ChannelBuffer contentBuffer;
    private final MessageEvent messageEvent;
    private volatile boolean requestHeadersAdded;
    private final SSLEngine sslEngine;
    private final InetSocketAddress remoteAddress;

    public NettyServerCall(Server server, MessageEvent messageEvent, ChannelBuffer contentBuffer, HttpRequest request, InetSocketAddress clientAddress, boolean isConfidential, SSLEngine sslEngine) {
        super(server);
        this.setConfidential(isConfidential);
        this.contentBuffer = contentBuffer;
        this.messageEvent = messageEvent;
        this.request = request;
        this.sslEngine = sslEngine;
        this.remoteAddress = clientAddress;
    }

    public boolean abort() {
        this.messageEvent.getChannel().close();
        return true;
    }

    public String getClientAddress() {
        return this.remoteAddress.getAddress().getHostAddress();
    }

    public int getClientPort() {
        return this.remoteAddress.getPort();
    }

    public String getMethod() {
        return this.request.getMethod().getName();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        ChannelBufferInputStream stream = new ChannelBufferInputStream(this.contentBuffer);
        if (this.isRequestChunked()) {
            return new ChunkedInputStream(null, (InputStream)stream);
        }
        return stream;
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            Set names = this.request.getHeaderNames();
            for (String name : names) {
                result.add((Object)new Parameter(name, this.request.getHeader(name)));
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.request.getUri();
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    public OutputStream getResponseEntityStream() {
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        this.response.setContent(buf);
        ChannelBufferOutputStream stream = new ChannelBufferOutputStream(this.response.getContent());
        if (this.isResponseChunked()) {
            return new ChunkedOutputStream((OutputStream)stream);
        }
        return stream;
    }

    public String getSslCipherSuite() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    protected byte[] getSslSessionIdBytes() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            return sslSession.getId();
        }
        return null;
    }

    private SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public String getVersion() {
        return this.request.getProtocolVersion().getText();
    }

    protected boolean isClientKeepAlive() {
        return this.request.isKeepAlive();
    }

    public void writeResponseHead(Response restletResponse) throws IOException {
        if (this.response != null) {
            this.response.clearHeaders();
        } else {
            HttpResponseStatus status = new HttpResponseStatus(restletResponse.getStatus().getCode(), restletResponse.getStatus().getDescription());
            this.response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        if (this.shouldResponseBeChunked(restletResponse)) {
            this.getResponseHeaders().add("Transfer-Encoding", "chunked");
        }
        for (Parameter header : this.getResponseHeaders()) {
            this.response.addHeader(header.getName(), header.getValue());
        }
    }
}

