/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty.internal;

import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.restlet.Server;
import org.restlet.ext.netty.HttpsServerHelper;
import org.restlet.ext.netty.NettyServerHelper;
import org.restlet.ext.netty.internal.NettyServerCall;

@ChannelPipelineCoverage(value="one")
public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    static final byte CR = 13;
    static final byte LF = 10;
    private volatile NettyServerHelper helper;
    private volatile boolean readingChunks;
    private volatile HttpRequest request;
    private volatile ChannelBuffer content;
    private volatile InetSocketAddress clientAddress;

    public HttpRequestHandler(NettyServerHelper serverHelper) {
        this.helper = serverHelper;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof TooLongFrameException) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        cause.printStackTrace();
        if (ch.isConnected()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        ChannelFuture future;
        if (this.clientAddress == null) {
            this.clientAddress = (InetSocketAddress)messageEvent.getRemoteAddress();
        }
        boolean isLastChunk = false;
        if (!this.readingChunks) {
            this.request = (HttpRequest)messageEvent.getMessage();
            if (this.request.isChunked()) {
                this.readingChunks = true;
            } else {
                this.content = this.request.getContent();
            }
        } else {
            HttpChunk chunk = (HttpChunk)messageEvent.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                isLastChunk = true;
            }
            long chunkSize = chunk.getContent().readableBytes();
            this.content.writeBytes(HttpRequestHandler.longToHex(chunkSize));
            this.content.writeByte((byte)13);
            this.content.writeByte((byte)10);
            this.content.writeBytes(chunk.getContent());
            this.content.writeByte((byte)13);
            this.content.writeByte((byte)10);
        }
        if (this.content == null) {
            this.content = ChannelBuffers.dynamicBuffer();
        }
        HttpResponse response = null;
        if (!this.request.isChunked() || isLastChunk) {
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            SSLEngine sslEngine = sslHandler == null ? null : sslHandler.getEngine();
            NettyServerCall httpCall = new NettyServerCall((Server)this.helper.getHelped(), messageEvent, this.content, this.request, this.clientAddress, this.helper instanceof HttpsServerHelper, sslEngine);
            this.helper.handle(httpCall);
            response = httpCall.getResponse();
        }
        Channel ch = messageEvent.getChannel();
        if (this.request.isChunked()) {
            if (isLastChunk) {
                future = ch.write(response);
                future.addListener(ChannelFutureListener.CLOSE);
            }
        } else {
            future = ch.write(response);
            if (this.shouldCloseConnection() || this.request.getMethod() == HttpMethod.GET) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean shouldCloseConnection() {
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        return close;
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((String)("Failure: " + status.toString() + "\r\n"), (String)"UTF-8"));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    public static byte[] longToHex(long l) {
        long v = l & 0xFFFFFFFFFFFFFFFFL;
        byte[] result = new byte[16];
        Arrays.fill(result, 0, result.length, (byte)0);
        for (int i = 0; i < result.length; i += 2) {
            byte b = (byte)((v & 0xFF00000000000000L) >> 56);
            byte b2 = (byte)(b & 0xF);
            byte b1 = (byte)(b >> 4 & 0xF);
            if (b1 > 9) {
                b1 = (byte)(b1 + 39);
            }
            b1 = (byte)(b1 + 48);
            if (b2 > 9) {
                b2 = (byte)(b2 + 39);
            }
            b2 = (byte)(b2 + 48);
            result[i] = (byte)(b1 & 0xFF);
            result[i + 1] = (byte)(b2 & 0xFF);
            v <<= 8;
        }
        return result;
    }
}

