/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.netty;

import java.io.File;
import javax.net.ssl.SSLContext;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.netty.NettyServerHelper;
import org.restlet.ext.netty.internal.HttpsServerPipelineFactory;

public class HttpsServerHelper
extends NettyServerHelper {
    private SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Deprecated
    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    @Deprecated
    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", "");
    }

    @Deprecated
    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    @Deprecated
    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    @Deprecated
    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public ChannelPipelineFactory getPipelineFatory() {
        return new HttpsServerPipelineFactory(this, this.getSslContext());
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Deprecated
    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void start() throws Exception {
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        this.sslContext = sslContextFactory.createSslContext();
        super.start();
    }
}

