/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.concurrent.ScheduledFuture;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.internal.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpireToken
extends Token {
    private final long expireTime;
    private final String refreshToken;
    private final AuthenticatedUser user;
    private volatile String token;
    private volatile ScheduledFuture<?> future;

    public ExpireToken(String refreshToken, long expTimeSec, String token, AuthenticatedUser user) {
        this.refreshToken = refreshToken;
        this.token = token;
        this.user = user;
        this.expireTime = expTimeSec;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public long getExpirePeriod() {
        return this.expireTime;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void expireToken() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.token = null;
    }

    @Override
    public AuthenticatedUser getUser() {
        return this.user;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExpireToken) {
            ExpireToken t = (ExpireToken)obj;
            return this.refreshToken.equals(t.refreshToken) && this.expireTime == t.expireTime;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.refreshToken.hashCode();
    }
}

