/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.freemarker.ContextTemplateLoader;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public class AuthPageServerResource
extends OAuthServerResource {
    @Get(value="html")
    public Representation showPage() {
        String action = this.getQuery().getFirstValue("action");
        if (action != null) {
            String[] scopes = this.getQuery().getValuesArray("scope");
            this.handleAction(action, scopes);
            return new EmptyRepresentation();
        }
        String authPage = HttpOAuthHelper.getAuthPageTemplate(this.getContext());
        this.getLogger().fine("this is auth page: " + authPage);
        if (authPage != null && authPage.length() > 0) {
            this.getLogger().fine("loading authPage: " + authPage);
            boolean sameScope = HttpOAuthHelper.getAuthSkipApproved(this.getContext());
            if (sameScope) {
                String[] scopesArray = this.getQuery().getValuesArray("scope");
                List<String> scopes = Arrays.asList(scopesArray);
                List<String> previousScopes = Arrays.asList(this.getQuery().getValuesArray("grantedScope"));
                if (previousScopes.containsAll(scopes)) {
                    this.getLogger().fine("All scopes already approved. - skip auth page.");
                    this.handleAction("Accept", scopesArray);
                    return new EmptyRepresentation();
                }
            }
            this.getResponse().setCacheDirectives(noCache);
            return this.getPage(authPage);
        }
        this.getLogger().fine("accepting scopes since no authPage: " + authPage);
        this.handleAction("Accept", this.getQuery().getValuesArray("scope"));
        this.getLogger().fine("action handled");
        return new EmptyRepresentation();
    }

    protected void handleAction(String action, String[] scopes) {
        AuthSession session;
        String sessionId = (String)this.getRequest().getAttributes().get("_cid");
        if (sessionId == null) {
            sessionId = this.getCookies().getFirstValue("_cid");
        }
        ConcurrentMap attribs = this.getContext().getAttributes();
        AuthSession authSession = session = sessionId == null ? null : (AuthSession)attribs.get(sessionId);
        if ("Reject".equals(action)) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            this.sendError(session, OAuthError.access_denied, session.getState(), "Rejected.", null);
            this.getLogger().fine("Rejected.");
            return;
        }
        this.getLogger().fine("Accepting scopes - in handleAction");
        Client client = session.getClient();
        String id = session.getScopeOwner();
        String redirUrl = session.getDynamicCallbackURI();
        this.getLogger().fine("OAuth2 get dynamic callback = " + redirUrl);
        if (redirUrl == null || redirUrl.length() == 0) {
            redirUrl = client.getRedirectUri();
        }
        String location = null;
        ResponseType flow = session.getAuthFlow();
        if (flow.equals((Object)ResponseType.token)) {
            location = this.generateAgentToken(id, client, redirUrl);
        } else if (flow.equals((Object)ResponseType.code)) {
            location = this.generateCode(id, client, redirUrl);
        }
        AuthenticatedUser user = client.findUser(session.getScopeOwner());
        if (user == null) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Can't find User id : " + session.getScopeOwner());
        }
        user.revokeRoles();
        for (String s : scopes) {
            this.getLogger().fine("Adding scope = " + s + " to user = " + id);
            user.addRole(Scopes.toRole(s), "");
        }
        String state = session.getState();
        if (state != null && state.length() > 0) {
            Reference stateful = new Reference(location);
            stateful.addQueryParameter("state", state);
            location = stateful.toString();
        }
        session.setState(null);
        user.persist();
        this.redirectTemporary(location);
    }

    protected Representation getPage(String authPage) {
        String clientId = this.getQuery().getFirstValue("client");
        Client client = this.clients.findById(clientId);
        String[] scopes = this.getQuery().getValuesArray("scope");
        String[] previousScopes = this.getQuery().getValuesArray("grantedScope");
        Configuration config = new Configuration();
        ContextTemplateLoader ctl = new ContextTemplateLoader(this.getContext(), "clap:///");
        config.setTemplateLoader((TemplateLoader)ctl);
        this.getLogger().fine("loading: " + authPage);
        TemplateRepresentation result = new TemplateRepresentation(authPage, config, MediaType.TEXT_HTML);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("target", this.getRootRef() + HttpOAuthHelper.getAuthPage(this.getContext()));
        data.put("clientId", clientId);
        data.put("clientDescription", client.toString());
        data.put("clientCallback", client.getRedirectUri());
        data.put("clientName", client.getApplicationName());
        data.put("requestingScopes", scopes);
        data.put("grantedScopes", previousScopes);
        result.setDataModel(data);
        return result;
    }

    protected void sendError(AuthSession session, OAuthError error, String state, String description, String errorUri) {
        String redirUri = session.getDynamicCallbackURI();
        Reference cb = new Reference(redirUri);
        cb.addQueryParameter("error", error.name());
        if (state != null && state.length() > 0) {
            cb.addQueryParameter("state", state);
        }
        if (description != null && description.length() > 0) {
            cb.addQueryParameter("error_description", description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            cb.addQueryParameter("error_uri", errorUri);
        }
        this.redirectTemporary(cb.toString());
        ConcurrentMap attribs = this.getContext().getAttributes();
        attribs.remove(session.getId());
    }
}

