/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.HashMap;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.freemarker.ContextTemplateLoader;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.representation.Representation;

public class AuthorizationBaseServerResource
extends OAuthServerResource {
    protected void doCatch(Throwable t) {
        OAuthException oex = OAuthException.toOAuthException(t);
        AuthSession session = this.getAuthSession();
        if (session == null) {
            Representation resp = this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), oex);
            this.getResponse().setEntity(resp);
        } else {
            String redirectURI = session.getDynamicCallbackURI();
            if (redirectURI == null) {
                redirectURI = session.getClient().getRedirectUri();
            }
            boolean fragment = session.getAuthFlow().equals((Object)ResponseType.token);
            this.sendError(redirectURI, oex, session.getState(), fragment);
        }
    }

    protected AuthSession getAuthSession() {
        String sessionId = this.getCookies().getFirstValue("_cid");
        this.getLogger().fine("sessionId = " + sessionId);
        AuthSession session = sessionId == null ? null : (AuthSession)this.getContext().getAttributes().get(sessionId);
        return session;
    }

    protected void sendError(String redirectURI, OAuthException ex, String state, boolean fragment) {
        String errorUri;
        String description;
        Reference cb = new Reference(redirectURI);
        cb.addQueryParameter("error", ex.getError().name());
        if (state != null && state.length() > 0) {
            cb.addQueryParameter("state", state);
        }
        if ((description = ex.getErrorDescription()) != null && description.length() > 0) {
            cb.addQueryParameter("error_description", description);
        }
        if ((errorUri = ex.getErrorURI()) != null && errorUri.length() > 0) {
            cb.addQueryParameter("error_uri", errorUri);
        }
        if (fragment) {
            cb.setFragment(cb.getQuery());
            cb.setQuery("");
        }
        this.redirectTemporary(cb);
    }

    protected Representation getErrorPage(String errPage, OAuthException ex) {
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)new ContextTemplateLoader(this.getContext(), "clap:///"));
        this.getLogger().fine("loading: " + errPage);
        TemplateRepresentation response = new TemplateRepresentation(errPage, config, MediaType.TEXT_HTML);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("error", ex.getError().name());
        data.put("error_description", ex.getErrorDescription());
        data.put("error_uri", ex.getErrorURI());
        response.setDataModel(data);
        return response;
    }
}

