/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.ClientInfo;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class TokenVerifier
implements Verifier {
    public static final ChallengeScheme HTTP_BEARER = new ChallengeScheme("HTTP_BEARER", "Bearer", "The OAuth 2.0 Authorization Framework: Bearer Token Usage");
    public static final ChallengeScheme HTTP_MAC = new ChallengeScheme("HTTP_MAC", "MAC", "MAC Access Authentication");
    private Reference authReference;
    private boolean acceptBodyMethod = false;
    private boolean acceptQueryMethod = false;
    private Logger logger = Logger.getLogger(TokenVerifier.class.getName());

    public TokenVerifier(Reference authReference) {
        this.authReference = authReference;
    }

    public int verify(Request request, Response response) {
        JSONObject jsonResponse;
        JSONObject authRequest;
        block15: {
            try {
                String bearer;
                ChallengeResponse cr = request.getChallengeResponse();
                if (cr == null) {
                    bearer = null;
                    if (this.acceptBodyMethod) {
                        bearer = this.getAccessTokenFromBody(request);
                    }
                    if (bearer == null && this.acceptQueryMethod && (bearer = this.getAccessTokenFromQuery(request)) != null) {
                        OAuthServerResource.addCacheDirective(response, CacheDirective.privateInfo());
                    }
                    if (bearer == null) {
                        return 0;
                    }
                    this.logger.config("Verify: Bearer (Alternative)");
                    authRequest = TokenVerifier.createBearerAuthRequest(bearer);
                    break block15;
                }
                if (cr.getScheme().equals((Object)HTTP_BEARER)) {
                    this.logger.config("Verify: Bearer");
                    bearer = cr.getRawValue();
                    if (bearer == null || bearer.isEmpty()) {
                        return 0;
                    }
                    authRequest = TokenVerifier.createBearerAuthRequest(bearer);
                    break block15;
                }
                return 3;
            }
            catch (Exception ex) {
                return -1;
            }
        }
        ClientResource authResource = new ClientResource(this.authReference);
        try {
            this.logger.fine("Post auth request to auth resource...");
            Representation resp = authResource.post((Representation)new JsonRepresentation(authRequest));
            JsonRepresentation jsonRepresentation = new JsonRepresentation(resp);
            jsonResponse = jsonRepresentation.getJsonObject();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
            return -1;
        }
        if (jsonResponse.has("error")) {
            try {
                String error = jsonResponse.getString("error");
                this.logger.warning(error);
                this.logger.warning(jsonResponse.getString("error_description"));
            }
            catch (JSONException ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
            return -1;
        }
        try {
            ClientInfo clientInfo = request.getClientInfo();
            clientInfo.setUser(new User(jsonResponse.getString("username")));
            clientInfo.setRoles(Scopes.toRoles(jsonResponse.getString("scope")));
        }
        catch (JSONException ex) {
            return -1;
        }
        return 4;
    }

    private static JSONObject createBearerAuthRequest(String token) throws JSONException {
        JSONObject request = new JSONObject();
        request.put("token_type", (Object)"Bearer");
        request.put("access_token", (Object)token);
        return request;
    }

    private String getAccessTokenFromQuery(Request request) {
        Form params = request.getOriginalRef().getQueryAsForm();
        String token = params.getFirstValue("access_token");
        if (token != null && !token.isEmpty()) {
            this.logger.fine("Found Bearer Token in URI query.");
            return token;
        }
        return null;
    }

    private String getAccessTokenFromBody(Request request) {
        Method method = request.getMethod();
        if (method.equals((Object)Method.GET)) {
            return null;
        }
        if (!request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
            return null;
        }
        Form form = new Form(request.getEntity());
        String token = form.getFirstValue("access_token");
        if (token == null || token.isEmpty()) {
            return null;
        }
        request.setEntity(form.getWebRepresentation());
        this.logger.fine("Found Bearer Token in Body.");
        return token;
    }

    public boolean isAcceptBodyMethod() {
        return this.acceptBodyMethod;
    }

    public void setAcceptBodyMethod(boolean acceptBodyMethod) {
        this.acceptBodyMethod = acceptBodyMethod;
    }

    public boolean isAcceptQueryMethod() {
        return this.acceptQueryMethod;
    }

    public void setAcceptQueryMethod(boolean acceptQueryMethod) {
        this.acceptQueryMethod = acceptQueryMethod;
    }
}

