/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.Arrays;
import java.util.Map;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Client;

public class MemoryClient
implements Client {
    private String clientId;
    private char[] clientSecret;
    private Client.ClientType clientType;
    private String[] redirectURIs;
    private Map<String, Object> properties;

    protected MemoryClient(String clientId, Client.ClientType clientType, String[] redirectURIs, Map<String, Object> properties) {
        this.clientId = clientId;
        this.clientType = clientType;
        this.redirectURIs = redirectURIs;
        this.properties = properties;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public char[] getClientSecret() {
        return this.clientSecret;
    }

    protected void setClientSecret(char[] clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public String[] getRedirectURIs() {
        return this.redirectURIs;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isResponseTypeAllowed(ResponseType responseType) {
        return this.isFlowSupported((Object)responseType);
    }

    @Override
    public boolean isGrantTypeAllowed(GrantType grantType) {
        return this.isFlowSupported((Object)grantType);
    }

    private boolean isFlowSupported(Object flow) {
        return Arrays.asList((Object[])this.properties.get("supported_flows")).contains(flow);
    }

    @Override
    public Client.ClientType getClientType() {
        return this.clientType;
    }
}

