/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.restlet.engine.util.Base64;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.ClientManager;

public abstract class AbstractClientManager
implements ClientManager {
    public static final int RESEED_CLIENTS = 100;
    public static final Object[] DEFAULT_SUPPORTED_FLOWS_PUBLIC = new Object[]{ResponseType.token};
    public static final Object[] DEFAULT_SUPPORTED_FLOWS_CONFIDENTIAL = new Object[]{ResponseType.code, GrantType.authorization_code, GrantType.client_credentials, GrantType.refresh_token};
    private SecureRandom random;
    private boolean issueClientSecretToPublicClients = false;
    private Map<Client.ClientType, Object[]> defaultSupportedFlow;
    private volatile int count = 0;

    public AbstractClientManager() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        this.defaultSupportedFlow = new EnumMap<Client.ClientType, Object[]>(Client.ClientType.class);
        this.defaultSupportedFlow.put(Client.ClientType.PUBLIC, DEFAULT_SUPPORTED_FLOWS_PUBLIC);
        this.defaultSupportedFlow.put(Client.ClientType.CONFIDENTIAL, DEFAULT_SUPPORTED_FLOWS_CONFIDENTIAL);
    }

    @Override
    public Client createClient(Client.ClientType clientType, String[] redirectURIs, Map<String, Object> properties) {
        Object[] flows;
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if ((flows = properties.get("supported_flows")) == null) {
            flows = this.defaultSupportedFlow.get((Object)clientType);
            properties.put("supported_flows", flows);
        }
        if ((clientType == Client.ClientType.PUBLIC || clientType == Client.ClientType.CONFIDENTIAL && Arrays.asList(flows).contains((Object)ResponseType.token)) && (redirectURIs == null || redirectURIs.length == 0)) {
            throw new IllegalArgumentException("RedirectionURI(s) required.");
        }
        String clientId = UUID.randomUUID().toString();
        char[] clientSecret = null;
        if (clientType == Client.ClientType.CONFIDENTIAL || clientType == Client.ClientType.PUBLIC && this.isIssueClientSecretToPublicClients()) {
            if (this.count++ > 100) {
                this.count = 0;
                this.random.setSeed(this.random.generateSeed(20));
            }
            byte[] secret = new byte[20];
            this.random.nextBytes(secret);
            clientSecret = Base64.encode((byte[])secret, (boolean)false).toCharArray();
        }
        return this.createClient(clientId, clientSecret, clientType, redirectURIs, properties);
    }

    protected abstract Client createClient(String var1, char[] var2, Client.ClientType var3, String[] var4, Map<String, Object> var5);

    public boolean isIssueClientSecretToPublicClients() {
        return this.issueClientSecretToPublicClients;
    }

    public void setIssueClientSecretToPublicClients(boolean issueClientSecretToPublicClients) {
        this.issueClientSecretToPublicClients = issueClientSecretToPublicClients;
    }

    public void setDefaultSupportedFlow(Client.ClientType clientType, Object[] flows) {
        if (flows == null) {
            throw new IllegalArgumentException("Flows cannot be null.");
        }
        for (Object o : flows) {
            if (o instanceof GrantType && o instanceof ResponseType) continue;
            throw new IllegalArgumentException("Unsupported flow type.");
        }
        this.defaultSupportedFlow.put(clientType, flows);
    }
}

