/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.ext.oauth.internal.AbstractClientManager;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.memory.MemoryClient;

public class MemoryClientManager
extends AbstractClientManager {
    private final Map<String, Client> clients = new ConcurrentHashMap<String, Client>();

    @Override
    protected Client createClient(String clientId, char[] clientSecret, Client.ClientType clientType, String[] redirectURIs, Map<String, Object> properties) {
        MemoryClient client = new MemoryClient(UUID.randomUUID().toString(), clientType, redirectURIs, properties);
        if (clientSecret != null) {
            client.setClientSecret(clientSecret);
        }
        this.clients.put(client.getClientId(), client);
        return client;
    }

    @Override
    public void deleteClient(String id) {
        this.clients.remove(id);
    }

    @Override
    public Client findById(String id) {
        return this.clients.get(id);
    }
}

