/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.EntryReader;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Mapping;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContentHandler<T>
extends EntryReader {
    List<String> eltPath;
    private T entity;
    private Class<?> entityClass;
    private EntityType entityType;
    private Logger logger;
    private Mapping mapping;
    private Metadata metadata;
    private boolean parseContent;
    private boolean parseEntry;
    private boolean parseProperties;
    private boolean parseProperty;
    private boolean parsePropertyNull;
    private List<String> propertyPath;
    private int propertyPathDeep = -1;
    StringBuilder sb = null;

    public EntryContentHandler(Class<?> entityClass, Metadata metadata, Logger logger) {
        this.entityClass = entityClass;
        this.metadata = metadata;
        this.entityType = metadata.getEntityType(entityClass);
        this.logger = logger;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.parseProperty || this.mapping != null) {
            this.sb.append(ch, start, length);
        }
    }

    public void endContent(Content content) {
        this.parseContent = false;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parseProperty) {
            if (!this.parsePropertyNull) {
                Object obj = this.entity;
                if (this.propertyPath.size() > 1) {
                    for (int i = 0; i < this.propertyPath.size() - 1; ++i) {
                        try {
                            Object o = ReflectUtils.invokeGetter(obj, this.propertyPath.get(i));
                            if (o == null) {
                                Field[] fields;
                                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                                    if (!field.getName().equalsIgnoreCase(this.propertyPath.get(i))) continue;
                                    o = field.getType().newInstance();
                                    break;
                                }
                            }
                            ReflectUtils.invokeSetter(obj, this.propertyPath.get(i), o);
                            obj = o;
                            continue;
                        }
                        catch (Exception e) {
                            obj = null;
                        }
                    }
                }
                Property property = this.metadata.getProperty(obj, localName);
                try {
                    ReflectUtils.setProperty(obj, property, this.sb.toString());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + localName + " property on " + obj + " with value " + this.sb.toString());
                }
            }
            --this.propertyPathDeep;
            boolean bl = this.parseProperty = this.propertyPathDeep > 0;
            if (this.propertyPath.size() > 0) {
                this.propertyPath.remove(this.propertyPath.size() - 1);
            }
        } else if (this.mapping != null) {
            if (this.sb != null) {
                try {
                    ReflectUtils.invokeSetter(this.entity, this.mapping.getPropertyPath(), this.sb.toString());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set the mapped property " + this.mapping.getPropertyPath() + " on " + this.entity + " with value " + this.sb.toString());
                }
            }
            this.mapping = null;
        } else if (this.parseProperties && "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(uri) && "properties".equals(localName)) {
            this.parseProperties = false;
        }
        if (!this.eltPath.isEmpty()) {
            this.eltPath.remove(this.eltPath.size() - 1);
        }
    }

    public void endEntry(Entry entry) {
        this.parseEntry = false;
        for (Mapping m : this.metadata.getMappings()) {
            if (this.entityType == null || !this.entityType.equals(m.getType()) || m.getNsUri() != null || m.getNsPrefix() != null) continue;
            Person author = entry.getAuthors().isEmpty() ? null : (Person)entry.getAuthors().get(0);
            Person contributor = entry.getContributors().isEmpty() ? null : (Person)entry.getContributors().get(0);
            Object value = null;
            if ("SyndicationAuthorEmail".equals(m.getValuePath())) {
                value = author != null ? author.getEmail() : null;
            } else if ("SyndicationAuthorName".equals(m.getValuePath())) {
                value = author != null ? author.getName() : null;
            } else if ("SyndicationAuthorUri".equals(m.getValuePath())) {
                value = author != null ? author.getUri().toString() : null;
            } else if ("SyndicationContributorEmail".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getEmail() : null;
            } else if ("SyndicationContributorName".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getName() : null;
            } else if ("SyndicationContributorUri".equals(m.getValuePath())) {
                value = contributor != null ? contributor.getUri().toString() : null;
            } else if ("SyndicationPublished".equals(m.getValuePath())) {
                value = entry.getPublished();
            } else if ("SyndicationRights".equals(m.getValuePath())) {
                value = entry.getRights() != null ? entry.getRights().getContent() : null;
            } else if ("SyndicationSummary".equals(m.getValuePath())) {
                value = entry.getSummary();
            } else if ("SyndicationTitle".equals(m.getValuePath())) {
                value = entry.getTitle() != null ? entry.getTitle().getContent() : null;
            } else if ("SyndicationUpdated".equals(m.getValuePath())) {
                value = entry.getUpdated();
            }
            try {
                if (value == null) continue;
                ReflectUtils.invokeSetter(this.entity, m.getPropertyPath(), value);
            }
            catch (Exception e) {
                this.getLogger().warning("Cannot set " + m.getPropertyPath() + " property on " + this.entity + " with value " + value);
            }
        }
        if (this.entityType.isBlob() && this.entityType.getBlobValueEditRefProperty() != null) {
            Link link = entry.getLink(Relation.EDIT_MEDIA);
            String pty = this.entityType.getBlobValueEditRefProperty().getName();
            if (link != null) {
                try {
                    ReflectUtils.invokeSetter(this.entity, pty, link.getHref());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set the property " + pty + " on " + this.entity + " with value " + link.getHref());
                }
            }
        }
    }

    public T getEntity() {
        return this.entity;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Context.getCurrentLogger();
        }
        return this.logger;
    }

    public void startContent(Content content) {
        this.parseContent = true;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block14: {
            block12: {
                String str;
                block15: {
                    block13: {
                        if (this.parseProperties && "http://schemas.microsoft.com/ado/2007/08/dataservices".equals(uri)) {
                            this.sb = new StringBuilder();
                            ++this.propertyPathDeep;
                            this.propertyPath.add(localName);
                            this.parseProperty = true;
                            this.parsePropertyNull = Boolean.parseBoolean(attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null"));
                        }
                        if (!this.parseContent) break block12;
                        if (!"http://schemas.microsoft.com/ado/2007/08/dataservices".equals(uri)) break block13;
                        this.sb = new StringBuilder();
                        this.parseProperties = true;
                        this.propertyPathDeep = 0;
                        this.propertyPath = new ArrayList<String>();
                        break block14;
                    }
                    if (!"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(uri) || !"properties".equals(localName)) break block15;
                    this.parseProperties = true;
                    this.propertyPathDeep = 0;
                    this.propertyPath = new ArrayList<String>();
                    break block14;
                }
                if (!this.entityType.isBlob() || this.entityType.getBlobValueRefProperty() == null || (str = attrs.getValue("src")) == null) break block14;
                try {
                    ReflectUtils.invokeSetter(this.entity, this.entityType.getBlobValueRefProperty().getName(), new Reference(str));
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot set " + this.entityType.getBlobValueRefProperty().getName() + " property on " + this.entity + " with value " + str);
                }
                break block14;
            }
            if (this.parseEntry) {
                if ("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata".equals(uri) && "properties".equals(localName) && this.entityType.isBlob()) {
                    this.parseProperties = true;
                    this.propertyPathDeep = 0;
                    this.propertyPath = new ArrayList<String>();
                } else {
                    this.eltPath.add(localName);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.eltPath.size(); ++i) {
                        if (i > 0) {
                            sb.append("/");
                        }
                        sb.append(this.eltPath.get(i));
                    }
                    String str = sb.toString();
                    for (Mapping m : this.metadata.getMappings()) {
                        if (this.entityType == null || !this.entityType.equals(m.getType()) || m.getNsUri() == null || !m.getNsUri().equals(uri) || !str.equals(m.getValueNodePath())) continue;
                        if (m.isAttributeValue()) {
                            String value = attrs.getValue(m.getValueAttributeName());
                            if (value == null) break;
                            try {
                                ReflectUtils.invokeSetter(this.entity, m.getPropertyPath(), value);
                            }
                            catch (Exception e) {
                                this.getLogger().warning("Cannot set " + m.getPropertyPath() + " property on " + this.entity + " with value " + value);
                            }
                            break;
                        }
                        this.sb = new StringBuilder();
                        this.mapping = m;
                        break;
                    }
                }
            }
        }
    }

    public void startEntry(Entry entry) {
        this.parseEntry = true;
        this.eltPath = new ArrayList<String>();
        try {
            this.entity = this.entityClass.newInstance();
        }
        catch (Exception e) {
            this.getLogger().warning("Error when instantiating  class " + this.entityClass);
        }
    }
}

