/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.edm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.ext.odata.internal.edm.Association;
import org.restlet.ext.odata.internal.edm.AssociationEnd;
import org.restlet.ext.odata.internal.edm.AssociationSet;
import org.restlet.ext.odata.internal.edm.AssociationSetEnd;
import org.restlet.ext.odata.internal.edm.ComplexProperty;
import org.restlet.ext.odata.internal.edm.ComplexType;
import org.restlet.ext.odata.internal.edm.EntityContainer;
import org.restlet.ext.odata.internal.edm.EntitySet;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.FunctionImport;
import org.restlet.ext.odata.internal.edm.Mapping;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.NamedObject;
import org.restlet.ext.odata.internal.edm.Namespace;
import org.restlet.ext.odata.internal.edm.NavigationProperty;
import org.restlet.ext.odata.internal.edm.Parameter;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.edm.Schema;
import org.restlet.ext.odata.internal.edm.Type;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataReader
extends DefaultHandler {
    private final String[] blobEditRefValues = new String[]{"blobEditReference", "blobEditReferenceValue"};
    private final String[] blobRefValues = new String[]{"blobReference", "blobReferenceValue"};
    private Association currentAssociation;
    private AssociationSet currentAssociationSet;
    private ComplexType currentComplexType;
    private EntityContainer currentEntityContainer;
    private EntityType currentEntityType;
    private FunctionImport currentFunctionImport;
    private Metadata currentMetadata;
    private Schema currentSchema;
    private Map<String, NamedObject> registeredAssociations;
    private Map<String, NamedObject> registeredComplexTypes;
    private Map<String, EntityContainer> registeredContainers;
    private Map<String, NamedObject> registeredEntitySets;
    private Map<String, NamedObject> registeredEntityTypes;
    private List<Namespace> registeredNamespaces;
    private List<State> states = new ArrayList<State>();

    public MetadataReader(Metadata metadata) {
        this.pushState(State.NONE);
        this.currentMetadata = metadata;
    }

    private String chooseAttributeName(EntityType type, String[] values) {
        NamedObject property;
        int i;
        String result = null;
        int index = 0;
        for (i = 0; i < type.getProperties().size() && index < values.length; ++i) {
            property = type.getProperties().get(i);
            if (!values[index].equals(property.getName())) continue;
            ++index;
        }
        for (i = 0; i < type.getAssociations().size() && index < values.length; ++i) {
            property = type.getAssociations().get(i);
            if (!values[index].equals(property.getName())) continue;
            ++index;
        }
        if (index != values.length) {
            result = values[index];
        }
        return result;
    }

    private void discoverMapping(EntityType type, Property property, Metadata metadata, Attributes attributes) {
        String atomContentKind = null;
        String nsPrefix = null;
        String nsUri = null;
        String propertyPath = null;
        String valuePath = null;
        boolean keepInContent = true;
        atomContentKind = attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_ContentKind");
        nsPrefix = attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsPrefix");
        nsUri = attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsUri");
        String str = attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_KeepInContent");
        if (str != null) {
            keepInContent = Boolean.parseBoolean(str);
        }
        propertyPath = property == null ? attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_SourcePath") : property.getName();
        valuePath = attributes.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_TargetPath");
        if (propertyPath != null && valuePath != null && !keepInContent && (atomContentKind != null && nsUri == null && nsPrefix == null || atomContentKind == null && nsUri != null && nsPrefix != null)) {
            metadata.getMappings().add(new Mapping(type, nsPrefix, nsUri, propertyPath, valuePath));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (Schema schema : this.currentMetadata.getSchemas()) {
            for (Association association : schema.getAssociations()) {
                for (AssociationEnd associationEnd : association.getEnds()) {
                    associationEnd.setType((EntityType)this.resolve(associationEnd.getType(), this.registeredEntityTypes, schema));
                }
            }
            for (EntityType entityType : schema.getEntityTypes()) {
                if (entityType.getKeys() != null) {
                    List<Property> props = entityType.getKeys();
                    entityType.setKeys(new ArrayList<Property>());
                    block4: for (Property prop : props) {
                        for (Property property : entityType.getProperties()) {
                            if (!property.equals(prop)) continue;
                            entityType.getKeys().add(property);
                            continue block4;
                        }
                    }
                }
                for (NavigationProperty navigationProperty : entityType.getAssociations()) {
                    navigationProperty.setRelationship((Association)this.resolve(navigationProperty.getRelationship(), this.registeredAssociations, schema));
                    if (navigationProperty.getRelationship() != null) {
                        for (AssociationEnd end : navigationProperty.getRelationship().getEnds()) {
                            if (end.getRole().equals(navigationProperty.getFromRole().getRole())) {
                                navigationProperty.setFromRole(end);
                                continue;
                            }
                            if (!end.getRole().equals(navigationProperty.getToRole().getRole())) continue;
                            navigationProperty.setToRole(end);
                        }
                        continue;
                    }
                    navigationProperty.setFromRole(null);
                    navigationProperty.setToRole(null);
                }
                entityType.setBaseType((EntityType)this.resolve(entityType.getBaseType(), this.registeredEntityTypes, schema));
            }
            for (ComplexType complexType : schema.getComplexTypes()) {
                complexType.setBaseType((ComplexType)this.resolve(complexType.getBaseType(), this.registeredComplexTypes, schema));
            }
        }
        for (EntityContainer container : this.currentMetadata.getContainers()) {
            if (container.getExtended() != null) {
                container.setExtended(this.registeredContainers.get(container.getExtended().getName()));
            }
            for (AssociationSet associationSet : container.getAssociations()) {
                associationSet.setAssociation((Association)this.resolve(associationSet.getAssociation(), this.registeredAssociations, container.getSchema()));
                block11: for (AssociationSetEnd associationSetEnd : associationSet.getEnds()) {
                    for (EntitySet entitySet : container.getEntities()) {
                        if (!entitySet.equals(associationSetEnd.getType())) continue;
                        associationSetEnd.setType(entitySet);
                        continue block11;
                    }
                }
            }
            for (EntitySet entitySet : container.getEntities()) {
                entitySet.setType((EntityType)this.resolve(entitySet.getType(), this.registeredEntityTypes, container.getSchema()));
            }
            for (FunctionImport functionImport : container.getFunctionImports()) {
                functionImport.setEntitySet((EntitySet)this.resolve(functionImport.getEntitySet(), this.registeredEntitySets, container.getSchema()));
            }
        }
        for (Schema schema : this.currentMetadata.getSchemas()) {
            for (EntityType entityType : schema.getEntityTypes()) {
                for (ComplexProperty complexProperty : entityType.getComplexProperties()) {
                    ComplexType type = (ComplexType)this.resolve(complexProperty.getComplexType(), this.registeredComplexTypes, schema);
                    if (type == null) continue;
                    complexProperty.setComplexType(type);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("schema".equalsIgnoreCase(localName)) {
            this.popState();
            this.currentSchema = null;
        } else if ("using".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("documentation".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("entityType".equalsIgnoreCase(localName)) {
            if (this.currentEntityType.isBlob()) {
                Property property;
                String memberName = this.chooseAttributeName(this.currentEntityType, this.blobRefValues);
                if (memberName == null) {
                    this.currentEntityType.setBlob(false);
                } else {
                    property = new Property(memberName);
                    this.currentEntityType.setBlobValueRefProperty(property);
                }
                memberName = this.chooseAttributeName(this.currentEntityType, this.blobEditRefValues);
                if (memberName == null) {
                    this.currentEntityType.setBlob(false);
                } else {
                    property = new Property(memberName);
                    this.currentEntityType.setBlobValueEditRefProperty(property);
                }
            }
            this.popState();
            this.currentEntityType = null;
        } else if ("key".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("property".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("navigationProperty".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("complexType".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("association".equalsIgnoreCase(localName)) {
            this.popState();
            this.currentAssociation = null;
        } else if ("end".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("onDelete".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("referentialConstraint".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("functionImport".equalsIgnoreCase(localName)) {
            this.currentFunctionImport = null;
            this.popState();
        } else if ("function".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("entityContainer".equalsIgnoreCase(localName)) {
            this.popState();
            this.currentEntityContainer = null;
        } else if ("entitySet".equalsIgnoreCase(localName)) {
            this.popState();
        } else if ("associationSet".equalsIgnoreCase(localName)) {
            this.popState();
            this.currentAssociationSet = null;
        } else if ("parameter".equalsIgnoreCase(localName)) {
            this.popState();
        }
    }

    private State getState() {
        State result = this.states.get(0);
        return result;
    }

    private State popState() {
        return this.states.remove(0);
    }

    private void pushState(State state) {
        this.states.add(0, state);
    }

    private NamedObject resolve(NamedObject namedObject, Map<String, NamedObject> register, Schema currentSchema) {
        NamedObject result = null;
        if (namedObject != null && namedObject.getName() != null) {
            String key = null;
            int index = namedObject.getName().lastIndexOf(".");
            if (index != -1) {
                String nsName = namedObject.getName().substring(0, index);
                for (Namespace namespace : this.registeredNamespaces) {
                    if (!nsName.equals(namespace.getAlias()) && !nsName.equals(namespace.getName())) continue;
                    key = namespace.getName() + namedObject.getName().substring(index);
                    break;
                }
            } else {
                key = currentSchema.getNamespace().getName() + "." + namedObject.getName();
            }
            result = register.get(key);
        }
        return result;
    }

    @Override
    public void startDocument() throws SAXException {
        this.registeredComplexTypes = new HashMap<String, NamedObject>();
        this.registeredEntityTypes = new HashMap<String, NamedObject>();
        this.registeredAssociations = new HashMap<String, NamedObject>();
        this.registeredEntitySets = new HashMap<String, NamedObject>();
        this.registeredNamespaces = new ArrayList<Namespace>();
        this.registeredContainers = new HashMap<String, EntityContainer>();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        if ("schema".equalsIgnoreCase(localName)) {
            this.pushState(State.SCHEMA);
            this.currentSchema = new Schema();
            this.currentMetadata.getSchemas().add(this.currentSchema);
            Namespace namespace = new Namespace(attrs.getValue("Namespace"));
            namespace.setAlias(attrs.getValue("Alias"));
            this.currentSchema.setNamespace(namespace);
            this.registeredNamespaces.add(namespace);
        } else if ("using".equalsIgnoreCase(localName)) {
            this.pushState(State.USING);
            Namespace namespace = new Namespace(attrs.getValue("Namespace"));
            namespace.setAlias(attrs.getValue("Alias"));
            this.currentSchema.getReferencedNamespaces().add(namespace);
        } else if ("documentation".equalsIgnoreCase(localName)) {
            this.pushState(State.DOCUMENTATION);
        } else if ("entityType".equalsIgnoreCase(localName)) {
            this.pushState(State.ENTITY_TYPE);
            this.currentEntityType = new EntityType(attrs.getValue("Name"));
            this.currentEntityType.setSchema(this.currentSchema);
            this.currentEntityType.setAbstractType(Boolean.parseBoolean(attrs.getValue("Abstract")));
            this.currentEntityType.setBlob(Boolean.parseBoolean(attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream")));
            String value = attrs.getValue("BaseType");
            if (value != null) {
                this.currentEntityType.setBaseType(new EntityType(value));
            }
            this.currentSchema.getEntityTypes().add(this.currentEntityType);
            this.discoverMapping(this.currentEntityType, null, this.currentMetadata, attrs);
            this.registeredEntityTypes.put(this.currentSchema.getNamespace().getName() + "." + this.currentEntityType.getName(), this.currentEntityType);
        } else if ("key".equalsIgnoreCase(localName)) {
            this.pushState(State.ENTITY_TYPE_KEY);
        } else if ("propertyRef".equalsIgnoreCase(localName)) {
            if (this.getState() == State.ENTITY_TYPE_KEY) {
                if (this.currentEntityType.getKeys() == null) {
                    this.currentEntityType.setKeys(new ArrayList<Property>());
                }
                this.currentEntityType.getKeys().add(new Property(attrs.getValue("Name")));
            }
        } else if ("property".equalsIgnoreCase(localName)) {
            Property property;
            String type = attrs.getValue("Type");
            if (type.toLowerCase().startsWith("edm.")) {
                property = new Property(attrs.getValue("Name"));
                property.setType(new Type(attrs.getValue("Type")));
            } else {
                ComplexProperty p = new ComplexProperty(attrs.getValue("Name"));
                p.setComplexType(new ComplexType(attrs.getValue("Type")));
                property = p;
            }
            property.setDefaultValue(attrs.getValue("Default"));
            property.setNullable(Boolean.parseBoolean(attrs.getValue("Nullable")));
            if ("fixed".equalsIgnoreCase(attrs.getValue("ConcurrencyMode"))) {
                property.setConcurrent(true);
            } else {
                property.setConcurrent(false);
            }
            property.setGetterAccess(attrs.getValue("GetterAccess"));
            property.setSetterAccess(attrs.getValue("SetterAccess"));
            String str = attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType");
            if (str != null) {
                property.setMediaType(MediaType.valueOf((String)str));
            }
            if (this.getState() == State.ENTITY_TYPE) {
                this.pushState(State.ENTITY_TYPE_PROPERTY);
                if (property instanceof ComplexProperty) {
                    this.currentEntityType.getComplexProperties().add((ComplexProperty)property);
                } else {
                    this.currentEntityType.getProperties().add(property);
                }
            } else {
                this.pushState(State.COMPLEX_TYPE_PROPERTY);
                this.currentComplexType.getProperties().add(property);
            }
            this.discoverMapping(this.currentEntityType, property, this.currentMetadata, attrs);
        } else if ("navigationProperty".equalsIgnoreCase(localName)) {
            this.pushState(State.NAVIGATION_PROPERTY);
            NavigationProperty property = new NavigationProperty(attrs.getValue("Name"));
            property.setFromRole(new AssociationEnd(attrs.getValue("FromRole")));
            property.setRelationship(new Association(attrs.getValue("Relationship")));
            property.setToRole(new AssociationEnd(attrs.getValue("ToRole")));
            this.currentEntityType.getAssociations().add(property);
        } else if ("complexType".equalsIgnoreCase(localName)) {
            this.pushState(State.COMPLEX_TYPE);
            this.currentComplexType = new ComplexType(attrs.getValue("Name"));
            this.currentComplexType.setSchema(this.currentSchema);
            String value = attrs.getValue("BaseType");
            if (value != null) {
                this.currentComplexType.setBaseType(new ComplexType(value));
            }
            this.currentSchema.getComplexTypes().add(this.currentComplexType);
            this.registeredComplexTypes.put(this.currentSchema.getNamespace().getName() + "." + this.currentComplexType.getName(), this.currentComplexType);
        } else if ("association".equalsIgnoreCase(localName)) {
            this.pushState(State.ASSOCIATION);
            this.currentAssociation = new Association(attrs.getValue("Name"));
            this.currentSchema.getAssociations().add(this.currentAssociation);
            this.registeredAssociations.put(this.currentSchema.getNamespace().getName() + "." + this.currentAssociation.getName(), this.currentAssociation);
        } else if ("end".equalsIgnoreCase(localName)) {
            if (this.getState() == State.ASSOCIATION) {
                this.pushState(State.ASSOCIATION_END);
                AssociationEnd end = new AssociationEnd(attrs.getValue("Role"));
                end.setMultiplicity(attrs.getValue("Multiplicity"));
                end.setType(new EntityType(attrs.getValue("Type")));
                this.currentAssociation.getEnds().add(end);
            } else {
                this.pushState(State.ASSOCIATION_SET_END);
                AssociationSetEnd end = new AssociationSetEnd(attrs.getValue("Role"));
                end.setType(new EntitySet(attrs.getValue("EntitySet")));
                this.currentAssociationSet.getEnds().add(end);
            }
        } else if ("onDelete".equalsIgnoreCase(localName)) {
            this.pushState(State.ON_DELETE);
        } else if ("referentialConstraint".equalsIgnoreCase(localName)) {
            this.pushState(State.REFERENTIAL_CONSTRAINT);
        } else if ("functionImport".equalsIgnoreCase(localName)) {
            this.currentFunctionImport = new FunctionImport(attrs.getValue("Name"));
            this.currentFunctionImport.setReturnType(attrs.getValue("ReturnType"));
            this.currentFunctionImport.setEntitySet(new EntitySet(attrs.getValue("EntitySet")));
            this.currentFunctionImport.setMethodAccess(attrs.getValue("MethodAccess"));
            this.currentFunctionImport.setMetadata(this.currentMetadata);
            String str = attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod");
            if (str != null) {
                this.currentFunctionImport.setMethod(Method.valueOf((String)str));
            }
            if (State.ENTITY_CONTAINER == this.getState()) {
                this.currentEntityContainer.getFunctionImports().add(this.currentFunctionImport);
            }
            this.pushState(State.FUNCTION_IMPORT);
        } else if ("parameter".equalsIgnoreCase(localName)) {
            if (State.FUNCTION_IMPORT == this.getState()) {
                Parameter parameter = new Parameter(attrs.getValue("Name"));
                parameter.setType(attrs.getValue("Type"));
                parameter.setMode(attrs.getValue("Mode"));
                String str = attrs.getValue("MaxLength");
                if (str != null) {
                    parameter.setMaxLength(Integer.parseInt(str));
                }
                if ((str = attrs.getValue("Precision")) != null) {
                    parameter.setPrecision(Integer.parseInt(str));
                }
                if ((str = attrs.getValue("Scale")) != null) {
                    parameter.setScale(Integer.parseInt(str));
                }
                this.currentFunctionImport.getParameters().add(parameter);
            }
            this.pushState(State.PARAMETER);
        } else if ("function".equalsIgnoreCase(localName)) {
            this.pushState(State.FUNCTION);
        } else if ("entityContainer".equalsIgnoreCase(localName)) {
            this.pushState(State.ENTITY_CONTAINER);
            this.currentEntityContainer = new EntityContainer(attrs.getValue("Name"));
            this.currentEntityContainer.setDefaultEntityContainer(Boolean.parseBoolean(attrs.getValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
            String value = attrs.getValue("Extends");
            if (value != null) {
                this.currentEntityContainer.setExtended(new EntityContainer(value));
            }
            this.currentEntityContainer.setSchema(this.currentSchema);
            this.currentMetadata.getContainers().add(this.currentEntityContainer);
            this.registeredContainers.put(this.currentSchema.getNamespace().getName() + "." + this.currentEntityContainer.getName(), this.currentEntityContainer);
        } else if ("entitySet".equalsIgnoreCase(localName)) {
            this.pushState(State.ENTITY_SET);
            EntitySet entitySet = new EntitySet(attrs.getValue("Name"));
            this.registeredEntitySets.put(this.currentSchema.getNamespace().getName() + "." + entitySet.getName(), entitySet);
            entitySet.setType(new EntityType(attrs.getValue("EntityType")));
            this.currentEntityContainer.getEntities().add(entitySet);
        } else if ("associationSet".equalsIgnoreCase(localName)) {
            this.pushState(State.ASSOCIATION_SET);
            this.currentAssociationSet = new AssociationSet(attrs.getValue("Name"));
            this.currentAssociationSet.setAssociation(new Association(attrs.getValue("Association")));
            this.currentEntityContainer.getAssociations().add(this.currentAssociationSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ASSOCIATION,
        ASSOCIATION_END,
        ASSOCIATION_SET,
        ASSOCIATION_SET_END,
        COMPLEX_TYPE,
        COMPLEX_TYPE_PROPERTY,
        DOCUMENTATION,
        ENTITY_CONTAINER,
        ENTITY_SET,
        ENTITY_TYPE,
        ENTITY_TYPE_KEY,
        ENTITY_TYPE_PROPERTY,
        FUNCTION,
        FUNCTION_IMPORT,
        NAVIGATION_PROPERTY,
        NONE,
        ON_DELETE,
        PARAMETER,
        REFERENTIAL_CONSTRAINT,
        SCHEMA,
        USING;

    }
}

