/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid;

import java.util.HashMap;
import java.util.Map;
import org.restlet.data.Metadata;
import org.restlet.engine.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeExchange
extends Metadata {
    private static volatile Map<String, AttributeExchange> _attributes;
    public static final AttributeExchange COUNTRY;
    public static final AttributeExchange DOB;
    public static final AttributeExchange EMAIL;
    public static final AttributeExchange FIRST_NAME;
    public static final AttributeExchange FRIENDLY_NAME;
    public static final AttributeExchange FULL_NAME;
    public static final AttributeExchange GENDER;
    public static final AttributeExchange LANGUAGE;
    public static final AttributeExchange LAST_NAME;
    public static final AttributeExchange TIMEZONE;
    public static final AttributeExchange ZIP;
    private volatile String schema;

    private static Map<String, AttributeExchange> getAttributes() {
        if (_attributes == null) {
            _attributes = new HashMap<String, AttributeExchange>();
        }
        return _attributes;
    }

    public static synchronized AttributeExchange register(String name, String schema, String description) {
        if (!AttributeExchange.getAttributes().containsKey(name)) {
            AttributeExchange ax = new AttributeExchange(name, schema, description);
            AttributeExchange.getAttributes().put(name, ax);
        }
        return AttributeExchange.getAttributes().get(name);
    }

    public static AttributeExchange valueOf(String name) {
        AttributeExchange result = null;
        if (name != null && !name.equals("")) {
            result = AttributeExchange.getAttributes().get(name);
        }
        return result;
    }

    public static AttributeExchange valueOfType(String schema) {
        if (schema != null && !schema.equals("")) {
            for (AttributeExchange ax : AttributeExchange.getAttributes().values()) {
                if (!ax.getSchema().equals(schema)) continue;
                return ax;
            }
        }
        return null;
    }

    public AttributeExchange(String name, String schema, String description) {
        super(name, description);
        this.schema = schema;
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeExchange) {
            return this.getName().equals(((AttributeExchange)((Object)object)).getName());
        }
        return false;
    }

    public Metadata getParent() {
        return null;
    }

    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.getName(), this.getSchema()});
    }

    public boolean includes(Metadata included) {
        return this.equals(included);
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    static {
        COUNTRY = AttributeExchange.register("country", "http://axschema.org/contact/country/home", "Country of residence");
        DOB = AttributeExchange.register("dob", "http://axschema.org/birthDate", "Date of birth");
        EMAIL = AttributeExchange.register("email", "http://axschema.org/contact/email", "email");
        FIRST_NAME = AttributeExchange.register("first", "http://axschema.org/namePerson/first", "Given name");
        FRIENDLY_NAME = AttributeExchange.register("friendly", "http://axschema.org/namePerson/friendly", "Friendly name");
        FULL_NAME = AttributeExchange.register("fullname", "http://axschema.org/namePerson", "Fullname");
        GENDER = AttributeExchange.register("gender", "http://axschema.org/person/gender", "Gender");
        LANGUAGE = AttributeExchange.register("language", "http://axschema.org/pref/language", "Preferred language");
        LAST_NAME = AttributeExchange.register("last", "http://axschema.org/namePerson/last", "Surname");
        TIMEZONE = AttributeExchange.register("timezone", "http://axschema.org/pref/timezone", "Preferred timezone");
        ZIP = AttributeExchange.register("postcode", "http://axschema.org/contact/postalCode/home", "Home zip code");
    }
}

