/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.ext.openid.AttributeExchange;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayingParty {
    private final ConsumerManager cm;
    private final Map<String, DiscoveryInformation> sessions;

    private static Representation getForm(AuthRequest authReq) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<title>OpenID HTML FORM Redirection</title>");
        sb.append("</head>");
        sb.append("<body onload=\"document.forms['openid-form-redirection'].submit();\">");
        sb.append("<form name=\"openid-form-redirection\" action=\"");
        sb.append(authReq.getOPEndpoint());
        sb.append("\" method=\"post\" accept-charset=\"utf-8\">");
        for (Object key : authReq.getParameterMap().keySet()) {
            sb.append(" <input type=\"hidden\" name=\"");
            sb.append(key.toString());
            sb.append("\" value=\"");
            sb.append(authReq.getParameterMap().get(key));
            sb.append("\"/>");
        }
        sb.append("</form>");
        sb.append("</body>");
        sb.append("</html>");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public RelayingParty() {
        this(new ConsumerManager());
    }

    public RelayingParty(ConsumerManager cm) {
        this.cm = cm;
        this.sessions = new HashMap<String, DiscoveryInformation>();
    }

    public String authRequest(String identifier, boolean sessionAware, boolean addReturnTo, String returnTo, Set<AttributeExchange> optionalAttrs, Set<AttributeExchange> requiredAttrs, Request req, Response res) throws Exception {
        Reference ref;
        List discoveries = this.cm.discover(identifier);
        DiscoveryInformation di = this.cm.associate(discoveries);
        String sessionId = null;
        if (sessionAware && di != null) {
            this.getLogger().info("save discovery information to session");
            sessionId = UUID.randomUUID().toString();
            this.sessions.put(sessionId, di);
            ref = new Reference(returnTo);
            ref.addQueryParameter("sessionId", sessionId);
            returnTo = ref.toString();
        }
        if (addReturnTo) {
            ref = new Reference(returnTo);
            ref.addQueryParameter("returnTo", "true");
            returnTo = ref.toString();
        }
        AuthRequest authReq = this.cm.authenticate(di, returnTo);
        FetchRequest fetch = null;
        if (optionalAttrs != null) {
            fetch = FetchRequest.createFetchRequest();
            for (AttributeExchange o : optionalAttrs) {
                fetch.addAttribute(o.getName(), o.getSchema(), false);
            }
        }
        if (requiredAttrs != null) {
            if (fetch == null) {
                fetch = FetchRequest.createFetchRequest();
            }
            for (AttributeExchange r : requiredAttrs) {
                fetch.addAttribute(r.getName(), r.getSchema(), true);
            }
        }
        if (fetch != null) {
            authReq.addExtension((MessageExtension)fetch);
        }
        if (di.isVersion2()) {
            this.getLogger().info("sending auth request using OpenId 2 form");
            res.setEntity(RelayingParty.getForm(authReq));
        } else {
            this.getLogger().info("sending auth request using OpenId 1 query parameters");
            res.redirectTemporary(authReq.getDestinationUrl(true));
        }
        return sessionId;
    }

    public Logger getLogger() {
        Logger result = null;
        Context context = Context.getCurrent();
        if (context != null) {
            result = context.getLogger();
        }
        if (result == null) {
            result = Engine.getLogger((Object)this, (String)"org.restlet.ext.openid.RP");
        }
        return result;
    }

    public boolean hasReturnTo(Request request) {
        String val = request.getResourceRef().getQueryAsForm().getFirstValue("returnTo");
        return "true".equals(val);
    }

    public Identifier verify(Map<AttributeExchange, String> axResp, Request req, boolean sessionAware) throws Exception {
        AuthSuccess authSuccess;
        VerificationResult verification;
        Identifier verified;
        Form params = req.getResourceRef().getQueryAsForm();
        ParameterList response = new ParameterList(params.getValuesMap());
        String sessionId = sessionAware ? params.getFirstValue("sessionId") : null;
        DiscoveryInformation discovered = sessionId != null ? this.sessions.get(sessionId) : null;
        this.getLogger().info("retrieved discovery information from session: (" + sessionId + ") " + discovered);
        String received = req.getResourceRef().getHostIdentifier() + req.getResourceRef().getPath();
        if (req.getResourceRef().hasQuery()) {
            received = received + "?" + req.getResourceRef().getQuery();
        }
        if ((verified = (verification = this.cm.verify(received, response, discovered)).getVerifiedId()) != null && (authSuccess = (AuthSuccess)verification.getAuthResponse()).hasExtension("http://openid.net/srv/ax/1.0")) {
            FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            MessageExtension ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            if (ext instanceof FetchResponse) {
                List aliases = fetchResp.getAttributeAliases();
                for (String alias : aliases) {
                    String value = fetchResp.getAttributeValue(alias);
                    axResp.put(AttributeExchange.valueOf(alias), value);
                }
            }
        }
        return verified;
    }
}

