/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid;

import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openid4java.server.ServerManager;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class XrdsServerResource
extends ServerResource {
    public static final String TYPE_RETURN_TO = "http://specs.openid.net/auth/2.0/return_to";
    public static final String TYPE_SERVER = "http://specs.openid.net/auth/2.0/server";
    public static final String TYPE_SIGNON = "http://specs.openid.net/auth/2.0/signon";

    private Document createDocument(String type, String uri, String localId) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("xrds:XRDS");
        root.setAttribute("xmlns:xrds", "xri://$xrds");
        root.setAttribute("xmlns:openid", "http://openid.net/xmlns/1.0");
        root.setAttribute("xmlns", "xri://$xrd*($v*2.0)");
        doc.appendChild(root);
        Element xrd = doc.createElement("XRD");
        root.appendChild(xrd);
        Element service = doc.createElement("Service");
        xrd.appendChild(service);
        Element typeElement = doc.createElement("Type");
        typeElement.appendChild(doc.createTextNode(type));
        service.appendChild(typeElement);
        Element uriElement = doc.createElement("URI");
        uriElement.appendChild(doc.createTextNode(uri));
        service.appendChild(uriElement);
        if (localId != null) {
            Element localIdElement = doc.createElement("LocalID");
            localIdElement.appendChild(doc.createTextNode(localId));
            service.appendChild(localIdElement);
        }
        return doc;
    }

    @Get(value="form")
    public Representation represent() throws ParserConfigurationException {
        Document response = null;
        ConcurrentMap attribs = this.getContext().getAttributes();
        ServerManager manager = (ServerManager)attribs.get("openid_manager");
        String opEndpoint = manager.getOPEndpointUrl();
        Form query = this.getQuery();
        String returnTo = query.getFirstValue("returnTo");
        if (returnTo != null && returnTo.length() > 0) {
            response = this.createDocument(TYPE_RETURN_TO, returnTo, null);
        } else {
            String id = query.getFirstValue("id");
            if (id == null || id.length() == 0) {
                response = this.createDocument(TYPE_SERVER, opEndpoint, null);
            } else {
                StringBuilder localId = new StringBuilder();
                localId.append(opEndpoint);
                localId.append("?id=");
                localId.append(id);
                response = this.createDocument(TYPE_SIGNON, opEndpoint, localId.toString());
            }
        }
        MediaType xrds = new MediaType("application/xrds+xml");
        return new DomRepresentation(xrds, response);
    }
}

