/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Consumer
extends ServerResource {
    public static final ConcurrentHashMap<String, String> ax = new ConcurrentHashMap(9);
    public static final String DESCRIPTOR_COOKIE = "openid-disc";
    private static Discovery discovery = new Discovery();
    private static ConcurrentHashMap<String, ConsumerManager> managers = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Object> session = new ConcurrentHashMap();
    private Logger log;

    protected void doInit() throws ResourceException {
        super.doInit();
        this.log = this.getLogger();
    }

    private Representation generateForm(AuthRequest authReq) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<title>OpenID HTML FORM Redirection</title>");
        sb.append("</head>");
        sb.append("<body onload=\"document.forms['openid-form-redirection'].submit();\">");
        sb.append("<form name=\"openid-form-redirection\" action=\"");
        sb.append(authReq.getOPEndpoint());
        sb.append("\" method=\"post\" accept-charset=\"utf-8\">");
        for (Object key : authReq.getParameterMap().keySet()) {
            sb.append(" <input type=\"hidden\" name=\"");
            sb.append(key.toString());
            sb.append("\" value=\"");
            sb.append(authReq.getParameterMap().get(key));
            sb.append("\"/>");
        }
        sb.append("</form>");
        sb.append("</body>");
        sb.append("</html>");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    private ConsumerManager getManager(String OPUri) {
        this.log.fine("Getting consumer manager for - " + OPUri);
        if (!managers.containsKey(OPUri)) {
            this.log.fine("Creating new consumer manager for - " + OPUri);
            ConsumerManager cm = new ConsumerManager();
            cm.setConnectTimeout(30000);
            cm.setSocketTimeout(30000);
            cm.setFailedAssocExpire(0);
            managers.put(OPUri, cm);
            return cm;
        }
        return managers.get(OPUri);
    }

    protected Representation head() throws ResourceException {
        this.getLogger().fine("IN head() OpenIDResource");
        this.setXRDSHeader();
        this.getLogger().fine("Sending empty representation.");
        return new EmptyRepresentation();
    }

    @Get(value="html")
    public Representation represent() {
        Form params = this.getQuery();
        this.log.fine("OpenIDResource : " + params);
        String rc = params.getFirstValue("return");
        if (rc != null && rc.length() > 0) {
            HashMap<String, String> axRequired = new HashMap<String, String>();
            HashMap<String, String> axOptional = new HashMap<String, String>();
            Identifier i = this.verifyResponse(axRequired, axOptional);
            if (i == null) {
                this.log.warning("Authentication Failed");
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new StringRepresentation((CharSequence)"Authentication Failed");
            }
            this.log.fine("Identifier = " + i.getIdentifier());
            String id = i.getIdentifier();
            if (id != null) {
                JSONObject obj = new JSONObject();
                try {
                    obj.put("id", (Object)i.getIdentifier());
                    for (String s : axRequired.keySet()) {
                        obj.put(s, axRequired.get(s));
                    }
                    for (String s : axOptional.keySet()) {
                        obj.put(s, axOptional.get(s));
                    }
                }
                catch (JSONException e) {
                    this.log.log(Level.WARNING, "Failed to get the ID!", e);
                }
                this.getResponse().setEntity((Representation)new JsonRepresentation(obj));
            }
            this.getResponse().getCookieSettings().remove((Object)DESCRIPTOR_COOKIE);
            CookieSetting disc = new CookieSetting(DESCRIPTOR_COOKIE, "");
            disc.setMaxAge(0);
            this.getResponse().getCookieSettings().add((Object)disc);
            return this.getResponse().getEntity();
        }
        String target = params.getFirstValue("openid_identifier");
        if (target == null || target.length() == 0) {
            String location = this.setXRDSHeader();
            StringBuilder html = new StringBuilder();
            html.append("<html><head><meta http-equiv=\"X-XRDS-Location\" content=\"");
            html.append(location);
            html.append("\"/></head></html>");
            return new StringRepresentation((CharSequence)html.toString(), MediaType.TEXT_HTML);
        }
        try {
            String[] required;
            String[] optional;
            StringBuilder returnToUrl = new StringBuilder();
            returnToUrl.append(this.getReference().getBaseRef());
            returnToUrl.append("?return=true");
            List discoveries = null;
            discoveries = discovery.discover(target);
            for (Object o : discoveries) {
                if (!(o instanceof DiscoveryInformation)) continue;
                DiscoveryInformation di = (DiscoveryInformation)o;
                this.log.fine("Found - " + di.getOPEndpoint());
                target = di.getOPEndpoint().toString();
            }
            ConsumerManager manager = this.getManager(target);
            DiscoveryInformation discovered = manager.associate(discoveries);
            String sessionId = String.valueOf(System.identityHashCode(discovered));
            session.put(sessionId, discovered);
            this.getResponse().getCookieSettings().add((Object)new CookieSetting(DESCRIPTOR_COOKIE, sessionId));
            this.log.fine("Setting DESCRIPTOR COOKIE");
            AuthRequest authReq = manager.authenticate(discovered, returnToUrl.toString());
            this.log.fine("OpenID - REALM = " + this.getReference().getBaseRef());
            authReq.setRealm(this.getReference().getBaseRef().toString());
            FetchRequest fetch = null;
            for (String o : optional = params.getValuesArray("ax_optional", true)) {
                if (!ax.containsKey(o)) {
                    this.log.warning("Not supported AX extension : " + o);
                    continue;
                }
                if (fetch == null) {
                    fetch = FetchRequest.createFetchRequest();
                }
                fetch.addAttribute(o, ax.get(o), false);
            }
            for (String r : required = params.getValuesArray("ax_required", true)) {
                if (!ax.containsKey(r)) {
                    this.log.warning("Not supported AX extension : " + r);
                    continue;
                }
                if (fetch == null) {
                    fetch = FetchRequest.createFetchRequest();
                }
                fetch.addAttribute(r, ax.get(r), true);
            }
            if (fetch != null) {
                authReq.addExtension((MessageExtension)fetch);
            }
            if (!discovered.isVersion2()) {
                this.log.fine("REDIRECTING TEMPORARY");
                this.redirectTemporary(authReq.getDestinationUrl(true));
                return null;
            }
            Form msg = new Form();
            for (Object key : authReq.getParameterMap().keySet()) {
                msg.add(key.toString(), authReq.getParameterValue(key.toString()));
                this.log.fine("Adding to form - key " + key.toString() + " : value" + authReq.getParameterValue(key.toString()));
            }
            return this.generateForm(authReq);
        }
        catch (DiscoveryException e) {
            e.printStackTrace();
        }
        catch (MessageException e) {
            e.printStackTrace();
        }
        catch (ConsumerException e) {
            e.printStackTrace();
        }
        return this.getResponse().getEntity();
    }

    private String setXRDSHeader() {
        String returnTo;
        ConcurrentMap attribs = this.getContext().getAttributes();
        Reference xrds = new Reference(attribs.get("xrds").toString());
        if ("localhost".equals(xrds.getHostDomain())) {
            xrds.setHostDomain(this.getReference().getBaseRef().getHostDomain());
            xrds.setHostPort(Integer.valueOf(this.getReference().getBaseRef().getHostPort()));
        }
        String location = (returnTo = this.getReference().getBaseRef().toString()) != null ? xrds.toString() + "?returnTo=" + returnTo : xrds.toString();
        this.getLogger().fine("XRDS endpoint = " + xrds);
        Form headers = (Form)this.getResponse().getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Form();
            headers.add("X-XRDS-Location", location);
            this.getResponse().getAttributes().put("org.restlet.http.headers", headers);
        } else {
            headers.add("X-XRDS-Location", location);
        }
        return location;
    }

    public Identifier verifyResponse(Map<String, String> axRequired, Map<String, String> axOptional) {
        try {
            Logger.getLogger("").setLevel(Level.FINEST);
            ParameterList response = new ParameterList(this.getQuery().getValuesMap());
            this.log.fine("response = " + response);
            this.log.fine("GET COOKIES");
            String openidDisc = this.getCookies().getFirstValue(DESCRIPTOR_COOKIE);
            this.log.fine("openIdDiscServer - " + this.getCookieSettings().getFirstValue("DESCRIPTOR_COOKIE"));
            this.log.fine("openIdDiscServerLength -" + this.getCookieSettings().size());
            this.log.fine("openIdDiscClient - " + openidDisc);
            this.log.fine("openIdDiscClientLength -" + this.getCookies().size());
            if (this.getCookieSettings().size() > 0) {
                for (CookieSetting setting : this.getCookieSettings()) {
                    this.log.fine("CookieSetting: " + setting.getName() + setting.getValue());
                }
            }
            if (this.getCookies().size() > 0) {
                for (CookieSetting setting : this.getCookies()) {
                    this.log.fine("Cookie: " + setting.getName() + setting.getValue());
                }
            }
            DiscoveryInformation discovered = (DiscoveryInformation)session.get(openidDisc);
            this.log.fine("discovered = " + discovered);
            this.log.fine("getOriginalRef = " + this.getOriginalRef());
            this.log.fine("OpenID disc : " + discovered.getOPEndpoint());
            this.log.fine("OpenID orig ref : " + this.getOriginalRef());
            ConsumerManager manager = this.getManager(discovered.getOPEndpoint().toString());
            VerificationResult verification = manager.verify(this.getOriginalRef().toString(), response, discovered);
            this.log.fine("verification = " + verification);
            Identifier verified = verification.getVerifiedId();
            this.log.fine("verified = " + verified);
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    FetchRequest fetchResp = (FetchRequest)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    MessageExtension ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    if (ext instanceof FetchRequest) {
                        Map required = fetchResp.getAttributes(true);
                        axRequired.putAll(required);
                        Map optional = fetchResp.getAttributes(false);
                        axOptional.putAll(optional);
                    }
                }
                return verified;
            }
        }
        catch (OpenIDException e) {
            this.log.log(Level.INFO, "", e);
        }
        this.log.setLevel(Level.INFO);
        return null;
    }

    static {
        ax.put("nickname", "http://axschema.org/namePerson/friendly");
        ax.put("email", "http://axschema.org/contact/email");
        ax.put("fullname", "http://axschema.org/namePerson");
        ax.put("dob", "http://axschema.org/birthDate");
        ax.put("gender", "http://axschema.org/person/gender");
        ax.put("postcode", "http://axschema.org/contact/postalCode/home");
        ax.put("country", "http://axschema.org/contact/country/home");
        ax.put("language", "http://axschema.org/pref/language");
        ax.put("timezone", "http://axschema.org/pref/timezone");
    }
}

