/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid.internal;

import java.util.Set;
import org.restlet.ext.openid.AttributeExchange;
import org.restlet.security.User;

public class OpenIdUser
extends User {
    private volatile boolean approved;
    private volatile Set<AttributeExchange> attributes;
    private volatile String claimedId;

    public static void setValueFromAX(AttributeExchange attribute, String value, User u) {
        if (attribute == AttributeExchange.EMAIL) {
            u.setEmail(value);
        } else if (attribute == AttributeExchange.FIRST_NAME) {
            u.setFirstName(value);
        } else if (attribute == AttributeExchange.LAST_NAME) {
            u.setLastName(value);
        }
    }

    public OpenIdUser() {
    }

    public OpenIdUser(String identifier) {
        super(identifier);
    }

    public OpenIdUser(String identifier, char[] secret) {
        super(identifier, secret);
    }

    public OpenIdUser(String identifier, char[] secret, String firstName, String lastName, String email) {
        super(identifier, secret, firstName, lastName, email);
    }

    public OpenIdUser(String identifier, String secret) {
        super(identifier, secret);
    }

    public OpenIdUser(String identifier, String secret, String firstName, String lastName, String email) {
        super(identifier, secret, firstName, lastName, email);
    }

    public Set<AttributeExchange> attributes() {
        return this.attributes;
    }

    public boolean getApproved() {
        return this.approved;
    }

    public String getAXValue(AttributeExchange attribute) {
        if (attribute == AttributeExchange.FULL_NAME) {
            return this.getName();
        }
        if (attribute == AttributeExchange.EMAIL) {
            return this.getEmail();
        }
        if (attribute == AttributeExchange.FIRST_NAME) {
            return this.getFirstName();
        }
        if (attribute == AttributeExchange.LAST_NAME) {
            return this.getLastName();
        }
        return null;
    }

    public String getClaimedId() {
        return this.claimedId;
    }

    public boolean setApproved(boolean approved) {
        this.approved = approved;
        return this.approved;
    }

    public void setAttributes(Set<AttributeExchange> attributes) {
        this.attributes = attributes;
    }

    public void setClaimedId(String claimedId) {
        this.claimedId = claimedId;
    }

    public void setValueFromAX(AttributeExchange attribute, String value) {
        OpenIdUser.setValueFromAX(attribute, value, this);
    }
}

