/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rome;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.rome.SyndFeedRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RomeConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ATOM = new VariantInfo(MediaType.APPLICATION_ATOM);
    private static final VariantInfo VARIANT_APPLICATION_RSS = new VariantInfo(MediaType.APPLICATION_RSS);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_ATOM.isCompatible(source) || VARIANT_APPLICATION_RSS.isCompatible(source)) {
            result = this.addObjectClass(result, SyndFeed.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (SyndFeed.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ATOM);
            result = this.addVariant(result, VARIANT_APPLICATION_RSS);
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (source != null && SyndFeed.class.isAssignableFrom(target)) {
            result = 1.0f;
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        if (source instanceof SyndFeed) {
            return 1.0f;
        }
        return -1.0f;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        SyndFeed result = null;
        if (SyndFeed.class.isAssignableFrom(target)) {
            result = source instanceof SyndFeedRepresentation ? ((SyndFeedRepresentation)source).getFeed() : new SyndFeedRepresentation(source).getFeed();
        }
        return target.cast(result);
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) throws IOException {
        if (source instanceof SyndFeed) {
            return new SyndFeedRepresentation((SyndFeed)source);
        }
        return null;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        if (SyndFeed.class.isAssignableFrom(entity)) {
            this.updatePreferences(preferences, MediaType.APPLICATION_ATOM, 1.0f);
            this.updatePreferences(preferences, MediaType.APPLICATION_RSS, 1.0f);
        }
    }
}

