/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.engine.security.SslUtils;
import org.restlet.ext.simple.SimpleServerHelper;
import org.restlet.ext.simple.internal.SimpleContainer;
import org.restlet.ext.simple.internal.SimpleServer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;

public class HttpsServerHelper
extends SimpleServerHelper {
    private SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", this.getKeystorePassword());
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean isNeedClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("needClientAuthentication", "false"));
    }

    public boolean isWantClientAuthentication() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("wantClientAuthentication", "false"));
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void start() throws Exception {
        SSLContext sslContext;
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory((RestletHelper)this);
        if (sslContextFactory == null) {
            KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
            FileInputStream fis = this.getKeystorePath() == null ? null : new FileInputStream(this.getKeystorePath());
            char[] password = this.getKeystorePassword() == null ? null : this.getKeystorePassword().toCharArray();
            keyStore.load(fis, password);
            if (fis != null) {
                fis.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.getCertAlgorithm());
            keyManagerFactory.init(keyStore, this.getKeyPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.getCertAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext = SSLContext.getInstance(this.getSslProtocol());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        } else {
            sslContext = sslContextFactory.createSslContext();
        }
        String addr = ((Server)this.getHelped()).getAddress();
        if (addr != null) {
            InetAddress iaddr = InetAddress.getByName(addr);
            this.setAddress(new InetSocketAddress(iaddr, ((Server)this.getHelped()).getPort()));
        } else {
            int port = ((Server)this.getHelped()).getPort();
            if (port > 0) {
                this.setAddress(new InetSocketAddress(((Server)this.getHelped()).getPort()));
            }
        }
        SimpleContainer container = new SimpleContainer(this);
        ContainerServer server = new ContainerServer((Container)container, this.getDefaultThreads());
        SimpleServer filter = new SimpleServer((org.simpleframework.transport.Server)server);
        SocketConnection connection = new SocketConnection((org.simpleframework.transport.Server)filter);
        this.setSslContext(sslContext);
        this.setConfidential(true);
        this.setContainerServer(server);
        this.setConnection((Connection)connection);
        InetSocketAddress address = (InetSocketAddress)this.getConnection().connect((SocketAddress)this.getAddress(), this.getSslContext());
        this.setEphemeralPort(address.getPort());
        super.start();
    }
}

