/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Method;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.Header;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.util.Series;
import org.simpleframework.http.Request;

public class SimpleCall
extends ServerCall {
    private final Request request;
    private volatile boolean requestHeadersAdded;
    private final org.simpleframework.http.Response response;
    private final String version;

    SimpleCall(Server server, Request request, org.simpleframework.http.Response response, boolean confidential) {
        super(server);
        this.version = request.getMajor() + "." + request.getMinor();
        this.request = request;
        this.response = response;
        this.setConfidential(confidential);
        this.requestHeadersAdded = false;
    }

    public boolean abort() {
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void flushBuffers() throws IOException {
        this.response.commit();
    }

    public void complete() {
        try {
            this.response.commit();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unable to commit the response", ex);
        }
    }

    public List<Certificate> getCertificates() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            try {
                return Arrays.asList(sslSession.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public String getCipherSuite() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public String getClientAddress() {
        return this.request.getClientAddress().getAddress().getHostAddress();
    }

    public int getClientPort() {
        SocketChannel socket = this.getSocket();
        return socket != null ? socket.socket().getPort() : -1;
    }

    protected long getContentLength() {
        return this.request.getContentLength();
    }

    public String getHostDomain() {
        return super.getHostDomain();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return this.request.getInputStream();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Series<Header> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            List names = this.request.getNames();
            for (String name : names) {
                result.add(name, this.request.getValue(name));
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.request.getTarget();
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private SocketChannel getSocket() {
        return (SocketChannel)this.request.getAttribute((Object)"org.restlet.ext.simple.socket");
    }

    private SSLEngine getSslEngine() {
        return (SSLEngine)this.request.getAttribute((Object)"org.restlet.ext.simple.engine");
    }

    public Integer getSslKeySize() {
        Integer keySize = null;
        String sslCipherSuite = this.getCipherSuite();
        if (sslCipherSuite != null) {
            keySize = SslUtils.extractKeySize((String)sslCipherSuite);
        }
        return keySize;
    }

    protected byte[] getSslSessionIdBytes() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            return sslSession.getId();
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    protected boolean isClientKeepAlive() {
        return this.request.isKeepAlive();
    }

    public void writeResponseHead(Response restletResponse) throws IOException {
        for (Header header : this.getResponseHeaders()) {
            this.response.addValue(header.getName(), header.getValue());
        }
        this.response.setCode(this.getStatusCode());
        this.response.setDescription(this.getReasonPhrase());
        if (!Method.HEAD.equals((Object)restletResponse.getRequest().getMethod()) && restletResponse.getEntity() == null) {
            this.response.setContentLength(0L);
        }
    }
}

