/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.ext.wadl.DocumentationInfo;
import org.w3c.dom.Node;

public abstract class DocumentedInfo {
    private List<DocumentationInfo> documentations;

    public DocumentedInfo() {
    }

    public DocumentedInfo(DocumentationInfo documentation) {
        this.getDocumentations().add(documentation);
    }

    public DocumentedInfo(List<DocumentationInfo> documentations) {
        this.documentations = documentations;
    }

    public DocumentedInfo(String documentation) {
        this(new DocumentationInfo(documentation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentationInfo> getDocumentations() {
        List<DocumentationInfo> d = this.documentations;
        if (d == null) {
            DocumentedInfo documentedInfo = this;
            synchronized (documentedInfo) {
                d = this.documentations;
                if (d == null) {
                    this.documentations = d = new ArrayList<DocumentationInfo>();
                }
            }
        }
        return d;
    }

    public Map<String, String> resolveNamespaces() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (DocumentationInfo documentationInfo : this.getDocumentations()) {
            if (documentationInfo.getMixedContent() == null) continue;
            this.resolveNamespaces(documentationInfo.getMixedContent(), result);
        }
        return result;
    }

    private void resolveNamespaces(Node node, Map<String, String> namespaces) {
        if (node.getNamespaceURI() != null) {
            namespaces.put(node.getNamespaceURI(), node.getPrefix());
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.resolveNamespaces(node.getChildNodes().item(i), namespaces);
            }
        }
    }

    public void setDocumentation(DocumentationInfo documentationInfo) {
        this.getDocumentations().clear();
        this.getDocumentations().add(documentationInfo);
    }

    public void setDocumentation(String documentation) {
        this.getDocumentations().clear();
        this.getDocumentations().add(new DocumentationInfo(documentation));
    }

    public void setDocumentations(List<DocumentationInfo> doc) {
        this.documentations = doc;
    }

    public abstract void updateNamespaces(Map<String, String> var1);
}

