/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_ALL_XML = new VariantInfo(MediaType.APPLICATION_ALL_XML);
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_APPLICATION_ALL_XML.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source)) {
            result = this.addObjectClass(result, Document.class);
            result = this.addObjectClass(result, DomRepresentation.class);
            result = this.addObjectClass(result, SaxRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (Document.class.isAssignableFrom(source) || DomRepresentation.class.isAssignableFrom(source) || SaxRepresentation.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_APPLICATION_ALL_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof Document) {
            result = MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : (MediaType.APPLICATION_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : (MediaType.TEXT_XML.isCompatible((Metadata)target.getMediaType()) ? 1.0f : 0.5f));
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null && (Document.class.isAssignableFrom(target) || DomRepresentation.class.isAssignableFrom(target) || SaxRepresentation.class.isAssignableFrom(target))) {
            result = MediaType.APPLICATION_ALL_XML.isCompatible((Metadata)source.getMediaType()) ? 1.0f : (MediaType.APPLICATION_XML.isCompatible((Metadata)source.getMediaType()) ? 1.0f : (MediaType.TEXT_XML.isCompatible((Metadata)source.getMediaType()) ? 1.0f : 0.5f));
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        Object result = null;
        if (Document.class.isAssignableFrom(target)) {
            result = new DomRepresentation(source).getDocument();
        } else if (DomRepresentation.class.isAssignableFrom(target)) {
            result = new DomRepresentation(source);
        } else if (SaxRepresentation.class.isAssignableFrom(target)) {
            result = new SaxRepresentation(source);
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) throws IOException {
        Object result = null;
        if (source instanceof Document) {
            result = new DomRepresentation(target.getMediaType(), (Document)source);
        } else if (source instanceof Representation) {
            result = (Representation)source;
        }
        return result;
    }
}

