/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
extends Filter {
    public static final int MODE_REQUEST = 1;
    public static final int MODE_RESPONSE = 2;
    private volatile int mode;
    private volatile CharacterSet resultCharacterSet;
    private volatile List<Encoding> resultEncodings;
    private volatile List<Language> resultLanguages;
    private volatile MediaType resultMediaType;
    private volatile Representation transformSheet;

    public Transformer(int mode, Representation transformSheet) {
        this.mode = mode;
        this.transformSheet = transformSheet;
        this.resultMediaType = MediaType.APPLICATION_XML;
        this.resultCharacterSet = null;
    }

    protected void afterHandle(Request request, Response response) {
        if (this.getMode() == 2 && this.canTransform(response.getEntity())) {
            response.setEntity(this.transform(response.getEntity()));
        }
    }

    protected int beforeHandle(Request request, Response response) {
        if (this.getMode() == 1 && this.canTransform(request.getEntity())) {
            request.setEntity(this.transform(request.getEntity()));
        }
        return 0;
    }

    protected boolean canTransform(Representation representation) {
        return true;
    }

    public int getMode() {
        return this.mode;
    }

    public CharacterSet getResultCharacterSet() {
        return this.resultCharacterSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Encoding> getResultEncodings() {
        List<Encoding> re = this.resultEncodings;
        if (re == null) {
            Transformer transformer = this;
            synchronized (transformer) {
                re = this.resultEncodings;
                if (re == null) {
                    this.resultEncodings = re = new CopyOnWriteArrayList<Encoding>();
                }
            }
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getResultLanguages() {
        List<Language> v = this.resultLanguages;
        if (v == null) {
            Transformer transformer = this;
            synchronized (transformer) {
                v = this.resultLanguages;
                if (v == null) {
                    this.resultLanguages = v = new CopyOnWriteArrayList<Language>();
                }
            }
        }
        return v;
    }

    public MediaType getResultMediaType() {
        return this.resultMediaType;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setResultCharacterSet(CharacterSet resultCharacterSet) {
        this.resultCharacterSet = resultCharacterSet;
    }

    public void setResultEncodings(List<Encoding> resultEncodings) {
        this.resultEncodings = resultEncodings;
    }

    public void setResultLanguages(List<Language> resultLanguages) {
        this.resultLanguages = resultLanguages;
    }

    public void setResultMediaType(MediaType resultMediaType) {
        this.resultMediaType = resultMediaType;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public Representation transform(Representation source) {
        TransformRepresentation result = new TransformRepresentation(this.getContext(), source, this.getTransformSheet());
        if (this.resultLanguages != null) {
            result.getLanguages().addAll(this.getResultLanguages());
        }
        result.setCharacterSet(this.getResultCharacterSet());
        if (this.resultEncodings != null) {
            result.getEncodings().addAll(this.getResultEncodings());
        }
        result.setMediaType(this.getResultMediaType());
        return result;
    }
}

