/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta.instrumentation;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.instrumentation.util.BloatUtil;
import java.util.ArrayList;

class CheckApplicabilityEdit
implements BloatClassEdit {
    CheckApplicabilityEdit() {
    }

    public InstrumentationStatus enhance(ClassEditor ce, ClassLoader origLoader, BloatLoaderContext loaderContext) {
        try {
            Class clazz = BloatUtil.classForEditor((ClassEditor)ce, (ClassLoader)origLoader);
            if (clazz.isInterface()) {
                return InstrumentationStatus.FAILED;
            }
            if (clazz.isEnum()) {
                return InstrumentationStatus.FAILED;
            }
            if (!this.isApplicableClass(clazz)) {
                return InstrumentationStatus.FAILED;
            }
        }
        catch (ClassNotFoundException e) {
            return InstrumentationStatus.FAILED;
        }
        return InstrumentationStatus.NOT_INSTRUMENTED;
    }

    private boolean isApplicableClass(Class clazz) {
        for (Class curClazz = clazz; curClazz != Object.class && curClazz != null && !this.isApplicablePlatformClass(curClazz); curClazz = curClazz.getSuperclass()) {
            if (!BloatUtil.isPlatformClassName((String)curClazz.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isApplicablePlatformClass(Class curClazz) {
        return this.isEnum(curClazz) || this.isSupportedCollection(curClazz);
    }

    private boolean isSupportedCollection(Class curClazz) {
        return curClazz == ArrayList.class;
    }

    private boolean isEnum(Class curClazz) {
        return curClazz.getName().equals("java.lang.Enum");
    }
}

