/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.AbstractList4;
import com.db4o.ta.Activatable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList4<E>
extends AbstractList4<E>
implements Cloneable,
Serializable,
RandomAccess,
Activatable {
    private static final long serialVersionUID = 7971683768827646182L;
    private E[] elements;
    private int listSize;
    private transient Activator _activator;

    @Override
    public void activate(ActivationPurpose purpose) {
        if (this._activator != null) {
            this._activator.activate(purpose);
        }
    }

    @Override
    public void bind(Activator activator) {
        if (this._activator == activator) {
            return;
        }
        if (activator != null && this._activator != null) {
            throw new IllegalStateException();
        }
        this._activator = activator;
    }

    public ArrayList4() {
        this(10);
    }

    public ArrayList4(Collection<? extends E> c) {
        E[] data = this.collectionToArray(c);
        this.elements = this.allocateStorage(data.length);
        this.listSize = data.length;
        System.arraycopy(data, 0, this.elements, 0, data.length);
    }

    private E[] allocateStorage(int size) {
        return new Object[size];
    }

    private E[] collectionToArray(Collection<? extends E> c) {
        return c.toArray();
    }

    public ArrayList4(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elements = this.allocateStorage(initialCapacity);
        this.listSize = 0;
    }

    @Override
    public void add(int index, E element) {
        this.checkIndex(index, 0, this.size());
        this.ensureCapacity(this.size() + 1);
        this.arrayCopyElements(index, index + 1, this.listSize - index);
        this.elements[index] = element;
        this.increaseSize(1);
        this.markModified();
    }

    private void arrayCopyElements(int sourceIndex, int targetIndex, int length) {
        this.activateForWrite();
        System.arraycopy(this.elements, sourceIndex, this.elements, targetIndex, length);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAllImpl(index, c.toArray());
    }

    private boolean addAllImpl(int index, E[] toBeAdded) {
        this.checkIndex(index, 0, this.size());
        int length = toBeAdded.length;
        if (length == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + length);
        this.arrayCopyElements(index, index + length, this.size() - index);
        System.arraycopy(toBeAdded, 0, this.elements, index, length);
        this.increaseSize(length);
        this.markModified();
        return true;
    }

    @Override
    public void clear() {
        int size = this.size();
        this.activateForWrite();
        Arrays.fill(this.elements, 0, size, this.defaultValue());
        this.setSize(0);
        this.markModified();
    }

    private E defaultValue() {
        return null;
    }

    public Object clone() {
        this.activate(ActivationPurpose.READ);
        try {
            ArrayList4 clonedList = (ArrayList4)super.clone();
            clonedList.elements = (Object[])this.elements.clone();
            clonedList._activator = null;
            return clonedList;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void ensureCapacity(int minCapacity) {
        this.activate(ActivationPurpose.READ);
        if (minCapacity <= this.capacity()) {
            return;
        }
        this.resize(minCapacity);
    }

    private int capacity() {
        return this.elements.length;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index, 0, this.size() - 1);
        return this.elements[index];
    }

    @Override
    public int indexOf(Object o) {
        for (int index = 0; index < this.size(); ++index) {
            E element = this.get(index);
            if (!(o == null ? element == null : o.equals(element))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int index = this.size() - 1; index >= 0; --index) {
            E element = this.get(index);
            if (!(o == null ? element == null : o.equals(element))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public E remove(int index) {
        int size = this.size();
        E element = this.get(index);
        this.arrayCopyElements(index + 1, index, size - index - 1);
        this.elements[size - 1] = this.defaultValue();
        this.decreaseSize(1);
        this.markModified();
        return element;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.removeRangeImpl(fromIndex, toIndex - fromIndex);
    }

    private void removeRangeImpl(int fromIndex, int count) {
        int size = this.size();
        int toIndex = fromIndex + count;
        if (fromIndex < 0 || fromIndex >= size || toIndex > size || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        System.arraycopy(this.elements, toIndex, this.elements, fromIndex, size - toIndex);
        Arrays.fill(this.elements, size - count, size, this.defaultValue());
        this.decreaseSize(count);
        this.markModified();
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.get(index);
        this.activateForWrite();
        this.elements[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        this.activate(ActivationPurpose.READ);
        return this.listSize;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] data = new Object[size];
        System.arraycopy(this.elements, 0, data, 0, size);
        return data;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(this.elements, 0, a, 0, size);
        return a;
    }

    public void trimToSize() {
        this.activateForWrite();
        this.resize(this.size());
    }

    private void resize(int minCapacity) {
        this.markModified();
        E[] temp = this.allocateStorage(minCapacity);
        System.arraycopy(this.elements, 0, temp, 0, this.size());
        this.elements = temp;
    }

    void setSize(int count) {
        this.listSize = count;
    }

    void increaseSize(int count) {
        this.listSize += count;
    }

    void decreaseSize(int count) {
        this.listSize -= count;
    }

    void markModified() {
        ++this.modCount;
    }

    private void activateForWrite() {
        this.activate(ActivationPurpose.WRITE);
    }
}

