/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ext;

import com.db4o.Internal4;
import com.db4o.ObjectSet;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.SignatureGenerator;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.query.Query;
import com.db4o.types.Db4oType;

public class Db4oDatabase
implements Db4oType,
Internal4 {
    public static final Db4oDatabase STATIC_IDENTITY = null;
    public static final int STATIC_ID = -1;
    public byte[] i_signature;
    public long i_uuid;
    private static final String CREATIONTIME_FIELD = "i_uuid";
    private transient ObjectContainerBase i_stream;
    private transient int i_id;

    public Db4oDatabase() {
    }

    public Db4oDatabase(byte[] signature, long creationTime) {
        this.i_signature = signature;
        this.i_uuid = creationTime;
    }

    public static Db4oDatabase generate() {
        StatefulBuffer writer = new StatefulBuffer(null, 300);
        new LatinStringIO().write(writer, SignatureGenerator.generateSignature());
        return new Db4oDatabase(writer.getWrittenBytes(), System.currentTimeMillis());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Db4oDatabase other = (Db4oDatabase)obj;
        if (null == other.i_signature || null == this.i_signature) {
            return false;
        }
        return Arrays4.equals(other.i_signature, this.i_signature);
    }

    public int hashCode() {
        return this.i_signature.hashCode();
    }

    public int getID(Transaction trans) {
        ObjectContainerBase stream = trans.container();
        if (stream != this.i_stream) {
            this.i_stream = stream;
            this.i_id = this.bind(trans);
        }
        return this.i_id;
    }

    public long getCreationTime() {
        return this.i_uuid;
    }

    public byte[] getSignature() {
        return this.i_signature;
    }

    public String toString() {
        return "db " + this.i_signature;
    }

    public boolean isOlderThan(Db4oDatabase peer) {
        if (peer == this) {
            throw new IllegalArgumentException();
        }
        if (this.i_uuid != peer.i_uuid) {
            return this.i_uuid < peer.i_uuid;
        }
        if (this.i_signature.length != peer.i_signature.length) {
            return this.i_signature.length < peer.i_signature.length;
        }
        for (int i = 0; i < this.i_signature.length; ++i) {
            if (this.i_signature[i] == peer.i_signature[i]) continue;
            return this.i_signature[i] < peer.i_signature[i];
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bind(Transaction trans) {
        ObjectContainerBase stream = trans.container();
        Db4oDatabase stored = (Db4oDatabase)stream.db4oTypeStored(trans, this);
        if (stored == null) {
            return this.storeAndGetId(trans);
        }
        if (stored == this) {
            return stream.getID(trans, this);
        }
        if (this.i_uuid == 0L) {
            this.i_uuid = stored.i_uuid;
        }
        stream.showInternalClasses(true);
        try {
            int id = stream.getID(trans, stored);
            stream.bind(trans, this, id);
            int n = id;
            return n;
        }
        finally {
            stream.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int storeAndGetId(Transaction trans) {
        ObjectContainerBase stream = trans.container();
        stream.showInternalClasses(true);
        try {
            stream.store3(trans, this, 2, false);
            int n = stream.getID(trans, this);
            return n;
        }
        finally {
            stream.showInternalClasses(false);
        }
    }

    public Db4oDatabase query(Transaction trans) {
        Db4oDatabase res;
        if (this.i_uuid > 0L && (res = this.query(trans, true)) != null) {
            return res;
        }
        return this.query(trans, false);
    }

    private Db4oDatabase query(Transaction trans, boolean constrainByUUID) {
        ObjectContainerBase stream = trans.container();
        Query q = stream.query(trans);
        q.constrain(this.getClass());
        if (constrainByUUID) {
            q.descend(CREATIONTIME_FIELD).constrain(new Long(this.i_uuid));
        }
        ObjectSet objectSet = q.execute();
        while (objectSet.hasNext()) {
            Db4oDatabase storedDatabase = (Db4oDatabase)objectSet.next();
            stream.activate(null, storedDatabase, new FixedActivationDepth(4));
            if (!storedDatabase.equals(this)) continue;
            return storedDatabase;
        }
        return null;
    }
}

