/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.Rename;
import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.config.Alias;
import com.db4o.config.CacheConfiguration;
import com.db4o.config.ClientServerConfiguration;
import com.db4o.config.ConfigScope;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.config.FreespaceConfiguration;
import com.db4o.config.FreespaceFiller;
import com.db4o.config.GlobalOnlyConfigException;
import com.db4o.config.LegacyClientServerFactory;
import com.db4o.config.NameProvider;
import com.db4o.config.ObjectClass;
import com.db4o.config.QueryConfiguration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.config.encoding.StringEncoding;
import com.db4o.config.encoding.StringEncodings;
import com.db4o.diagnostic.DiagnosticConfiguration;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.KeySpec;
import com.db4o.foundation.KeySpecHashtable4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.CallBackMode;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.QueryResultIteratorFactory;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.LegacyActivationDepthProvider;
import com.db4o.internal.config.CacheConfigurationImpl;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.events.Event4Impl;
import com.db4o.internal.handlers.TypeHandlerPredicatePair;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.references.ReferenceSystemFactory;
import com.db4o.internal.references.TransactionalReferenceSystem;
import com.db4o.io.CachingStorage;
import com.db4o.io.FileStorage;
import com.db4o.io.IoAdapter;
import com.db4o.io.IoAdapterStorage;
import com.db4o.io.Storage;
import com.db4o.messaging.MessageRecipient;
import com.db4o.messaging.MessageSender;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.TypeHandler4;
import com.db4o.typehandlers.TypeHandlerPredicate;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Config4Impl
implements Configuration,
DeepClone,
MessageSender,
FreespaceConfiguration,
QueryConfiguration,
ClientServerConfiguration {
    private KeySpecHashtable4 _config = new KeySpecHashtable4(50);
    private static final KeySpec ACTIVATION_DEPTH_KEY = new KeySpec(5);
    private static final KeySpec ACTIVATION_DEPTH_PROVIDER_KEY = new KeySpec(LegacyActivationDepthProvider.INSTANCE);
    private static final KeySpec ALLOW_VERSION_UPDATES_KEY = new KeySpec(false);
    private static final KeySpec AUTOMATIC_SHUTDOWN_KEY = new KeySpec(true);
    private static final KeySpec BLOCKSIZE_KEY = new KeySpec(1);
    private static final KeySpec BLOB_PATH_KEY = new KeySpec(null);
    private static final KeySpec BTREE_NODE_SIZE_KEY = new KeySpec(119);
    private static final KeySpec CALLBACKS_KEY = new KeySpec(CallBackMode.ALL);
    private static final KeySpec CALL_CONSTRUCTORS_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CONFIGURATION_ITEMS_KEY = new KeySpec(null);
    private static final KeySpec CONFIGURED_REFLECTOR_KEY = new KeySpec(null);
    private static final KeySpec CLASS_ACTIVATION_DEPTH_CONFIGURABLE_KEY = new KeySpec(true);
    private static final KeySpec CLASSLOADER_KEY = new KeySpec(null);
    private static final KeySpec CLIENT_SERVER_FACTORY_KEY = new KeySpec(new KeySpec.Deferred(){

        public Object evaluate() {
            return Config4Impl.defaultClientServerFactory();
        }
    });
    private static final KeySpec DATABASE_GROWTH_SIZE_KEY = new KeySpec(0);
    private static final KeySpec DETECT_SCHEMA_CHANGES_KEY = new KeySpec(true);
    private static final KeySpec DIAGNOSTIC_KEY = new KeySpec(new KeySpec.Deferred(){

        public Object evaluate() {
            return new DiagnosticProcessor();
        }
    });
    private static final KeySpec DISABLE_COMMIT_RECOVERY_KEY = new KeySpec(false);
    private static final KeySpec DISCARD_FREESPACE_KEY = new KeySpec(0);
    private static final StringEncoding DEFAULT_STRING_ENCODING = StringEncodings.unicode();
    private static final KeySpec STRING_ENCODING_KEY = new KeySpec(DEFAULT_STRING_ENCODING);
    private static final KeySpec ENCODING_KEY = new KeySpec(BuiltInStringEncoding.encodingByteForEncoding(DEFAULT_STRING_ENCODING));
    private static final KeySpec ENCRYPT_KEY = new KeySpec(false);
    private static final KeySpec ENVIRONMENT_CONTRIBUTIONS_KEY = new KeySpec(new KeySpec.Deferred(){

        public Object evaluate() {
            return new ArrayList();
        }
    });
    private static final KeySpec EXCEPTIONAL_CLASSES_KEY = new KeySpec(null);
    private static final KeySpec EXCEPTIONS_ON_NOT_STORABLE_KEY = new KeySpec(true);
    private static final KeySpec FILE_BASED_TRANSACTION_LOG_KEY = new KeySpec(false);
    private static final KeySpec FREESPACE_FILLER_KEY = new KeySpec(null);
    private static final KeySpec FREESPACE_SYSTEM_KEY = new KeySpec(0);
    private static final KeySpec GENERATE_UUIDS_KEY = new KeySpec(ConfigScope.INDIVIDUALLY);
    private static final KeySpec GENERATE_VERSION_NUMBERS_KEY = new KeySpec(ConfigScope.INDIVIDUALLY);
    private static final KeySpec QUERY_EVALUATION_MODE_KEY = new KeySpec(QueryEvaluationMode.IMMEDIATE);
    private static final KeySpec LOCK_FILE_KEY = new KeySpec(true);
    private static final KeySpec MESSAGE_RECIPIENT_KEY = new KeySpec(null);
    private static final KeySpec OPTIMIZE_NQ_KEY = new KeySpec(true);
    private static final KeySpec OUTSTREAM_KEY = new KeySpec(null);
    private static final KeySpec PASSWORD_KEY = new KeySpec(null);
    private static final KeySpec CLIENT_QUERY_RESULT_ITERATOR_FACTORY_KEY = new KeySpec(null);
    private static final KeySpec PREFETCH_ID_COUNT_KEY = new KeySpec(10);
    private static final KeySpec PREFETCH_OBJECT_COUNT_KEY = new KeySpec(10);
    private static final KeySpec PREFETCH_DEPTH_KEY = new KeySpec(0);
    public static final int PREFETCH_SLOT_CACHE_SIZE_FACTOR = 10;
    private static final int MAXIMUM_PREFETCH_SLOT_CACHE_SIZE = 10000;
    private static final KeySpec PREFETCH_SLOT_CACHE_SIZE_KEY = new KeySpec(0);
    private static final KeySpec READ_AS_KEY = new KeySpec(new KeySpec.Deferred(){

        public Object evaluate() {
            return new Hashtable4(16);
        }
    });
    private static final KeySpec RECOVERY_MODE_KEY = new KeySpec(false);
    private static final KeySpec REFLECTOR_KEY = new KeySpec(null);
    private static final KeySpec RENAME_KEY = new KeySpec(null);
    private static final KeySpec RESERVED_STORAGE_SPACE_KEY = new KeySpec(0);
    private static final KeySpec SINGLE_THREADED_CLIENT_KEY = new KeySpec(false);
    private static final KeySpec TEST_CONSTRUCTORS_KEY = new KeySpec(true);
    private static final KeySpec TIMEOUT_CLIENT_SOCKET_KEY = new KeySpec(600000);
    private static final KeySpec TIMEOUT_SERVER_SOCKET_KEY = new KeySpec(600000);
    private static final KeySpec UPDATE_DEPTH_KEY = new KeySpec(1);
    private static final KeySpec WEAK_REFERENCE_COLLECTION_INTERVAL_KEY = new KeySpec(1000);
    private static final KeySpec WEAK_REFERENCES_KEY = new KeySpec(true);
    private static final KeySpec STORAGE_FACTORY_KEY = new KeySpec(new CachingStorage(new FileStorage()));
    private static final KeySpec ALIASES_KEY = new KeySpec(null);
    private static final KeySpec BATCH_MESSAGES_KEY = new KeySpec(true);
    private static final KeySpec MAX_BATCH_QUEUE_SIZE_KEY = new KeySpec(Integer.MAX_VALUE);
    private static final KeySpec SLOT_CACHE_SIZE_KEY = new KeySpec(30);
    private static final KeySpec TAINTED_KEY = new KeySpec(false);
    private static final KeySpec REFERENCE_SYSTEM_FACTORY_KEY = new KeySpec(new ReferenceSystemFactory(){

        public ReferenceSystem newReferenceSystem(InternalObjectContainer container) {
            return new TransactionalReferenceSystem();
        }
    });
    private static final KeySpec NAME_PROVIDER_KEY = new KeySpec(new NameProvider(){

        public String name(ObjectContainer db) {
            return null;
        }
    });
    private ObjectContainerBase _container;
    private boolean _internStrings;
    private int _messageLevel;
    private boolean _readOnly;
    private Collection4 _registeredTypeHandlers;
    private final Event4Impl<EventArgs> _prefetchSettingsChanged = Event4Impl.newInstance();
    private boolean _prefetchSlotCacheSizeModifiedExternally;

    @Override
    public int activationDepth() {
        return this._config.getAsInt(ACTIVATION_DEPTH_KEY);
    }

    private static LegacyClientServerFactory defaultClientServerFactory() {
        try {
            return (LegacyClientServerFactory)Class.forName("com.db4o.cs.internal.config.LegacyClientServerFactoryImpl").newInstance();
        }
        catch (Exception e) {
            throw new Db4oException("ClientServer jar db4o-[version]-cs-java.jar not in CLASSPATH", e);
        }
    }

    @Override
    public void activationDepth(int depth) {
        this._config.put(ACTIVATION_DEPTH_KEY, depth);
    }

    @Override
    public void add(ConfigurationItem item) {
        item.prepare(this);
        this.safeConfigurationItems().put(item, (Object)item);
    }

    public Iterator4 configurationItemsIterator() {
        Hashtable4 items = this.configurationItems();
        if (items == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return items.keys();
    }

    private Hashtable4 safeConfigurationItems() {
        Hashtable4 items = this.configurationItems();
        if (items == null) {
            items = new Hashtable4(16);
            this._config.put(CONFIGURATION_ITEMS_KEY, items);
        }
        return items;
    }

    @Override
    public void allowVersionUpdates(boolean flag) {
        this._config.put(ALLOW_VERSION_UPDATES_KEY, flag);
    }

    private Hashtable4 configurationItems() {
        return (Hashtable4)this._config.get(CONFIGURATION_ITEMS_KEY);
    }

    public void applyConfigurationItems(InternalObjectContainer container) {
        Hashtable4 items = this.configurationItems();
        if (items == null) {
            return;
        }
        Iterator4 i = items.iterator();
        while (i.moveNext()) {
            Entry4 entry = (Entry4)i.current();
            ConfigurationItem item = (ConfigurationItem)entry.value();
            item.apply(container);
        }
    }

    @Override
    public void automaticShutDown(boolean flag) {
        this._config.put(AUTOMATIC_SHUTDOWN_KEY, flag);
    }

    @Override
    public void blockSize(int bytes) {
        if (bytes < 1 || bytes > 127) {
            throw new IllegalArgumentException();
        }
        this.globalSettingOnly();
        this._config.put(BLOCKSIZE_KEY, (byte)bytes);
    }

    @Override
    public void bTreeNodeSize(int size) {
        this._config.put(BTREE_NODE_SIZE_KEY, size);
    }

    @Override
    public void bTreeCacheHeight(int height) {
    }

    @Override
    public void callbacks(boolean turnOn) {
        this.callbackMode(turnOn ? CallBackMode.ALL : CallBackMode.NONE);
    }

    public void callbackMode(CallBackMode mode) {
        this._config.put(CALLBACKS_KEY, mode);
    }

    @Override
    public void callConstructors(boolean flag) {
        this._config.put(CALL_CONSTRUCTORS_KEY, TernaryBool.forBoolean(flag));
    }

    @Override
    public void classActivationDepthConfigurable(boolean turnOn) {
        this._config.put(CLASS_ACTIVATION_DEPTH_CONFIGURABLE_KEY, turnOn);
    }

    Config4Class configClass(String className) {
        Config4Class config = (Config4Class)this.exceptionalClasses().get(className);
        return config;
    }

    private boolean isIgnoredClass(String className) {
        Class[] ignore = this.ignoredClasses();
        for (int i = 0; i < ignore.length; ++i) {
            if (!ignore[i].getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private Class[] ignoredClasses() {
        return new Class[]{StaticClass.class, StaticField.class};
    }

    @Override
    public Object deepClone(Object param) {
        Config4Impl ret = new Config4Impl();
        ConfigDeepCloneContext context = new ConfigDeepCloneContext(this, ret);
        ret._config = (KeySpecHashtable4)this._config.deepClone(context);
        ret._internStrings = this._internStrings;
        ret._messageLevel = this._messageLevel;
        ret._readOnly = this._readOnly;
        if (this._registeredTypeHandlers != null) {
            ret._registeredTypeHandlers = (Collection4)this._registeredTypeHandlers.deepClone(context);
        }
        return ret;
    }

    public void container(ObjectContainerBase container) {
        this._container = container;
    }

    @Override
    public void databaseGrowthSize(int bytes) {
        this._config.put(DATABASE_GROWTH_SIZE_KEY, bytes);
    }

    public int databaseGrowthSize() {
        return this._config.getAsInt(DATABASE_GROWTH_SIZE_KEY);
    }

    @Override
    public void detectSchemaChanges(boolean flag) {
        this._config.put(DETECT_SCHEMA_CHANGES_KEY, flag);
    }

    @Override
    public void disableCommitRecovery() {
        this._config.put(DISABLE_COMMIT_RECOVERY_KEY, true);
    }

    @Override
    public void discardFreeSpace(int bytes) {
        if (bytes < 0) {
            throw new IllegalArgumentException();
        }
        this._config.put(DISCARD_FREESPACE_KEY, bytes);
    }

    @Override
    public void discardSmallerThan(int byteCount) {
        this.discardFreeSpace(byteCount);
    }

    @Override
    public void encrypt(boolean flag) {
        this.globalSettingOnly();
        this._config.put(ENCRYPT_KEY, flag);
    }

    void oldEncryptionOff() {
        this._config.put(ENCRYPT_KEY, false);
    }

    void ensureDirExists(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(Messages.get(37, path));
        }
    }

    PrintStream errStream() {
        PrintStream outStream = this.outStreamOrNull();
        return outStream == null ? System.err : outStream;
    }

    @Override
    public void exceptionsOnNotStorable(boolean flag) {
        this._config.put(EXCEPTIONS_ON_NOT_STORABLE_KEY, flag);
    }

    @Override
    public void flushFileBuffers(boolean flag) {
    }

    @Override
    public FreespaceConfiguration freespace() {
        return this;
    }

    @Override
    public void freespaceFiller(FreespaceFiller freespaceFiller) {
        this._config.put(FREESPACE_FILLER_KEY, freespaceFiller);
    }

    public FreespaceFiller freespaceFiller() {
        return (FreespaceFiller)this._config.get(FREESPACE_FILLER_KEY);
    }

    @Override
    public void generateUUIDs(int setting) {
        this.generateUUIDs(ConfigScope.forID(setting));
    }

    @Override
    public void generateUUIDs(ConfigScope scope) {
        this._config.put(GENERATE_UUIDS_KEY, scope);
    }

    @Override
    public void generateVersionNumbers(int setting) {
        this.generateVersionNumbers(ConfigScope.forID(setting));
    }

    @Override
    public void generateVersionNumbers(ConfigScope scope) {
        this._config.put(GENERATE_VERSION_NUMBERS_KEY, scope);
    }

    @Override
    public MessageSender getMessageSender() {
        return this;
    }

    private void globalSettingOnly() {
        if (this._container != null) {
            throw new GlobalOnlyConfigException();
        }
    }

    @Override
    public void internStrings(boolean doIntern) {
        this._internStrings = doIntern;
    }

    @Override
    public void io(IoAdapter adapter) {
        this.globalSettingOnly();
        this.storage(new IoAdapterStorage(adapter));
    }

    @Override
    public void lockDatabaseFile(boolean flag) {
        this._config.put(LOCK_FILE_KEY, flag);
    }

    @Override
    public void markTransient(String marker) {
        Platform4.markTransient(marker);
    }

    @Override
    public void messageLevel(int level) {
        this._messageLevel = level;
        if (this.outStream() == null) {
            this.setOut(System.out);
        }
    }

    @Override
    public void optimizeNativeQueries(boolean optimizeNQ) {
        this._config.put(OPTIMIZE_NQ_KEY, optimizeNQ);
    }

    @Override
    public boolean optimizeNativeQueries() {
        return this._config.getAsBoolean(OPTIMIZE_NQ_KEY);
    }

    @Override
    public ObjectClass objectClass(Object clazz) {
        String className = null;
        if (clazz instanceof String) {
            className = (String)clazz;
        } else {
            ReflectClass claxx = this.reflectorFor(clazz);
            if (claxx == null) {
                return null;
            }
            className = claxx.getName();
        }
        if (ReflectPlatform.fullyQualifiedName(Object.class).equals(className)) {
            throw new IllegalArgumentException("Configuration of the Object class is not supported.");
        }
        Hashtable4 xClasses = this.exceptionalClasses();
        Config4Class c4c = (Config4Class)xClasses.get(className);
        if (c4c == null) {
            c4c = new Config4Class(this, className);
            xClasses.put(className, (Object)c4c);
        }
        return c4c;
    }

    private PrintStream outStreamOrNull() {
        return (PrintStream)this._config.get(OUTSTREAM_KEY);
    }

    public PrintStream outStream() {
        PrintStream outStream = this.outStreamOrNull();
        return outStream == null ? System.out : outStream;
    }

    @Override
    public void password(String pw) {
        this.globalSettingOnly();
        this._config.put(PASSWORD_KEY, pw);
    }

    @Override
    public void readOnly(boolean flag) {
        this._readOnly = flag;
    }

    public GenericReflector reflector() {
        GenericReflector reflector = (GenericReflector)this._config.get(REFLECTOR_KEY);
        if (reflector == null) {
            Reflector configuredReflector = (Reflector)this._config.get(CONFIGURED_REFLECTOR_KEY);
            if (configuredReflector == null) {
                configuredReflector = Platform4.createReflector(this.classLoader());
                this._config.put(CONFIGURED_REFLECTOR_KEY, configuredReflector);
            }
            reflector = new GenericReflector(configuredReflector);
            this._config.put(REFLECTOR_KEY, reflector);
        }
        return reflector;
    }

    @Override
    public void reflectWith(Reflector reflect) {
        if (this._container != null) {
            Exceptions4.throwRuntimeException(46);
        }
        if (reflect == null) {
            throw new NullPointerException();
        }
        this._config.put(CONFIGURED_REFLECTOR_KEY, reflect);
        this._config.put(REFLECTOR_KEY, null);
    }

    @Override
    public void refreshClasses() {
        throw new NotImplementedException();
    }

    void rename(Rename a_rename) {
        Collection4 renameCollection = this.rename();
        if (renameCollection == null) {
            renameCollection = new Collection4();
            this._config.put(RENAME_KEY, renameCollection);
        }
        renameCollection.add(a_rename);
    }

    @Override
    public void reserveStorageSpace(long byteCount) throws DatabaseReadOnlyException {
        int reservedStorageSpace = (int)byteCount;
        if (reservedStorageSpace < 0) {
            reservedStorageSpace = 0;
        }
        this._config.put(RESERVED_STORAGE_SPACE_KEY, reservedStorageSpace);
        if (this._container != null) {
            this._container.reserve(reservedStorageSpace);
        }
    }

    @Override
    public void send(Object obj) {
        if (this._container != null) {
            this._container.send(obj);
        }
    }

    @Override
    public void setBlobPath(String path) throws IOException {
        this.ensureDirExists(path);
        this._config.put(BLOB_PATH_KEY, path);
    }

    @Override
    public void setClassLoader(Object classLoader) {
        this.reflectWith(Platform4.createReflector(classLoader));
    }

    @Override
    public void setMessageRecipient(MessageRecipient messageRecipient) {
        this._config.put(MESSAGE_RECIPIENT_KEY, messageRecipient);
    }

    @Override
    public void setOut(PrintStream outStream) {
        this._config.put(OUTSTREAM_KEY, outStream);
        if (this._container != null) {
            this._container.logMsg(19, Db4o.version());
        } else {
            Messages.logMsg(this, 19, Db4o.version());
        }
    }

    @Override
    public void singleThreadedClient(boolean flag) {
        this._config.put(SINGLE_THREADED_CLIENT_KEY, flag);
    }

    public StringEncoding stringEncoding() {
        return (StringEncoding)this._config.get(STRING_ENCODING_KEY);
    }

    @Override
    public void stringEncoding(StringEncoding encoding) {
        this._config.put(STRING_ENCODING_KEY, encoding);
        this._config.put(ENCODING_KEY, BuiltInStringEncoding.encodingByteForEncoding(encoding));
    }

    @Override
    public void testConstructors(boolean flag) {
        this._config.put(TEST_CONSTRUCTORS_KEY, flag);
    }

    @Override
    public void timeoutClientSocket(int milliseconds) {
        this._config.put(TIMEOUT_CLIENT_SOCKET_KEY, milliseconds);
    }

    @Override
    public void timeoutServerSocket(int milliseconds) {
        this._config.put(TIMEOUT_SERVER_SOCKET_KEY, milliseconds);
    }

    @Override
    public void unicode(boolean unicodeOn) {
    }

    @Override
    public void updateDepth(int depth) {
        DiagnosticProcessor dp = this.diagnosticProcessor();
        if (dp.enabled()) {
            dp.checkUpdateDepth(depth);
        }
        this._config.put(UPDATE_DEPTH_KEY, depth);
    }

    @Override
    public void useBTreeSystem() {
        this._config.put(FREESPACE_SYSTEM_KEY, (byte)4);
    }

    @Override
    public void useRamSystem() {
        this._config.put(FREESPACE_SYSTEM_KEY, (byte)2);
    }

    @Override
    public void useIndexSystem() {
        throw new NotSupportedException();
    }

    @Override
    public void weakReferenceCollectionInterval(int milliseconds) {
        this._config.put(WEAK_REFERENCE_COLLECTION_INTERVAL_KEY, milliseconds);
    }

    @Override
    public void weakReferences(boolean flag) {
        this._config.put(WEAK_REFERENCES_KEY, flag);
    }

    private Collection4 aliases() {
        Collection4 aliasesCollection = (Collection4)this._config.get(ALIASES_KEY);
        if (null == aliasesCollection) {
            aliasesCollection = new Collection4();
            this._config.put(ALIASES_KEY, aliasesCollection);
        }
        return aliasesCollection;
    }

    @Override
    public void addAlias(Alias alias) {
        if (null == alias) {
            throw new ArgumentNullException("alias");
        }
        this.aliases().add(alias);
    }

    @Override
    public void removeAlias(Alias alias) {
        if (null == alias) {
            throw new ArgumentNullException("alias");
        }
        this.aliases().remove(alias);
    }

    public String resolveAliasRuntimeName(String runtimeType) {
        Collection4 configuredAliases = this.aliases();
        if (null == configuredAliases) {
            return runtimeType;
        }
        Iterator4 i = configuredAliases.iterator();
        while (i.moveNext()) {
            String resolved = ((Alias)i.current()).resolveRuntimeName(runtimeType);
            if (null == resolved) continue;
            return resolved;
        }
        return runtimeType;
    }

    public String resolveAliasStoredName(String storedType) {
        Collection4 configuredAliases = this.aliases();
        if (null == configuredAliases) {
            return storedType;
        }
        Iterator4 i = configuredAliases.iterator();
        while (i.moveNext()) {
            String resolved = ((Alias)i.current()).resolveStoredName(storedType);
            if (null == resolved) continue;
            return resolved;
        }
        return storedType;
    }

    ReflectClass reflectorFor(Object clazz) {
        return ReflectorUtils.reflectClassFor(this.reflector(), clazz);
    }

    public boolean allowVersionUpdates() {
        return this._config.getAsBoolean(ALLOW_VERSION_UPDATES_KEY);
    }

    public boolean automaticShutDown() {
        return this._config.getAsBoolean(AUTOMATIC_SHUTDOWN_KEY);
    }

    public byte blockSize() {
        return this._config.getAsByte(BLOCKSIZE_KEY);
    }

    public int bTreeNodeSize() {
        return this._config.getAsInt(BTREE_NODE_SIZE_KEY);
    }

    public String blobPath() {
        return this._config.getAsString(BLOB_PATH_KEY);
    }

    public CallBackMode callbackMode() {
        return (CallBackMode)this._config.get(CALLBACKS_KEY);
    }

    public TernaryBool callConstructors() {
        return this._config.getAsTernaryBool(CALL_CONSTRUCTORS_KEY);
    }

    boolean classActivationDepthConfigurable() {
        return this._config.getAsBoolean(CLASS_ACTIVATION_DEPTH_CONFIGURABLE_KEY);
    }

    Object classLoader() {
        return this._config.get(CLASSLOADER_KEY);
    }

    public boolean detectSchemaChanges() {
        return this._config.getAsBoolean(DETECT_SCHEMA_CHANGES_KEY);
    }

    public boolean commitRecoveryDisabled() {
        return this._config.getAsBoolean(DISABLE_COMMIT_RECOVERY_KEY);
    }

    @Override
    public DiagnosticConfiguration diagnostic() {
        return (DiagnosticConfiguration)this._config.get(DIAGNOSTIC_KEY);
    }

    public DiagnosticProcessor diagnosticProcessor() {
        return (DiagnosticProcessor)this._config.get(DIAGNOSTIC_KEY);
    }

    public int discardFreeSpace() {
        return this._config.getAsInt(DISCARD_FREESPACE_KEY);
    }

    byte encoding() {
        return this._config.getAsByte(ENCODING_KEY);
    }

    boolean encrypt() {
        return this._config.getAsBoolean(ENCRYPT_KEY);
    }

    public Hashtable4 exceptionalClasses() {
        Hashtable4 exceptionalClasses = (Hashtable4)this._config.get(EXCEPTIONAL_CLASSES_KEY);
        if (exceptionalClasses == null) {
            exceptionalClasses = new Hashtable4(16);
            this._config.put(EXCEPTIONAL_CLASSES_KEY, exceptionalClasses);
        }
        return exceptionalClasses;
    }

    public boolean exceptionsOnNotStorable() {
        return this._config.getAsBoolean(EXCEPTIONS_ON_NOT_STORABLE_KEY);
    }

    byte freespaceSystem() {
        return this._config.getAsByte(FREESPACE_SYSTEM_KEY);
    }

    public ConfigScope generateUUIDs() {
        return (ConfigScope)this._config.get(GENERATE_UUIDS_KEY);
    }

    public ConfigScope generateVersionNumbers() {
        return (ConfigScope)this._config.get(GENERATE_VERSION_NUMBERS_KEY);
    }

    @Override
    public boolean internStrings() {
        return this._internStrings;
    }

    public boolean lockFile() {
        return this._config.getAsBoolean(LOCK_FILE_KEY);
    }

    public int messageLevel() {
        return this._messageLevel;
    }

    public MessageRecipient messageRecipient() {
        return (MessageRecipient)this._config.get(MESSAGE_RECIPIENT_KEY);
    }

    boolean optimizeNQ() {
        return this._config.getAsBoolean(OPTIMIZE_NQ_KEY);
    }

    String password() {
        return this._config.getAsString(PASSWORD_KEY);
    }

    @Override
    public void prefetchIDCount(int prefetchIDCount) {
        this._config.put(PREFETCH_ID_COUNT_KEY, prefetchIDCount);
    }

    public int prefetchIDCount() {
        return this._config.getAsInt(PREFETCH_ID_COUNT_KEY);
    }

    @Override
    public void prefetchObjectCount(int prefetchObjectCount) {
        this._config.put(PREFETCH_OBJECT_COUNT_KEY, prefetchObjectCount);
        this.ensurePrefetchSlotCacheSize();
    }

    public int prefetchObjectCount() {
        return this._config.getAsInt(PREFETCH_OBJECT_COUNT_KEY);
    }

    public Hashtable4 readAs() {
        return (Hashtable4)this._config.get(READ_AS_KEY);
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void recoveryMode(boolean flag) {
        this._config.put(RECOVERY_MODE_KEY, flag);
    }

    public boolean recoveryMode() {
        return this._config.getAsBoolean(RECOVERY_MODE_KEY);
    }

    Collection4 rename() {
        return (Collection4)this._config.get(RENAME_KEY);
    }

    public int reservedStorageSpace() {
        return this._config.getAsInt(RESERVED_STORAGE_SPACE_KEY);
    }

    public boolean singleThreadedClient() {
        return this._config.getAsBoolean(SINGLE_THREADED_CLIENT_KEY);
    }

    public boolean testConstructors() {
        return this._config.getAsBoolean(TEST_CONSTRUCTORS_KEY);
    }

    public int timeoutClientSocket() {
        return this._config.getAsInt(TIMEOUT_CLIENT_SOCKET_KEY);
    }

    public int timeoutServerSocket() {
        return this._config.getAsInt(TIMEOUT_SERVER_SOCKET_KEY);
    }

    public int updateDepth() {
        return this._config.getAsInt(UPDATE_DEPTH_KEY);
    }

    public int weakReferenceCollectionInterval() {
        return this._config.getAsInt(WEAK_REFERENCE_COLLECTION_INTERVAL_KEY);
    }

    public boolean weakReferences() {
        return this._config.getAsBoolean(WEAK_REFERENCES_KEY);
    }

    @Override
    public IoAdapter io() {
        throw new NotImplementedException();
    }

    @Override
    public Storage storage() {
        return (Storage)this._config.get(STORAGE_FACTORY_KEY);
    }

    @Override
    public void storage(Storage factory) {
        this._config.put(STORAGE_FACTORY_KEY, factory);
    }

    @Override
    public QueryConfiguration queries() {
        return this;
    }

    @Override
    public void evaluationMode(QueryEvaluationMode mode) {
        this._config.put(QUERY_EVALUATION_MODE_KEY, mode);
    }

    @Override
    public QueryEvaluationMode evaluationMode() {
        return (QueryEvaluationMode)this._config.get(QUERY_EVALUATION_MODE_KEY);
    }

    public void queryResultIteratorFactory(QueryResultIteratorFactory factory) {
        this._config.put(CLIENT_QUERY_RESULT_ITERATOR_FACTORY_KEY, factory);
    }

    public QueryResultIteratorFactory queryResultIteratorFactory() {
        return (QueryResultIteratorFactory)this._config.get(CLIENT_QUERY_RESULT_ITERATOR_FACTORY_KEY);
    }

    @Override
    public ClientServerConfiguration clientServer() {
        return this;
    }

    @Override
    public void batchMessages(boolean flag) {
        this._config.put(BATCH_MESSAGES_KEY, flag);
    }

    public boolean batchMessages() {
        return this._config.getAsBoolean(BATCH_MESSAGES_KEY);
    }

    @Override
    public void maxBatchQueueSize(int maxSize) {
        this._config.put(MAX_BATCH_QUEUE_SIZE_KEY, maxSize);
    }

    public int maxBatchQueueSize() {
        return this._config.getAsInt(MAX_BATCH_QUEUE_SIZE_KEY);
    }

    public void activationDepthProvider(ActivationDepthProvider provider) {
        this._config.put(ACTIVATION_DEPTH_PROVIDER_KEY, provider);
    }

    public ActivationDepthProvider activationDepthProvider() {
        return (ActivationDepthProvider)this._config.get(ACTIVATION_DEPTH_PROVIDER_KEY);
    }

    @Override
    public void registerTypeHandler(TypeHandlerPredicate predicate, TypeHandler4 typeHandler) {
        if (this._registeredTypeHandlers == null) {
            this._registeredTypeHandlers = new Collection4();
        }
        this._registeredTypeHandlers.add(new TypeHandlerPredicatePair(predicate, typeHandler));
    }

    public TypeHandler4 typeHandlerForClass(ReflectClass classReflector, byte handlerVersion) {
        if (this._registeredTypeHandlers == null) {
            return null;
        }
        Iterator4 i = this._registeredTypeHandlers.iterator();
        while (i.moveNext()) {
            TypeHandlerPredicatePair pair = (TypeHandlerPredicatePair)i.current();
            if (!pair._predicate.match(classReflector)) continue;
            return pair._typeHandler;
        }
        return null;
    }

    public void factory(LegacyClientServerFactory factory) {
        this._config.put(CLIENT_SERVER_FACTORY_KEY, factory);
    }

    public LegacyClientServerFactory clientServerFactory() {
        return (LegacyClientServerFactory)this._config.get(CLIENT_SERVER_FACTORY_KEY);
    }

    @Override
    public CacheConfiguration cache() {
        return new CacheConfigurationImpl(this);
    }

    public void slotCacheSize(int size) {
        this._config.put(SLOT_CACHE_SIZE_KEY, size);
    }

    public int slotCacheSize() {
        return this._config.getAsInt(SLOT_CACHE_SIZE_KEY);
    }

    public boolean fileBasedTransactionLog() {
        return this._config.getAsBoolean(FILE_BASED_TRANSACTION_LOG_KEY);
    }

    public void fileBasedTransactionLog(boolean flag) {
        this._config.put(FILE_BASED_TRANSACTION_LOG_KEY, flag);
    }

    private boolean isTainted() {
        return this._config.getAsBoolean(TAINTED_KEY);
    }

    public void taint() {
        this._config.put(TAINTED_KEY, true);
    }

    public static void assertIsNotTainted(Configuration config) {
        if (((Config4Impl)config).isTainted()) {
            throw new IllegalArgumentException("Configuration already used.");
        }
    }

    @Override
    public void prefetchDepth(int prefetchDepth) {
        this._config.put(PREFETCH_DEPTH_KEY, prefetchDepth);
        this.ensurePrefetchSlotCacheSize();
    }

    private void ensurePrefetchSlotCacheSize() {
        if (!this._prefetchSlotCacheSizeModifiedExternally) {
            this.prefetchSlotCacheSize(this.calculatedPrefetchSlotcacheSize());
            this._prefetchSlotCacheSizeModifiedExternally = false;
        }
    }

    public int prefetchDepth() {
        return this._config.getAsInt(PREFETCH_DEPTH_KEY);
    }

    public List environmentContributions() {
        return (List)this._config.get(ENVIRONMENT_CONTRIBUTIONS_KEY);
    }

    @Override
    public void prefetchSlotCacheSize(int slotCacheSize) {
        this._prefetchSlotCacheSizeModifiedExternally = true;
        this._config.put(PREFETCH_SLOT_CACHE_SIZE_KEY, slotCacheSize);
        this._prefetchSettingsChanged.trigger(EventArgs.EMPTY);
    }

    public int prefetchSlotCacheSize() {
        return this._config.getAsInt(PREFETCH_SLOT_CACHE_SIZE_KEY);
    }

    private int calculatedPrefetchSlotcacheSize() {
        long calculated = (long)this.prefetchDepth() * (long)this.prefetchObjectCount() * 10L;
        if (calculated > 10000L) {
            calculated = 10000L;
        }
        return (int)calculated;
    }

    public Event4<EventArgs> prefetchSettingsChanged() {
        return this._prefetchSettingsChanged;
    }

    public void referenceSystemFactory(ReferenceSystemFactory referenceSystemFactory) {
        this._config.put(REFERENCE_SYSTEM_FACTORY_KEY, referenceSystemFactory);
    }

    public ReferenceSystemFactory referenceSystemFactory() {
        return (ReferenceSystemFactory)this._config.get(REFERENCE_SYSTEM_FACTORY_KEY);
    }

    public void nameProvider(NameProvider provider) {
        this._config.put(NAME_PROVIDER_KEY, provider);
    }

    public NameProvider nameProvider() {
        return (NameProvider)this._config.get(NAME_PROVIDER_KEY);
    }

    public static class ConfigDeepCloneContext {
        public final Config4Impl _orig;
        public final Config4Impl _cloned;

        public ConfigDeepCloneContext(Config4Impl orig, Config4Impl cloned) {
            this._orig = orig;
            this._cloned = cloned;
        }
    }
}

