/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.BuiltinTypeHandler;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.HandlerVersionRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectTypeMetadata;
import com.db4o.internal.OpenTypeHandler;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveTypeMetadata;
import com.db4o.internal.SharedIndexedFields;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.handlers.BooleanHandler;
import com.db4o.internal.handlers.ByteHandler;
import com.db4o.internal.handlers.CharHandler;
import com.db4o.internal.handlers.DateHandler;
import com.db4o.internal.handlers.DateHandler0;
import com.db4o.internal.handlers.DoubleHandler;
import com.db4o.internal.handlers.DoubleHandler0;
import com.db4o.internal.handlers.FloatHandler;
import com.db4o.internal.handlers.FloatHandler0;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.handlers.IntHandler0;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.handlers.LongHandler0;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.ShortHandler;
import com.db4o.internal.handlers.ShortHandler0;
import com.db4o.internal.handlers.StandardReferenceTypeHandler;
import com.db4o.internal.handlers.StandardReferenceTypeHandler0;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.handlers.StringHandler0;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.ArrayHandler0;
import com.db4o.internal.handlers.array.ArrayHandler1;
import com.db4o.internal.handlers.array.ArrayHandler3;
import com.db4o.internal.handlers.array.ArrayHandler5;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler0;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler3;
import com.db4o.internal.handlers.versions.OpenTypeHandler0;
import com.db4o.internal.handlers.versions.OpenTypeHandler2;
import com.db4o.internal.handlers.versions.OpenTypeHandler7;
import com.db4o.internal.marshall.HandlerVersionContext;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.TypeHandler4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerRegistry {
    public static final byte HANDLER_VERSION = 10;
    private final ObjectContainerBase _container;
    private static final Db4oTypeImpl[] _db4oTypes = new Db4oTypeImpl[]{new BlobImpl()};
    private TypeHandler4 _openArrayHandler;
    private TypeHandler4 _openMultiDimensionalArrayHandler;
    private TypeHandler4 _openTypeHandler;
    public StringHandler _stringHandler;
    private Hashtable4 _mapIdToTypeInfo = HandlerRegistry.newHashtable();
    private Hashtable4 _mapReflectorToClassMetadata = HandlerRegistry.newHashtable();
    private int _highestBuiltinTypeID = 14;
    private final VirtualFieldMetadata[] _virtualFields = new VirtualFieldMetadata[2];
    private final Hashtable4 _mapReflectorToTypeHandler = HandlerRegistry.newHashtable();
    private SharedIndexedFields _indexes;
    Db4oReplicationReferenceProvider _replicationReferenceProvider;
    public final DiagnosticProcessor _diagnosticProcessor;
    public boolean i_encrypt;
    byte[] i_encryptor;
    int i_lastEncryptorByte;
    final GenericReflector _reflector;
    private final HandlerVersionRegistry _handlerVersions = new HandlerVersionRegistry(this);
    private LatinStringIO _stringIO;
    public ReflectClass ICLASS_COMPARE;
    ReflectClass ICLASS_DB4OTYPE;
    ReflectClass ICLASS_DB4OTYPEIMPL;
    public ReflectClass ICLASS_INTERNAL;
    ReflectClass ICLASS_UNVERSIONED;
    public ReflectClass ICLASS_OBJECT;
    ReflectClass ICLASS_OBJECTCONTAINER;
    public ReflectClass ICLASS_STATICCLASS;
    public ReflectClass ICLASS_STRING;
    ReflectClass ICLASS_TRANSIENTCLASS;
    private PrimitiveTypeMetadata _untypedArrayMetadata;
    private PrimitiveTypeMetadata _untypedMultiDimensionalMetadata;

    HandlerRegistry(ObjectContainerBase container, byte stringEncoding, GenericReflector reflector) {
        this._stringIO = BuiltInStringEncoding.stringIoForEncoding(stringEncoding, container.configImpl().stringEncoding());
        this._container = container;
        container._handlers = this;
        this._reflector = reflector;
        this._diagnosticProcessor = container.configImpl().diagnosticProcessor();
        this.initClassReflectors(reflector);
        this._indexes = new SharedIndexedFields();
        this._virtualFields[0] = this._indexes._version;
        this._virtualFields[1] = this._indexes._uUID;
        this.registerBuiltinHandlers();
        this.registerPlatformTypes();
        this.initArrayHandlers();
        Platform4.registerPlatformHandlers(container);
    }

    private void initArrayHandlers() {
        TypeHandler4 elementHandler = this.openTypeHandler();
        this._untypedArrayMetadata = new PrimitiveTypeMetadata(this.container(), new ArrayHandler(elementHandler, false), 12, this.ICLASS_OBJECT);
        this._openArrayHandler = this._untypedArrayMetadata.typeHandler();
        this.mapTypeInfo(12, this._untypedArrayMetadata, null);
        this._untypedMultiDimensionalMetadata = new PrimitiveTypeMetadata(this.container(), new MultidimensionalArrayHandler(elementHandler, false), 13, this.ICLASS_OBJECT);
        this._openMultiDimensionalArrayHandler = this._untypedMultiDimensionalMetadata.typeHandler();
        this.mapTypeInfo(13, this._untypedMultiDimensionalMetadata, null);
    }

    private void registerPlatformTypes() {
        NetTypeHandler[] handlers = Platform4.types(this._container.reflector());
        for (int i = 0; i < handlers.length; ++i) {
            this.registerNetTypeHandler(handlers[i]);
        }
    }

    public void registerNetTypeHandler(NetTypeHandler handler) {
        handler.registerReflector(this._reflector);
        GenericConverter converter = handler instanceof GenericConverter ? (GenericConverter)((Object)handler) : null;
        this.registerBuiltinHandler(handler.getID(), handler, true, handler.getName(), converter);
    }

    private void registerBuiltinHandlers() {
        IntHandler intHandler = new IntHandler();
        this.registerBuiltinHandler(1, intHandler);
        this.registerHandlerVersion(intHandler, 0, new IntHandler0());
        LongHandler longHandler = new LongHandler();
        this.registerBuiltinHandler(2, longHandler);
        this.registerHandlerVersion(longHandler, 0, new LongHandler0());
        FloatHandler floatHandler = new FloatHandler();
        this.registerBuiltinHandler(3, floatHandler);
        this.registerHandlerVersion(floatHandler, 0, new FloatHandler0());
        BooleanHandler booleanHandler = new BooleanHandler();
        this.registerBuiltinHandler(4, booleanHandler);
        DoubleHandler doubleHandler = new DoubleHandler();
        this.registerBuiltinHandler(5, doubleHandler);
        this.registerHandlerVersion(doubleHandler, 0, new DoubleHandler0());
        ByteHandler byteHandler = new ByteHandler();
        this.registerBuiltinHandler(6, byteHandler);
        CharHandler charHandler = new CharHandler();
        this.registerBuiltinHandler(7, charHandler);
        ShortHandler shortHandler = new ShortHandler();
        this.registerBuiltinHandler(8, shortHandler);
        this.registerHandlerVersion(shortHandler, 0, new ShortHandler0());
        this._stringHandler = new StringHandler();
        this.registerBuiltinHandler(9, this._stringHandler);
        this.registerHandlerVersion(this._stringHandler, 0, new StringHandler0());
        DateHandler dateHandler = new DateHandler();
        this.registerBuiltinHandler(10, dateHandler);
        this.registerHandlerVersion(dateHandler, 0, new DateHandler0());
        this.registerUntypedHandlers();
        this.registerCompositeHandlerVersions();
    }

    private void registerUntypedHandlers() {
        this._openTypeHandler = new OpenTypeHandler(this.container());
        ObjectTypeMetadata classMetadata = new ObjectTypeMetadata(this.container(), this._openTypeHandler, 11, this.ICLASS_OBJECT);
        this.map(11, classMetadata, this.ICLASS_OBJECT);
        this.registerHandlerVersion(this._openTypeHandler, 0, new OpenTypeHandler0(this.container()));
        this.registerHandlerVersion(this._openTypeHandler, 2, new OpenTypeHandler2(this.container()));
        this.registerHandlerVersion(this._openTypeHandler, 7, new OpenTypeHandler7(this.container()));
    }

    private void registerCompositeHandlerVersions() {
        this.registerHandlerVersion(new StandardReferenceTypeHandler(), 0, new StandardReferenceTypeHandler0());
        ArrayHandler arrayHandler = new ArrayHandler();
        this.registerHandlerVersion(arrayHandler, 0, new ArrayHandler0());
        this.registerHandlerVersion(arrayHandler, 1, new ArrayHandler1());
        this.registerHandlerVersion(arrayHandler, 3, new ArrayHandler3());
        this.registerHandlerVersion(arrayHandler, 5, new ArrayHandler5());
        MultidimensionalArrayHandler multidimensionalArrayHandler = new MultidimensionalArrayHandler();
        this.registerHandlerVersion(multidimensionalArrayHandler, 0, new MultidimensionalArrayHandler0());
        this.registerHandlerVersion(multidimensionalArrayHandler, 3, new MultidimensionalArrayHandler3());
    }

    private void registerBuiltinHandler(int id, BuiltinTypeHandler handler) {
        this.registerBuiltinHandler(id, handler, true, null, null);
    }

    private void registerBuiltinHandler(int id, BuiltinTypeHandler typeHandler, boolean registerPrimitiveClass, String primitiveName, GenericConverter converter) {
        ReflectClass primitiveClassReflector;
        typeHandler.registerReflector(this._reflector);
        if (primitiveName == null) {
            primitiveName = typeHandler.classReflector().getName();
        }
        if (registerPrimitiveClass) {
            this._reflector.registerPrimitiveClass(id, primitiveName, converter);
        }
        ReflectClass classReflector = typeHandler.classReflector();
        PrimitiveTypeMetadata classMetadata = new PrimitiveTypeMetadata(this.container(), typeHandler, id, classReflector);
        this.map(id, classMetadata, classReflector);
        if (typeHandler instanceof PrimitiveHandler && (primitiveClassReflector = ((PrimitiveHandler)typeHandler).primitiveClassReflector()) != null) {
            this.mapPrimitive(0, classMetadata, primitiveClassReflector);
        }
    }

    private void map(int id, PrimitiveTypeMetadata classMetadata, ReflectClass classReflector) {
        this.mapTypeInfo(id, classMetadata, classReflector);
        this.mapPrimitive(id, classMetadata, classReflector);
        if (id > this._highestBuiltinTypeID) {
            this._highestBuiltinTypeID = id;
        }
    }

    private void mapTypeInfo(int id, ClassMetadata classMetadata, ReflectClass classReflector) {
        this._mapIdToTypeInfo.put(id, (Object)new TypeInfo(classMetadata, classReflector));
    }

    private void mapPrimitive(int id, ClassMetadata classMetadata, ReflectClass classReflector) {
        this.mapClassToTypeHandler(classReflector, classMetadata.typeHandler());
        if (classReflector != null) {
            this._mapReflectorToClassMetadata.put(classReflector, (Object)classMetadata);
        }
    }

    private void mapClassToTypeHandler(ReflectClass classReflector, TypeHandler4 typeHandler) {
        this._mapReflectorToTypeHandler.put(classReflector, (Object)typeHandler);
    }

    public void registerHandlerVersion(TypeHandler4 handler, int version, TypeHandler4 replacement) {
        if (replacement instanceof BuiltinTypeHandler) {
            ((BuiltinTypeHandler)replacement).registerReflector(this._reflector);
        }
        this._handlerVersions.put(handler, version, replacement);
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 handler, int version) {
        return this._handlerVersions.correctHandlerVersion(handler, version);
    }

    public static TypeHandler4 correctHandlerVersion(HandlerVersionContext context, TypeHandler4 typeHandler, ClassMetadata classMetadata) {
        TypeHandler4 correctHandlerVersion = HandlerRegistry.correctHandlerVersion(context, typeHandler);
        if (typeHandler != correctHandlerVersion) {
            HandlerRegistry.correctClassMetadataOn(correctHandlerVersion, classMetadata);
            if (correctHandlerVersion instanceof ArrayHandler) {
                ArrayHandler arrayHandler = (ArrayHandler)correctHandlerVersion;
                HandlerRegistry.correctClassMetadataOn(arrayHandler.delegateTypeHandler(), classMetadata);
            }
        }
        return correctHandlerVersion;
    }

    private static void correctClassMetadataOn(TypeHandler4 typeHandler, ClassMetadata classMetadata) {
        if (typeHandler instanceof StandardReferenceTypeHandler) {
            StandardReferenceTypeHandler handler = (StandardReferenceTypeHandler)typeHandler;
            handler.classMetadata(classMetadata);
        }
    }

    ArrayType arrayType(Object obj) {
        ReflectClass claxx = this.reflector().forObject(obj);
        if (!claxx.isArray()) {
            return ArrayType.NONE;
        }
        if (this.isNDimensional(claxx)) {
            return ArrayType.MULTIDIMENSIONAL_ARRAY;
        }
        return ArrayType.PLAIN_ARRAY;
    }

    public final void decrypt(ByteArrayBuffer reader) {
        if (this.i_encrypt) {
            int encryptorOffSet = this.i_lastEncryptorByte;
            byte[] bytes = reader._buffer;
            for (int i = reader.length() - 1; i >= 0; --i) {
                int n = i;
                bytes[n] = (byte)(bytes[n] + this.i_encryptor[encryptorOffSet]);
                if (encryptorOffSet == 0) {
                    encryptorOffSet = this.i_lastEncryptorByte;
                    continue;
                }
                --encryptorOffSet;
            }
        }
    }

    public final void encrypt(ByteArrayBuffer reader) {
        if (this.i_encrypt) {
            byte[] bytes = reader._buffer;
            int encryptorOffSet = this.i_lastEncryptorByte;
            for (int i = reader.length() - 1; i >= 0; --i) {
                int n = i;
                bytes[n] = (byte)(bytes[n] - this.i_encryptor[encryptorOffSet]);
                if (encryptorOffSet == 0) {
                    encryptorOffSet = this.i_lastEncryptorByte;
                    continue;
                }
                --encryptorOffSet;
            }
        }
    }

    public void oldEncryptionOff() {
        this.i_encrypt = false;
        this.i_encryptor = null;
        this.i_lastEncryptorByte = 0;
        this.container().configImpl().oldEncryptionOff();
    }

    public final ReflectClass classForID(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.classReflector;
    }

    private TypeInfo typeInfoForID(int id) {
        return (TypeInfo)this._mapIdToTypeInfo.get(id);
    }

    private void initClassReflectors(GenericReflector reflector) {
        this.ICLASS_COMPARE = reflector.forClass(Const4.CLASS_COMPARE);
        this.ICLASS_DB4OTYPE = reflector.forClass(Const4.CLASS_DB4OTYPE);
        this.ICLASS_DB4OTYPEIMPL = reflector.forClass(Const4.CLASS_DB4OTYPEIMPL);
        this.ICLASS_INTERNAL = reflector.forClass(Const4.CLASS_INTERNAL);
        this.ICLASS_UNVERSIONED = reflector.forClass(Const4.CLASS_UNVERSIONED);
        this.ICLASS_OBJECT = reflector.forClass(Const4.CLASS_OBJECT);
        this.ICLASS_OBJECTCONTAINER = reflector.forClass(Const4.CLASS_OBJECTCONTAINER);
        this.ICLASS_STATICCLASS = reflector.forClass(Const4.CLASS_STATICCLASS);
        this.ICLASS_STRING = reflector.forClass(String.class);
        this.ICLASS_TRANSIENTCLASS = reflector.forClass(Const4.CLASS_TRANSIENTCLASS);
        Platform4.registerCollections(reflector);
    }

    void initEncryption(Config4Impl a_config) {
        if (a_config.encrypt() && a_config.password() != null && a_config.password().length() > 0) {
            this.i_encrypt = true;
            this.i_encryptor = new byte[a_config.password().length()];
            for (int i = 0; i < this.i_encryptor.length; ++i) {
                this.i_encryptor[i] = (byte)(a_config.password().charAt(i) & 0xFF);
            }
            this.i_lastEncryptorByte = a_config.password().length() - 1;
            return;
        }
        this.oldEncryptionOff();
    }

    static Db4oTypeImpl getDb4oType(ReflectClass clazz) {
        for (int i = 0; i < _db4oTypes.length; ++i) {
            if (!clazz.isInstance(_db4oTypes[i])) continue;
            return _db4oTypes[i];
        }
        return null;
    }

    public ClassMetadata classMetadataForId(int id) {
        TypeInfo typeInfo = this.typeInfoForID(id);
        if (typeInfo == null) {
            return null;
        }
        return typeInfo.classMetadata;
    }

    ClassMetadata classMetadataForClass(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return this.isNDimensional(clazz) ? this._untypedMultiDimensionalMetadata : this._untypedArrayMetadata;
        }
        return (ClassMetadata)this._mapReflectorToClassMetadata.get(clazz);
    }

    public TypeHandler4 openTypeHandler() {
        return this._openTypeHandler;
    }

    public TypeHandler4 openArrayHandler(ReflectClass clazz) {
        if (clazz.isArray()) {
            if (this.isNDimensional(clazz)) {
                return this._openMultiDimensionalArrayHandler;
            }
            return this._openArrayHandler;
        }
        return null;
    }

    private boolean isNDimensional(ReflectClass clazz) {
        return this.reflector().array().isNDimensional(clazz);
    }

    public TypeHandler4 typeHandlerForClass(ReflectClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            if (this.isNDimensional(clazz)) {
                return this._openMultiDimensionalArrayHandler;
            }
            return this._openArrayHandler;
        }
        TypeHandler4 cachedTypeHandler = (TypeHandler4)this._mapReflectorToTypeHandler.get(clazz);
        if (cachedTypeHandler != null) {
            return cachedTypeHandler;
        }
        TypeHandler4 configuredTypeHandler = this.configuredTypeHandler(clazz);
        if (Handlers4.isValueType(configuredTypeHandler)) {
            return configuredTypeHandler;
        }
        return null;
    }

    public boolean isSystemHandler(int id) {
        return id > 0 && id <= this._highestBuiltinTypeID;
    }

    public VirtualFieldMetadata virtualFieldByName(String name) {
        for (int i = 0; i < this._virtualFields.length; ++i) {
            if (!name.equals(this._virtualFields[i].getName())) continue;
            return this._virtualFields[i];
        }
        return null;
    }

    public SharedIndexedFields indexes() {
        return this._indexes;
    }

    public LatinStringIO stringIO() {
        return this._stringIO;
    }

    public void stringIO(LatinStringIO io) {
        this._stringIO = io;
    }

    private GenericReflector reflector() {
        return this.container().reflector();
    }

    private ObjectContainerBase container() {
        return this._container;
    }

    private static final Hashtable4 newHashtable() {
        return new Hashtable4(32);
    }

    public TypeHandler4 configuredTypeHandler(ReflectClass claxx) {
        Object cachedHandler = this._mapReflectorToTypeHandler.get(claxx);
        if (null != cachedHandler) {
            return (TypeHandler4)cachedHandler;
        }
        TypeHandler4 typeHandler = this.container().configImpl().typeHandlerForClass(claxx, (byte)10);
        if (typeHandler instanceof BuiltinTypeHandler) {
            ((BuiltinTypeHandler)typeHandler).registerReflector(this.reflector());
        }
        if (Handlers4.isValueType(typeHandler)) {
            this.mapClassToTypeHandler(claxx, typeHandler);
        }
        return typeHandler;
    }

    public static TypeHandler4 correctHandlerVersion(HandlerVersionContext context, TypeHandler4 handler) {
        int version = context.handlerVersion();
        if (version >= 10) {
            return handler;
        }
        return context.transaction().container().handlers().correctHandlerVersion(handler, version);
    }

    public boolean isTransient(ReflectClass claxx) {
        return this.ICLASS_TRANSIENTCLASS.isAssignableFrom(claxx) || Platform4.isTransient(claxx);
    }

    public void treatAsOpenType(Class<?> clazz) {
        this.mapClassToTypeHandler(this.reflectClassFor(clazz), this.openTypeHandler());
    }

    private ReflectClass reflectClassFor(Class<?> clazz) {
        return this.container().reflector().forClass(clazz);
    }

    private static class TypeInfo {
        public ClassMetadata classMetadata;
        public ReflectClass classReflector;

        public TypeInfo(ClassMetadata classMetadata_, ReflectClass classReflector_) {
            this.classMetadata = classMetadata_;
            this.classReflector = classReflector_;
        }
    }
}

