/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.InvalidSlotException;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IdentitySet4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.CommittedCallbackDispatcher;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.FrozenObjectInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.IoAdaptedObjectContainer;
import com.db4o.internal.LazyObjectReference;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LockedTree;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.SlotChangeCollector;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.WriteUpdateProcessor;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.caching.Cache4;
import com.db4o.internal.caching.CacheFactory;
import com.db4o.internal.caching.NullCache4;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.transactionlog.EmbeddedTransactionLogHandler;
import com.db4o.internal.transactionlog.FileBasedTransactionLogHandler;
import com.db4o.internal.transactionlog.TransactionLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransaction
extends Transaction {
    private final byte[] _pointerBuffer = new byte[8];
    protected final StatefulBuffer i_pointerIo;
    private final IdentitySet4 _participants = new IdentitySet4();
    private final LockedTree _slotChanges = new LockedTree();
    Tree _writtenUpdateAdjustedIndexes;
    protected final LocalObjectContainer _file;
    private final CommittedCallbackDispatcher _committedCallbackDispatcher;
    private final Cache4<Integer, ByteArrayBuffer> _slotCache;
    private TransactionLogHandler _transactionLogHandler = new EmbeddedTransactionLogHandler();

    public LocalTransaction(ObjectContainerBase container, Transaction parentTransaction, ReferenceSystem referenceSystem) {
        super(container, parentTransaction, referenceSystem);
        this._file = (LocalObjectContainer)container;
        this.i_pointerIo = new StatefulBuffer((Transaction)this, 8);
        this._committedCallbackDispatcher = new CommittedCallbackDispatcher(){

            public boolean willDispatchCommitted() {
                return LocalTransaction.this.callbacks().caresAboutCommitted();
            }

            public void dispatchCommitted(CallbackObjectInfoCollections committedInfo) {
                LocalTransaction.this.callbacks().commitOnCompleted(LocalTransaction.this, committedInfo);
            }
        };
        this._slotCache = this.createSlotCache();
        this.initializeTransactionLogHandler();
    }

    private Cache4<Integer, ByteArrayBuffer> createSlotCache() {
        int slotCacheSize;
        if (this.isSystemTransaction() && (slotCacheSize = this.config().slotCacheSize()) > 0) {
            return CacheFactory.new2QCache(slotCacheSize);
        }
        return new NullCache4<Integer, ByteArrayBuffer>();
    }

    private void initializeTransactionLogHandler() {
        boolean fileBased;
        if (!this.isSystemTransaction()) {
            this._transactionLogHandler = ((LocalTransaction)this.systemTransaction())._transactionLogHandler;
            return;
        }
        boolean bl = fileBased = this.config().fileBasedTransactionLog() && this.container() instanceof IoAdaptedObjectContainer;
        if (!fileBased) {
            this._transactionLogHandler = new EmbeddedTransactionLogHandler();
            return;
        }
        String fileName = ((IoAdaptedObjectContainer)this.container()).fileName();
        this._transactionLogHandler = new FileBasedTransactionLogHandler(this, fileName);
    }

    public Config4Impl config() {
        return this.container().config();
    }

    public LocalObjectContainer file() {
        return this._file;
    }

    @Override
    public void commit() {
        this.commit(this._committedCallbackDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommittedCallbackDispatcher dispatcher) {
        Object object = this.container().lock();
        synchronized (object) {
            this.dispatchCommittingCallback();
            if (!this.doCommittedCallbacks(dispatcher)) {
                this.commitListeners();
                this.commitImpl();
                this.commitClearAll();
            } else {
                this.commitListeners();
                Collection4 deleted = this.collectCommittedCallbackDeletedInfo();
                this.commitImpl();
                CallbackObjectInfoCollections committedInfo = this.collectCommittedCallbackInfo(deleted);
                this.commitClearAll();
                dispatcher.dispatchCommitted(CallbackObjectInfoCollections.EMTPY == committedInfo ? committedInfo : new CallbackObjectInfoCollections(committedInfo.added, committedInfo.updated, new ObjectInfoCollectionImpl(deleted)));
            }
        }
    }

    private void dispatchCommittingCallback() {
        if (this.doCommittingCallbacks()) {
            this.callbacks().commitOnStarted(this, this.collectCommittingCallbackInfo());
        }
    }

    private boolean doCommittedCallbacks(CommittedCallbackDispatcher dispatcher) {
        if (this.isSystemTransaction()) {
            return false;
        }
        return dispatcher.willDispatchCommitted();
    }

    private boolean doCommittingCallbacks() {
        if (this.isSystemTransaction()) {
            return false;
        }
        return this.callbacks().caresAboutCommitting();
    }

    public void enlist(TransactionParticipant participant) {
        if (null == participant) {
            throw new ArgumentNullException();
        }
        this.checkSynchronization();
        if (!this._participants.contains(participant)) {
            this._participants.add(participant);
        }
    }

    private void commitImpl() {
        if (DTrace.enabled) {
            DTrace.TRANS_COMMIT.logInfo("server == " + this.container().isServer() + ", systemtrans == " + this.isSystemTransaction());
        }
        this.commit3Stream();
        this.commitParticipants();
        this.container().writeDirty();
        Slot reservedSlot = this._transactionLogHandler.allocateSlot(this, false);
        this.freeSlotChanges(false);
        this.freespaceBeginCommit();
        this.commitFreespace();
        this.freeSlotChanges(true);
        this._transactionLogHandler.applySlotChanges(this, reservedSlot);
        this.freespaceEndCommit();
    }

    public final void freeSlotChanges(final boolean forFreespace) {
        Visitor4 visitor = new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).freeDuringCommit(LocalTransaction.this._file, forFreespace);
            }
        };
        if (this.isSystemTransaction()) {
            this._slotChanges.traverseMutable(visitor);
            return;
        }
        this._slotChanges.traverseLocked(visitor);
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().freeSlotChanges(forFreespace);
        }
    }

    private void commitListeners() {
        this.commitParentListeners();
        this.commitTransactionListeners();
    }

    private void commitParentListeners() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commitListeners();
        }
    }

    private void commitParticipants() {
        if (this.parentLocalTransaction() != null) {
            this.parentLocalTransaction().commitParticipants();
        }
        Iterator4 iterator = this._participants.iterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).commit(this);
        }
    }

    private void commit3Stream() {
        this.container().processPendingClassUpdates();
        this.container().writeDirty();
        this.container().classCollection().write(this.container().systemTransaction());
    }

    private LocalTransaction parentLocalTransaction() {
        return (LocalTransaction)this._systemTransaction;
    }

    private void commitClearAll() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commitClearAll();
        }
        this.clearAll();
    }

    @Override
    protected void clear() {
        this._slotChanges.clear();
        this.disposeParticipants();
        this._participants.clear();
    }

    private void disposeParticipants() {
        Iterator4 iterator = this._participants.valuesIterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Object object = this.container().lock();
        synchronized (object) {
            this.rollbackParticipants();
            this.rollbackSlotChanges();
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    private void rollbackParticipants() {
        Iterator4 iterator = this._participants.valuesIterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).rollback(this);
        }
    }

    protected void rollbackSlotChanges() {
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object a_object) {
                ((SlotChange)a_object).rollback(LocalTransaction.this._file);
            }
        });
    }

    @Override
    public boolean isDeleted(int id) {
        return this.slotChangeIsFlaggedDeleted(id);
    }

    public void writeZeroPointer(int id) {
        this.writePointer(id, Slot.ZERO);
    }

    public void writePointer(Pointer4 pointer) {
        this.writePointer(pointer._id, pointer._slot);
    }

    public void writePointer(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.WRITE_POINTER.log(id);
            DTrace.WRITE_POINTER.logLength(slot);
        }
        this.checkSynchronization();
        this.i_pointerIo.useSlot(id);
        this.i_pointerIo.writeInt(slot.address());
        this.i_pointerIo.writeInt(slot.length());
        this.i_pointerIo.write();
    }

    public boolean writeSlots() {
        final BooleanByRef ret = new BooleanByRef();
        this.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).writePointer(LocalTransaction.this);
                ret.value = true;
            }
        });
        return ret.value;
    }

    public void flushFile() {
        if (DTrace.enabled) {
            DTrace.TRANS_FLUSH.log();
        }
        this._file.syncFiles();
    }

    private SlotChange produceSlotChange(int id) {
        if (DTrace.enabled) {
            DTrace.PRODUCE_SLOT_CHANGE.log(id);
        }
        SlotChange slot = new SlotChange(id);
        this._slotChanges.add(slot);
        return (SlotChange)slot.addedOrExisting();
    }

    public final SlotChange findSlotChange(int a_id) {
        this.checkSynchronization();
        return (SlotChange)this._slotChanges.find(a_id);
    }

    public Slot getCurrentSlotOfID(int id) {
        Slot parentSlot;
        this.checkSynchronization();
        if (id == 0) {
            return null;
        }
        SlotChange change = this.findSlotChange(id);
        if (change != null && change.isSetPointer()) {
            return change.newSlot();
        }
        if (this._systemTransaction != null && (parentSlot = this.parentLocalTransaction().getCurrentSlotOfID(id)) != null) {
            return parentSlot;
        }
        return this.readPointer((int)id)._slot;
    }

    public Slot getCommittedSlotOfID(int id) {
        Slot parentSlot;
        Slot slot;
        if (id == 0) {
            return null;
        }
        SlotChange change = this.findSlotChange(id);
        if (change != null && (slot = change.oldSlot()) != null) {
            return slot;
        }
        if (this._systemTransaction != null && (parentSlot = this.parentLocalTransaction().getCommittedSlotOfID(id)) != null) {
            return parentSlot;
        }
        return this.readPointer((int)id)._slot;
    }

    public Pointer4 readPointer(int id) {
        if (!this.isValidId(id)) {
            throw new InvalidIDException(id);
        }
        this._file.readBytes(this._pointerBuffer, id, 8);
        int address = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int length = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        if (!this.isValidSlot(address, length)) {
            throw new InvalidSlotException(address, length, id);
        }
        return new Pointer4(id, new Slot(address, length));
    }

    private boolean isValidId(int id) {
        return this._file.fileLength() >= (long)id;
    }

    private boolean isValidSlot(int address, int length) {
        long fileLength = this._file.fileLength();
        boolean validAddress = fileLength >= (long)address;
        boolean validLength = fileLength >= (long)length;
        boolean validSlot = fileLength >= (long)(address + length);
        return validAddress && validLength && validSlot;
    }

    private Pointer4 debugReadPointer(int id) {
        return null;
    }

    @Override
    public void setPointer(int a_id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.SLOT_SET_POINTER.log(a_id);
            DTrace.SLOT_SET_POINTER.logLength(slot);
        }
        this.checkSynchronization();
        this.produceSlotChange(a_id).setPointer(slot);
    }

    private boolean slotChangeIsFlaggedDeleted(int id) {
        SlotChange slot = this.findSlotChange(id);
        if (slot != null) {
            return slot.isDeleted();
        }
        if (this._systemTransaction != null) {
            return this.parentLocalTransaction().slotChangeIsFlaggedDeleted(id);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void completeInterruptedTransaction() {
        Object object = this.container().lock();
        synchronized (object) {
            this._transactionLogHandler.completeInterruptedTransaction(this);
        }
    }

    public void traverseSlotChanges(Visitor4 visitor) {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().traverseSlotChanges(visitor);
        }
        this._slotChanges.traverseLocked(visitor);
    }

    @Override
    public void slotDelete(int id, Slot slot) {
        this.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.SLOT_DELETE.log(id);
            DTrace.SLOT_DELETE.logLength(slot);
        }
        if (id == 0) {
            return;
        }
        SlotChange slotChange = this.produceSlotChange(id);
        slotChange.freeOnCommit(this._file, slot);
        slotChange.setPointer(Slot.ZERO);
    }

    @Override
    public void slotFreeOnCommit(int id, Slot slot) {
        this.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.SLOT_FREE_ON_COMMIT.log(id);
            DTrace.SLOT_FREE_ON_COMMIT.logLength(slot);
        }
        if (id == 0) {
            return;
        }
        this.produceSlotChange(id).freeOnCommit(this._file, slot);
    }

    @Override
    public void slotFreeOnRollback(int id, Slot slot) {
        this.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.SLOT_FREE_ON_ROLLBACK_ID.log(id);
            DTrace.SLOT_FREE_ON_ROLLBACK_ADDRESS.logLength(slot);
        }
        this.produceSlotChange(id).freeOnRollback(slot);
    }

    @Override
    void slotFreeOnRollbackCommitSetPointer(int id, Slot newSlot, boolean forFreespace) {
        Slot oldSlot = this.getCurrentSlotOfID(id);
        if (oldSlot == null) {
            return;
        }
        this.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.FREE_ON_ROLLBACK.log(id);
            DTrace.FREE_ON_ROLLBACK.logLength(newSlot);
            DTrace.FREE_ON_COMMIT.log(id);
            DTrace.FREE_ON_COMMIT.logLength(oldSlot);
        }
        SlotChange change = this.produceSlotChange(id);
        change.freeOnRollbackSetPointer(newSlot);
        change.freeOnCommit(this._file, oldSlot);
        change.forFreespace(forFreespace);
    }

    @Override
    void produceUpdateSlotChange(int id, Slot slot) {
        this.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.FREE_ON_ROLLBACK.log(id);
            DTrace.FREE_ON_ROLLBACK.logLength(slot);
        }
        SlotChange slotChange = this.produceSlotChange(id);
        slotChange.freeOnRollbackSetPointer(slot);
    }

    @Override
    public void slotFreePointerOnCommit(int a_id) {
        this.checkSynchronization();
        Slot slot = this.getCurrentSlotOfID(a_id);
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(a_id, slot);
    }

    @Override
    void slotFreePointerOnCommit(int a_id, Slot slot) {
        this.checkSynchronization();
        this.slotFreeOnCommit(slot.address(), slot);
        this.slotFreeOnCommit(a_id, slot);
    }

    @Override
    public void slotFreePointerOnRollback(int id) {
        this.produceSlotChange(id).freePointerOnRollback();
    }

    @Override
    public void processDeletes() {
        if (this._delete == null) {
            this._writtenUpdateAdjustedIndexes = null;
            return;
        }
        while (this._delete != null) {
            Tree delete = this._delete;
            this._delete = null;
            delete.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    DeleteInfo info = (DeleteInfo)a_object;
                    if (LocalTransaction.this.isDeleted(info._key)) {
                        return;
                    }
                    Object obj = null;
                    if (info._reference != null) {
                        obj = info._reference.getObject();
                    }
                    if (obj == null || info._reference.getID() < 0) {
                        HardObjectReference hardRef = LocalTransaction.this.container().getHardObjectReferenceById(LocalTransaction.this, info._key);
                        if (hardRef == HardObjectReference.INVALID) {
                            return;
                        }
                        info._reference = hardRef._reference;
                        info._reference.flagForDelete(LocalTransaction.this.container().topLevelCallId());
                        obj = info._reference.getObject();
                    }
                    LocalTransaction.this.container().delete3(LocalTransaction.this, info._reference, obj, info._cascade, false);
                }
            });
        }
        this._writtenUpdateAdjustedIndexes = null;
    }

    @Override
    public void writeUpdateAdjustIndexes(int id, ClassMetadata clazz, ArrayType typeInfo, int cascade) {
        new WriteUpdateProcessor(this, id, clazz, typeInfo, cascade).run();
    }

    private Callbacks callbacks() {
        return this.container().callbacks();
    }

    private Collection4 collectCommittedCallbackDeletedInfo() {
        final Collection4 deleted = new Collection4();
        this.collectSlotChanges(new SlotChangeCollector(){

            public void deleted(int id) {
                ObjectInfo ref = LocalTransaction.this.frozenReferenceFor(id);
                if (ref != null) {
                    deleted.add(ref);
                }
            }

            public void updated(int id) {
            }

            public void added(int id) {
            }
        });
        return deleted;
    }

    private CallbackObjectInfoCollections collectCommittedCallbackInfo(Collection4 deleted) {
        if (null == this._slotChanges) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 added = new Collection4();
        final Collection4 updated = new Collection4();
        this.collectSlotChanges(new SlotChangeCollector(){

            public void added(int id) {
                added.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void updated(int id) {
                updated.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void deleted(int id) {
            }
        });
        return this.newCallbackObjectInfoCollections(added, updated, deleted);
    }

    private CallbackObjectInfoCollections collectCommittingCallbackInfo() {
        if (null == this._slotChanges) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 added = new Collection4();
        final Collection4 deleted = new Collection4();
        final Collection4 updated = new Collection4();
        this.collectSlotChanges(new SlotChangeCollector(){

            public void added(int id) {
                added.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void updated(int id) {
                updated.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void deleted(int id) {
                ObjectInfo ref = LocalTransaction.this.frozenReferenceFor(id);
                if (ref != null) {
                    deleted.add(ref);
                }
            }
        });
        return this.newCallbackObjectInfoCollections(added, updated, deleted);
    }

    private CallbackObjectInfoCollections newCallbackObjectInfoCollections(Collection4 added, Collection4 updated, Collection4 deleted) {
        return new CallbackObjectInfoCollections(new ObjectInfoCollectionImpl(added), new ObjectInfoCollectionImpl(updated), new ObjectInfoCollectionImpl(deleted));
    }

    private void collectSlotChanges(final SlotChangeCollector collector) {
        if (null == this._slotChanges) {
            return;
        }
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object obj) {
                SlotChange slotChange = (SlotChange)obj;
                int id = slotChange._key;
                if (slotChange.isDeleted()) {
                    if (!slotChange.isNew()) {
                        collector.deleted(id);
                    }
                } else if (slotChange.isNew()) {
                    collector.added(id);
                } else {
                    collector.updated(id);
                }
            }
        });
    }

    public ObjectInfo frozenReferenceFor(int id) {
        ObjectReference ref = this.referenceForId(id);
        if (ref != null) {
            return new FrozenObjectInfo(this, ref, true);
        }
        ref = this.container().peekReference(this.systemTransaction(), id, new FixedActivationDepth(0), true);
        if (ref == null || ref.getObject() == null) {
            return null;
        }
        return new FrozenObjectInfo(this.systemTransaction(), ref, true);
    }

    public static Transaction readInterruptedTransaction(LocalObjectContainer file, ByteArrayBuffer reader) {
        LocalTransaction transaction = (LocalTransaction)file.newTransaction(null, null);
        if (transaction.wasInterrupted(reader)) {
            return transaction;
        }
        return null;
    }

    public boolean wasInterrupted(ByteArrayBuffer reader) {
        return this._transactionLogHandler.checkForInterruptedTransaction(this, reader);
    }

    public FreespaceManager freespaceManager() {
        return this._file.freespaceManager();
    }

    private void freespaceBeginCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().beginCommit();
    }

    private void freespaceEndCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().endCommit();
    }

    private void commitFreespace() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().commit();
    }

    public LazyObjectReference lazyReferenceFor(int id) {
        return new LazyObjectReference(this, id);
    }

    public Cache4<Integer, ByteArrayBuffer> slotCache() {
        return this._slotCache;
    }

    public void readSlotChanges(ByteArrayBuffer buffer) {
        this._slotChanges.read(buffer, new SlotChange(0));
    }

    public void close() {
        this._transactionLogHandler.close();
        this.discardReferenceSystem();
    }
}

