/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.constraints.UniqueFieldValueConstraintViolationException;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.StoredClass;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectContainerSpec;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.query.NativeQueryHandler;
import com.db4o.io.Storage;
import com.db4o.query.JdkComparatorWrapper;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;
import com.db4o.types.TransientClass;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectContainerSession
implements InternalObjectContainer,
TransientClass,
ObjectContainerSpec {
    protected final LocalObjectContainer _server;
    protected final Transaction _transaction;
    private boolean _closed = false;

    public ObjectContainerSession(LocalObjectContainer server, Transaction trans) {
        this._server = server;
        this._transaction = trans;
        this._transaction.setOutSideRepresentation(this);
    }

    public ObjectContainerSession(LocalObjectContainer server) {
        this(server, server.newTransaction(server.systemTransaction(), server.createReferenceSystem()));
    }

    @Override
    public void backup(String path) throws Db4oIOException, DatabaseClosedException, NotSupportedException {
        throw new NotSupportedException();
    }

    @Override
    public void backup(Storage storage, String path) throws Db4oIOException, DatabaseClosedException, NotSupportedException {
        throw new NotSupportedException();
    }

    @Override
    public void bind(Object obj, long id) throws InvalidIDException, DatabaseClosedException {
        this._server.bind(this._transaction, obj, id);
    }

    @Override
    public Config4Impl configImpl() {
        return this._server.configImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration configure() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.configure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object descend(Object obj, String[] path) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.descend(this._transaction, obj, path);
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new DatabaseClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByID(long id) throws DatabaseClosedException, InvalidIDException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getByID(this._transaction, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByUUID(Db4oUUID uuid) throws DatabaseClosedException, Db4oIOException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getByUUID(this._transaction, uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getID(Object obj) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getID(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectInfo getObjectInfo(Object obj) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getObjectInfo(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Db4oDatabase identity() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.identity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Object obj) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.isActive(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCached(long id) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.isCached(this._transaction, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.lock();
        synchronized (object) {
            return this._closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStored(Object obj) throws DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.isStored(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectClass[] knownClasses() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.knownClasses();
        }
    }

    @Override
    public Object lock() {
        return this._server.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekPersisted(Object object, int depth, boolean committed) {
        Object object2 = this.lock();
        synchronized (object2) {
            this.checkClosed();
            return this._server.peekPersisted(this._transaction, object, this.activationDepthProvider().activationDepth(depth, ActivationMode.PEEK), committed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(Object obj) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.purge(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericReflector reflector() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.reflector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Object obj, int depth) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.refresh(this._transaction, obj, depth);
        }
    }

    @Override
    public void releaseSemaphore(String name) {
        this.checkClosed();
        this._server.releaseSemaphore(this._transaction, name);
    }

    @Override
    public ReplicationProcess replicationBegin(ObjectContainer peerB, ReplicationConflictHandler conflictHandler) {
        throw new NotSupportedException();
    }

    @Override
    public void set(Object obj, int depth) {
        this.store(obj, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Object obj, int depth) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.store(this._transaction, obj, depth);
        }
    }

    @Override
    public boolean setSemaphore(String name, int waitForAvailability) {
        this.checkClosed();
        return this._server.setSemaphore(this._transaction, name, waitForAvailability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredClass storedClass(Object clazz) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.storedClass(this._transaction, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredClass[] storedClasses() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.storedClasses(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemInfo systemInfo() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.systemInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long version() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.version();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(Object obj) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.activate(this._transaction, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(Object obj, int depth) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.activate(this._transaction, obj, this.activationDepthProvider().activationDepth(depth, ActivationMode.ACTIVATE));
        }
    }

    private ActivationDepthProvider activationDepthProvider() {
        return this._server.activationDepthProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() throws Db4oIOException {
        Object object = this.lock();
        synchronized (object) {
            if (this.isClosed()) {
                return false;
            }
            if (!this._server.isClosed() && !this._server.configImpl().isReadOnly()) {
                this.commit();
            }
            this._server.callbacks().closeOnStarted(this);
            this._transaction.close(false);
            this._closed = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException, UniqueFieldValueConstraintViolationException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.commit(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate(Object obj, int depth) throws DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.deactivate(this._transaction, obj, depth);
        }
    }

    @Override
    public void deactivate(Object obj) throws DatabaseClosedException {
        this.deactivate(obj, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Object obj) throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.delete(this._transaction, obj);
        }
    }

    @Override
    public ExtObjectContainer ext() {
        return this;
    }

    public ObjectSet get(Object template) throws Db4oIOException, DatabaseClosedException {
        return this.queryByExample(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet queryByExample(Object template) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.queryByExample(this._transaction, template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query query() throws DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet query(Class clazz) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet query(Predicate predicate) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ObjectSet<T> query(Predicate<T> predicate, QueryComparator<T> comparator) throws Db4oIOException, DatabaseClosedException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.query(this._transaction, predicate, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Db4oIOException, DatabaseClosedException, DatabaseReadOnlyException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.rollback(this._transaction);
        }
    }

    @Override
    public void set(Object obj) throws DatabaseClosedException, DatabaseReadOnlyException {
        this.store(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Object obj) throws DatabaseClosedException, DatabaseReadOnlyException {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.store(this._transaction, obj);
        }
    }

    @Override
    public ObjectContainerBase container() {
        return this._server;
    }

    @Override
    public Transaction transaction() {
        return this._transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callbacks(Callbacks cb) {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            this._server.callbacks(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Callbacks callbacks() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.callbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NativeQueryHandler getNativeQueryHandler() {
        Object object = this.lock();
        synchronized (object) {
            this.checkClosed();
            return this._server.getNativeQueryHandler();
        }
    }

    @Override
    public void onCommittedListener() {
    }

    @Override
    public ClassMetadata classMetadataForReflectClass(ReflectClass reflectClass) {
        return this._server.classMetadataForReflectClass(reflectClass);
    }

    @Override
    public ClassMetadata classMetadataForName(String name) {
        return this._server.classMetadataForName(name);
    }

    @Override
    public ClassMetadata classMetadataForID(int id) {
        return this._server.classMetadataForID(id);
    }

    @Override
    public HandlerRegistry handlers() {
        return this._server.handlers();
    }

    public Object syncExec(Closure4 block) {
        return this._server.syncExec(block);
    }

    @Override
    public int instanceCount(ClassMetadata clazz, Transaction trans) {
        return this._server.instanceCount(clazz, trans);
    }

    public ObjectSet query(Predicate predicate, Comparator comparator) throws Db4oIOException, DatabaseClosedException {
        return this._server.query(this._transaction, predicate, new JdkComparatorWrapper(comparator));
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void storeAll(Transaction transaction, Iterator4 objects) {
        this._server.storeAll(transaction, objects);
    }
}

