/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.foundation.Tree;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TreeInt;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;

class WriteUpdateProcessor {
    private final LocalTransaction _localTransaction;
    private final int _id;
    private final ClassMetadata _clazz;
    private final ArrayType _typeInfo;
    private int _cascade;

    public WriteUpdateProcessor(LocalTransaction localTransaction, int id, ClassMetadata clazz, ArrayType typeInfo, int cascade) {
        this._localTransaction = localTransaction;
        this._id = id;
        this._clazz = clazz;
        this._typeInfo = typeInfo;
        this._cascade = cascade;
    }

    public void run() {
        this._localTransaction.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.WRITE_UPDATE_ADJUST_INDEXES.log(this._id);
        }
        if (this.alreadyHandled()) {
            return;
        }
        Slot slot = this._localTransaction.getCurrentSlotOfID(this._id);
        if (this.handledAsReAdd(slot)) {
            return;
        }
        if (this.handledWithNoChildIndexModification(slot)) {
            return;
        }
        StatefulBuffer objectBytes = (StatefulBuffer)this.container().readReaderOrWriterBySlot(this.localTransaction(), this._id, false, slot);
        this.updateChildIndexes(objectBytes);
        this.freeSlotOnCommit(objectBytes);
    }

    private LocalObjectContainer container() {
        return this._localTransaction.file();
    }

    private void freeSlotOnCommit(StatefulBuffer objectBytes) {
        this._localTransaction.slotFreeOnCommit(this._id, new Slot(objectBytes.getAddress(), objectBytes.length()));
    }

    private void updateChildIndexes(StatefulBuffer objectBytes) {
        ObjectHeader oh = new ObjectHeader(this.container(), this._clazz, objectBytes);
        DeleteInfo info = (DeleteInfo)TreeInt.find(this._localTransaction._delete, this._id);
        if (info != null && info._cascade > this._cascade) {
            this._cascade = info._cascade;
        }
        objectBytes.setCascadeDeletes(this._cascade);
        DeleteContextImpl context = new DeleteContextImpl(objectBytes, oh, this._clazz.classReflector(), null);
        this._clazz.deleteMembers(context, this._typeInfo, true);
    }

    private boolean handledAsReAdd(Slot slot) {
        if (slot != null && !slot.isNull()) {
            return false;
        }
        this._clazz.addToIndex(this.localTransaction(), this._id);
        return true;
    }

    private boolean alreadyHandled() {
        TreeInt newNode = new TreeInt(this._id);
        this._localTransaction._writtenUpdateAdjustedIndexes = Tree.add(this._localTransaction._writtenUpdateAdjustedIndexes, newNode);
        return !newNode.wasAddedToTree();
    }

    private boolean handledWithNoChildIndexModification(Slot slot) {
        if (!this._clazz.canUpdateFast()) {
            return false;
        }
        this._localTransaction.slotFreeOnCommit(this._id, slot);
        return true;
    }

    private LocalTransaction localTransaction() {
        return this._localTransaction;
    }
}

