/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.collections;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4JdkIterator;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.SynchronizedIterator4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.collections.BigSetBTreeManager;
import com.db4o.internal.collections.BigSetPersistence;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigSet<E>
implements Set<E>,
BigSetPersistence {
    private BTree _bTree;
    private Transaction _transaction;

    public BigSet(LocalObjectContainer db) {
        if (db == null) {
            return;
        }
        this._transaction = db.transaction();
        this._bTree = this.bTreeManager().newBTree();
    }

    private ObjectContainerBase container() {
        return this.transaction().container();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E obj) {
        Object object = this.lock();
        synchronized (object) {
            int id = this.getID(obj);
            if (id == 0) {
                this.add(this.store(obj));
                return true;
            }
            if (this.contains(id)) {
                return false;
            }
            this.add(id);
            return true;
        }
    }

    private int store(E obj) {
        return this.container().store(this._transaction, obj, -2147483548);
    }

    private void add(int id) {
        this.bTreeForUpdate().add(this._transaction, new Integer(id));
    }

    private int getID(Object obj) {
        return (int)this.container().getID(obj);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Collection<? extends E> iterable = collection;
        return this.addAll((Iterable<? extends E>)iterable);
    }

    @Override
    public boolean addAll(Iterable<? extends E> iterable) {
        boolean result = false;
        for (E element : iterable) {
            if (!this.add(element)) continue;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock();
        synchronized (object) {
            this.bTreeForUpdate().clear(this.transaction());
        }
    }

    @Override
    public boolean contains(Object obj) {
        int id = this.getID(obj);
        if (id == 0) {
            return false;
        }
        return this.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(int id) {
        Object object = this.lock();
        synchronized (object) {
            BTreeRange range = this.bTree().search(this.transaction(), new Integer(id));
            return !range.isEmpty();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Collection<?> iterable = collection;
        for (Object element : iterable) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator4JdkIterator(this.elements());
    }

    private Iterator4 elements() {
        return new MappingIterator(this.bTreeIterator()){

            protected Object map(Object current) {
                int id = (Integer)current;
                return BigSet.this.element(id);
            }
        };
    }

    private Iterator4 bTreeIterator() {
        return new SynchronizedIterator4(this.bTree().iterator(this.transaction()), this.lock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        Object object = this.lock();
        synchronized (object) {
            if (!this.contains(obj)) {
                return false;
            }
            int id = this.getID(obj);
            this.bTreeForUpdate().remove(this.transaction(), new Integer(id));
            return true;
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean res = false;
        for (Object element : collection) {
            if (!this.remove(element)) continue;
            res = true;
        }
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock();
        synchronized (object) {
            return this.bTree().size(this.transaction());
        }
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(WriteContext context) {
        int id = this.bTree().getID();
        if (id == 0) {
            this.bTree().write(this.systemTransaction());
        }
        context.writeInt(this.bTree().getID());
    }

    @Override
    public void read(ReadContext context) {
        int id = context.readInt();
        if (this._bTree != null) {
            this.assertCurrentBTreeId(id);
            return;
        }
        this._transaction = context.transaction();
        this._bTree = this.bTreeManager().produceBTree(id);
    }

    private BigSetBTreeManager bTreeManager() {
        return new BigSetBTreeManager(this._transaction);
    }

    private void assertCurrentBTreeId(int id) {
        if (id != this._bTree.getID()) {
            throw new IllegalStateException();
        }
    }

    private Transaction transaction() {
        return this._transaction;
    }

    private Transaction systemTransaction() {
        return this.container().systemTransaction();
    }

    @Override
    public void invalidate() {
        this._bTree = null;
    }

    private BTree bTree() {
        if (this._bTree == null) {
            throw new IllegalStateException();
        }
        return this._bTree;
    }

    private BTree bTreeForUpdate() {
        BTree bTree = this.bTree();
        this.bTreeManager().ensureIsManaged(bTree);
        return bTree;
    }

    private Object element(int id) {
        Object obj = this.container().getByID(this.transaction(), id);
        this.container().activate(obj);
        return obj;
    }

    private Object lock() {
        return this.container().lock();
    }
}

