/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.diagnostic;

import com.db4o.diagnostic.ClassHasNoFields;
import com.db4o.diagnostic.DefragmentRecommendation;
import com.db4o.diagnostic.DeletionFailed;
import com.db4o.diagnostic.DescendIntoTranslator;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticConfiguration;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.diagnostic.LoadedFromClassIndex;
import com.db4o.diagnostic.NativeQueryNotOptimized;
import com.db4o.diagnostic.NativeQueryOptimizerNotLoaded;
import com.db4o.diagnostic.ObjectFieldDoesNotExist;
import com.db4o.diagnostic.UpdateDepthGreaterOne;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.query.Predicate;

public class DiagnosticProcessor
implements DiagnosticConfiguration,
DeepClone {
    private Collection4 _listeners;

    public DiagnosticProcessor() {
    }

    private DiagnosticProcessor(Collection4 listeners) {
        this._listeners = listeners;
    }

    public void addListener(DiagnosticListener listener) {
        if (this._listeners == null) {
            this._listeners = new Collection4();
        }
        this._listeners.add(listener);
    }

    public void checkClassHasFields(ClassMetadata classMetadata) {
        if (classMetadata.aspectsAreNull() || classMetadata.declaredAspectCount() == 0) {
            String name = classMetadata.getName();
            String[] ignoredPackages = new String[]{"java.util."};
            for (int i = 0; i < ignoredPackages.length; ++i) {
                if (name.indexOf(ignoredPackages[i]) != 0) continue;
                return;
            }
            if (this.isDb4oClass(classMetadata)) {
                return;
            }
            this.onDiagnostic(new ClassHasNoFields(name));
        }
    }

    public void checkUpdateDepth(int depth) {
        if (depth > 1) {
            this.onDiagnostic(new UpdateDepthGreaterOne(depth));
        }
    }

    public Object deepClone(Object context) {
        return new DiagnosticProcessor(this.cloneListeners());
    }

    public void deletionFailed() {
        this.onDiagnostic(new DeletionFailed());
    }

    public void defragmentRecommended(DefragmentRecommendation.DefragmentRecommendationReason reason) {
        this.onDiagnostic(new DefragmentRecommendation(reason));
    }

    private Collection4 cloneListeners() {
        return this._listeners != null ? new Collection4(this._listeners) : null;
    }

    public boolean enabled() {
        return this._listeners != null;
    }

    private boolean isDb4oClass(ClassMetadata classMetadata) {
        return classMetadata.isInternal();
    }

    public void loadedFromClassIndex(ClassMetadata classMetadata) {
        if (this.isDb4oClass(classMetadata)) {
            return;
        }
        this.onDiagnostic(new LoadedFromClassIndex(classMetadata.getName()));
    }

    public void descendIntoTranslator(ClassMetadata parent, String fieldName) {
        this.onDiagnostic(new DescendIntoTranslator(parent.getName(), fieldName));
    }

    public void nativeQueryUnoptimized(Predicate predicate, Exception exception) {
        this.onDiagnostic(new NativeQueryNotOptimized(predicate, exception));
    }

    public void nativeQueryOptimizerNotLoaded(int reason, Exception e) {
        this.onDiagnostic(new NativeQueryOptimizerNotLoaded(reason, e));
    }

    public void objectFieldDoesNotExist(String className, String fieldName) {
        this.onDiagnostic(new ObjectFieldDoesNotExist(className, fieldName));
    }

    public void onDiagnostic(Diagnostic d) {
        if (this._listeners == null) {
            return;
        }
        Iterator4 i = this._listeners.iterator();
        while (i.moveNext()) {
            ((DiagnosticListener)i.current()).onDiagnostic(d);
        }
    }

    public void removeAllListeners() {
        this._listeners = null;
    }
}

