/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;

public class LongHandler
extends PrimitiveHandler {
    private static final Long DEFAULTVALUE = new Long(0L);

    public Object coerce(ReflectClass claxx, Object obj) {
        return Coercion4.toLong(obj);
    }

    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    public Class primitiveJavaClass() {
        return Long.TYPE;
    }

    public int linkLength() {
        return 8;
    }

    public Object read(MarshallerFamily mf, StatefulBuffer buffer, boolean redirect) throws CorruptionException {
        return mf._primitive.readLong(buffer);
    }

    Object read1(ByteArrayBuffer a_bytes) {
        return new Long(a_bytes.readLong());
    }

    public void write(Object obj, ByteArrayBuffer buffer) {
        LongHandler.writeLong(buffer, (Long)obj);
    }

    public static final void writeLong(WriteBuffer buffer, long val) {
        for (int i = 0; i < 8; ++i) {
            buffer.writeByte((byte)(val >> (7 - i) * 8));
        }
    }

    public static final long readLong(ReadBuffer buffer) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret = (ret << 8) + (long)(buffer.readByte() & 0xFF);
        }
        return ret;
    }

    public Object read(ReadContext context) {
        return new Long(context.readLong());
    }

    public void write(WriteContext context, Object obj) {
        context.writeLong((Long)obj);
    }

    public PreparedComparison internalPrepareComparison(Object source) {
        final long sourceLong = (Long)source;
        return new PreparedComparison(){

            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                long targetLong = (Long)target;
                return sourceLong == targetLong ? 0 : (sourceLong < targetLong ? -1 : 1);
            }
        };
    }
}

