/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.DTrace;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.InvalidSlotException;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.IoAdaptedObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.LockedTree;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.SlotChangeCollector;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.EmbeddedTransactionLogHandler;
import com.db4o.internal.ids.FileBasedTransactionLogHandler;
import com.db4o.internal.ids.TransactionLogHandler;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

public class IdSystem {
    private final byte[] _pointerBuffer = new byte[8];
    protected final StatefulBuffer i_pointerIo;
    private final LockedTree _slotChanges = new LockedTree();
    protected final LocalObjectContainer _file;
    private IdSystem _systemIdSystem;
    private TransactionLogHandler _transactionLogHandler = new EmbeddedTransactionLogHandler();

    public IdSystem(ObjectContainerBase container) {
        this._file = (LocalObjectContainer)container;
        this.i_pointerIo = new StatefulBuffer(this._file.transaction(), 8);
        this.initializeTransactionLogHandler();
    }

    private void initializeTransactionLogHandler() {
        boolean fileBased;
        if (!this.isSystemIdSystem()) {
            this._transactionLogHandler = this._systemIdSystem._transactionLogHandler;
            return;
        }
        boolean bl = fileBased = this.config().fileBasedTransactionLog() && this.file() instanceof IoAdaptedObjectContainer;
        if (!fileBased) {
            this._transactionLogHandler = new EmbeddedTransactionLogHandler();
            return;
        }
        String fileName = ((IoAdaptedObjectContainer)this.file()).fileName();
        this._transactionLogHandler = new FileBasedTransactionLogHandler(this, fileName);
    }

    private boolean isSystemIdSystem() {
        return this._systemIdSystem == null;
    }

    public Config4Impl config() {
        return this.file().config();
    }

    public LocalObjectContainer file() {
        return this._file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.file().lock();
        synchronized (object) {
            this.commitImpl();
            this.commitClear();
        }
    }

    private void commitImpl() {
        Slot reservedSlot = this._transactionLogHandler.allocateSlot(this, false);
        this.freeSlotChanges(false);
        this.freespaceBeginCommit();
        this.commitFreespace();
        this.freeSlotChanges(true);
        this._transactionLogHandler.applySlotChanges(this, reservedSlot);
        this.freespaceEndCommit();
    }

    public final void freeSlotChanges(final boolean forFreespace) {
        Visitor4 visitor = new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).freeDuringCommit(IdSystem.this._file, forFreespace);
            }
        };
        if (this.isSystemIdSystem()) {
            this._slotChanges.traverseMutable(visitor);
            return;
        }
        this._slotChanges.traverseLocked(visitor);
        if (this._systemIdSystem != null) {
            this._systemIdSystem.freeSlotChanges(forFreespace);
        }
    }

    private void commitClear() {
        if (this._systemIdSystem != null) {
            this._systemIdSystem.commitClear();
        }
        this.clear();
    }

    protected void clear() {
        this._slotChanges.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.file().lock();
        synchronized (object) {
            this.rollbackSlotChanges();
            this.clear();
        }
    }

    protected void rollbackSlotChanges() {
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object a_object) {
                ((SlotChange)a_object).rollback(IdSystem.this._file);
            }
        });
    }

    public boolean isDeleted(int id) {
        return this.slotChangeIsFlaggedDeleted(id);
    }

    public void writeZeroPointer(int id) {
        this.writePointer(id, Slot.ZERO);
    }

    public void writePointer(Pointer4 pointer) {
        this.writePointer(pointer._id, pointer._slot);
    }

    public void writePointer(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.WRITE_POINTER.log(id);
            DTrace.WRITE_POINTER.logLength(slot);
        }
        this.i_pointerIo.useSlot(id);
        this.i_pointerIo.writeInt(slot.address());
        this.i_pointerIo.writeInt(slot.length());
        this.i_pointerIo.write();
    }

    public boolean writeSlots() {
        final BooleanByRef ret = new BooleanByRef();
        this.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).writePointer(IdSystem.this.systemTransaction());
                ret.value = true;
            }
        });
        return ret.value;
    }

    public void flushFile() {
        if (DTrace.enabled) {
            DTrace.TRANS_FLUSH.log();
        }
        this._file.syncFiles();
    }

    private SlotChange produceSlotChange(int id) {
        if (DTrace.enabled) {
            DTrace.PRODUCE_SLOT_CHANGE.log(id);
        }
        SlotChange slot = new SlotChange(id);
        this._slotChanges.add(slot);
        return (SlotChange)slot.addedOrExisting();
    }

    public final SlotChange findSlotChange(int a_id) {
        return (SlotChange)this._slotChanges.find(a_id);
    }

    public Slot getCurrentSlotOfID(int id) {
        Slot parentSlot;
        if (id == 0) {
            return null;
        }
        SlotChange change = this.findSlotChange(id);
        if (change != null && change.isSetPointer()) {
            return change.newSlot();
        }
        if (this._systemIdSystem != null && (parentSlot = this._systemIdSystem.getCurrentSlotOfID(id)) != null) {
            return parentSlot;
        }
        return this.readPointer((int)id)._slot;
    }

    public Slot getCommittedSlotOfID(int id) {
        Slot parentSlot;
        Slot slot;
        if (id == 0) {
            return null;
        }
        SlotChange change = this.findSlotChange(id);
        if (change != null && (slot = change.oldSlot()) != null) {
            return slot;
        }
        if (this._systemIdSystem != null && (parentSlot = this._systemIdSystem.getCommittedSlotOfID(id)) != null) {
            return parentSlot;
        }
        return this.readPointer((int)id)._slot;
    }

    public Pointer4 readPointer(int id) {
        if (!this.isValidId(id)) {
            throw new InvalidIDException(id);
        }
        this._file.readBytes(this._pointerBuffer, id, 8);
        int address = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int length = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        if (!this.isValidSlot(address, length)) {
            throw new InvalidSlotException(address, length, id);
        }
        return new Pointer4(id, new Slot(address, length));
    }

    private boolean isValidId(int id) {
        return this._file.fileLength() >= (long)id;
    }

    private boolean isValidSlot(int address, int length) {
        long fileLength = this._file.fileLength();
        boolean validAddress = fileLength >= (long)address;
        boolean validLength = fileLength >= (long)length;
        boolean validSlot = fileLength >= (long)(address + length);
        return validAddress && validLength && validSlot;
    }

    private Pointer4 debugReadPointer(int id) {
        return null;
    }

    public void setPointer(int a_id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.SLOT_SET_POINTER.log(a_id);
            DTrace.SLOT_SET_POINTER.logLength(slot);
        }
        this.produceSlotChange(a_id).setPointer(slot);
    }

    private boolean slotChangeIsFlaggedDeleted(int id) {
        SlotChange slot = this.findSlotChange(id);
        if (slot != null) {
            return slot.isDeleted();
        }
        if (this._systemIdSystem != null) {
            return this._systemIdSystem.slotChangeIsFlaggedDeleted(id);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void completeInterruptedTransaction() {
        Object object = this.file().lock();
        synchronized (object) {
            this._transactionLogHandler.completeInterruptedTransaction(this);
        }
    }

    public void traverseSlotChanges(Visitor4 visitor) {
        if (this._systemIdSystem != null) {
            this._systemIdSystem.traverseSlotChanges(visitor);
        }
        this._slotChanges.traverseLocked(visitor);
    }

    public void slotDelete(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.SLOT_DELETE.log(id);
            DTrace.SLOT_DELETE.logLength(slot);
        }
        if (id == 0) {
            return;
        }
        SlotChange slotChange = this.produceSlotChange(id);
        slotChange.freeOnCommit(this._file, slot);
        slotChange.setPointer(Slot.ZERO);
    }

    public void slotFreeOnCommit(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.SLOT_FREE_ON_COMMIT.log(id);
            DTrace.SLOT_FREE_ON_COMMIT.logLength(slot);
        }
        if (id == 0) {
            return;
        }
        this.produceSlotChange(id).freeOnCommit(this._file, slot);
    }

    public void slotFreeOnRollback(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.SLOT_FREE_ON_ROLLBACK_ID.log(id);
            DTrace.SLOT_FREE_ON_ROLLBACK_ADDRESS.logLength(slot);
        }
        this.produceSlotChange(id).freeOnRollback(slot);
    }

    void slotFreeOnRollbackCommitSetPointer(int id, Slot newSlot, boolean forFreespace) {
        Slot oldSlot = this.getCurrentSlotOfID(id);
        if (oldSlot == null) {
            return;
        }
        if (DTrace.enabled) {
            DTrace.FREE_ON_ROLLBACK.log(id);
            DTrace.FREE_ON_ROLLBACK.logLength(newSlot);
            DTrace.FREE_ON_COMMIT.log(id);
            DTrace.FREE_ON_COMMIT.logLength(oldSlot);
        }
        SlotChange change = this.produceSlotChange(id);
        change.freeOnRollbackSetPointer(newSlot);
        change.freeOnCommit(this._file, oldSlot);
        change.forFreespace(forFreespace);
    }

    void produceUpdateSlotChange(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.FREE_ON_ROLLBACK.log(id);
            DTrace.FREE_ON_ROLLBACK.logLength(slot);
        }
        SlotChange slotChange = this.produceSlotChange(id);
        slotChange.freeOnRollbackSetPointer(slot);
    }

    public void slotFreePointerOnCommit(int a_id) {
        Slot slot = this.getCurrentSlotOfID(a_id);
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(a_id, slot);
    }

    void slotFreePointerOnCommit(int a_id, Slot slot) {
        this.slotFreeOnCommit(slot.address(), slot);
        this.slotFreeOnCommit(a_id, slot);
    }

    public void slotFreePointerOnRollback(int id) {
        this.produceSlotChange(id).freePointerOnRollback();
    }

    public CallbackObjectInfoCollections collectCommittingCallbackInfo(final LocalTransaction trans) {
        if (null == this._slotChanges) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 added = new Collection4();
        final Collection4 deleted = new Collection4();
        final Collection4 updated = new Collection4();
        this.collectSlotChanges(new SlotChangeCollector(){

            public void added(int id) {
                added.add(trans.lazyReferenceFor(id));
            }

            public void updated(int id) {
                updated.add(trans.lazyReferenceFor(id));
            }

            public void deleted(int id) {
                ObjectInfo ref = trans.frozenReferenceFor(id);
                if (ref != null) {
                    deleted.add(ref);
                }
            }
        });
        return this.newCallbackObjectInfoCollections(added, updated, deleted);
    }

    private CallbackObjectInfoCollections newCallbackObjectInfoCollections(Collection4 added, Collection4 updated, Collection4 deleted) {
        return new CallbackObjectInfoCollections(new ObjectInfoCollectionImpl(added), new ObjectInfoCollectionImpl(updated), new ObjectInfoCollectionImpl(deleted));
    }

    private void collectSlotChanges(final SlotChangeCollector collector) {
        if (null == this._slotChanges) {
            return;
        }
        this._slotChanges.traverseLocked(new Visitor4(){

            public void visit(Object obj) {
                SlotChange slotChange = (SlotChange)obj;
                int id = slotChange._key;
                if (slotChange.isDeleted()) {
                    if (!slotChange.isNew()) {
                        collector.deleted(id);
                    }
                } else if (slotChange.isNew()) {
                    collector.added(id);
                } else {
                    collector.updated(id);
                }
            }
        });
    }

    public static Transaction readInterruptedTransaction(LocalObjectContainer file, ByteArrayBuffer reader) {
        LocalTransaction transaction = (LocalTransaction)file.newTransaction(null, null);
        if (transaction.wasInterrupted(reader)) {
            return transaction;
        }
        return null;
    }

    public boolean wasInterrupted(ByteArrayBuffer reader) {
        return this._transactionLogHandler.checkForInterruptedTransaction(this, reader);
    }

    public FreespaceManager freespaceManager() {
        return this._file.freespaceManager();
    }

    private void freespaceBeginCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().beginCommit();
    }

    private void freespaceEndCommit() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().endCommit();
    }

    private void commitFreespace() {
        if (this.freespaceManager() == null) {
            return;
        }
        this.freespaceManager().commit();
    }

    public void readSlotChanges(ByteArrayBuffer buffer) {
        this._slotChanges.read(buffer, new SlotChange(0));
    }

    public void close() {
        this._transactionLogHandler.close();
    }

    public LocalTransaction systemTransaction() {
        return (LocalTransaction)this.file().systemTransaction();
    }
}

