/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

public abstract class TransactionLogHandler {
    protected LocalObjectContainer file(IdSystem idSystem) {
        return idSystem.file();
    }

    protected void flushDatabaseFile(IdSystem idSystem) {
        idSystem.flushFile();
    }

    protected void appendSlotChanges(IdSystem idSystem, final ByteArrayBuffer writer) {
        idSystem.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).write(writer);
            }
        });
    }

    protected int transactionLogSlotLength(IdSystem idSystem) {
        return (this.countSlotChanges(idSystem) * 3 + 2) * 4;
    }

    protected int countSlotChanges(IdSystem idSystem) {
        final IntByRef count = new IntByRef();
        idSystem.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                SlotChange slot = (SlotChange)obj;
                if (slot.isSetPointer()) {
                    ++count.value;
                }
            }
        });
        return count.value;
    }

    public abstract Slot allocateSlot(IdSystem var1, boolean var2);

    public abstract void applySlotChanges(IdSystem var1, Slot var2);

    public abstract boolean checkForInterruptedTransaction(IdSystem var1, ByteArrayBuffer var2);

    public abstract void completeInterruptedTransaction(IdSystem var1);

    public abstract void close();
}

