/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.Transaction;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;

public abstract class ClassMarshaller {
    public MarshallerFamily _family;

    public RawClassSpec readSpec(Transaction trans, ByteArrayBuffer reader) {
        byte[] nameBytes = this.readName(trans, reader);
        String className = trans.container().stringIO().read(nameBytes);
        this.readMetaClassID(reader);
        int ancestorID = reader.readInt();
        reader.incrementOffset(4);
        int numFields = reader.readInt();
        return new RawClassSpec(className, ancestorID, numFields);
    }

    public void write(final Transaction trans, final ClassMetadata clazz, final ByteArrayBuffer writer) {
        writer.writeShortString(trans, clazz.nameToWrite());
        int intFormerlyKnownAsMetaClassID = 0;
        writer.writeInt(intFormerlyKnownAsMetaClassID);
        writer.writeIDOf(trans, clazz._ancestor);
        this.writeIndex(trans, clazz, writer);
        writer.writeInt(clazz.declaredAspectCount());
        clazz.traverseDeclaredAspects(new Procedure4(){

            public void apply(Object arg) {
                ClassMarshaller.this._family._field.write(trans, clazz, (ClassAspect)arg, writer);
            }
        });
    }

    protected void writeIndex(Transaction trans, ClassMetadata clazz, ByteArrayBuffer writer) {
        int indexID = clazz.index().write(trans);
        writer.writeInt(this.indexIDForWriting(indexID));
    }

    protected abstract int indexIDForWriting(int var1);

    public final byte[] readName(Transaction trans, ByteArrayBuffer reader) {
        return this.readName(trans.container().stringIO(), reader);
    }

    public final int readMetaClassID(ByteArrayBuffer reader) {
        return reader.readInt();
    }

    private byte[] readName(LatinStringIO sio, ByteArrayBuffer reader) {
        byte[] nameBytes = sio.bytes(reader);
        reader.incrementOffset(nameBytes.length);
        nameBytes = Platform4.updateClassName(nameBytes);
        return nameBytes;
    }

    public final void read(ObjectContainerBase stream, ClassMetadata clazz, ByteArrayBuffer reader) {
        clazz.setAncestor(stream.classMetadataForID(reader.readInt()));
        clazz.checkType();
        this.readIndex(stream, clazz, reader);
        clazz._aspects = this.readAspects(stream, reader, clazz);
    }

    protected abstract void readIndex(ObjectContainerBase var1, ClassMetadata var2, ByteArrayBuffer var3);

    private ClassAspect[] readAspects(ObjectContainerBase stream, ByteArrayBuffer reader, ClassMetadata clazz) {
        ClassAspect[] aspects = new ClassAspect[reader.readInt()];
        for (int i = 0; i < aspects.length; ++i) {
            aspects[i] = this._family._field.read(stream, clazz, reader);
            aspects[i].setHandle(i);
        }
        return aspects;
    }

    public int marshalledLength(final ObjectContainerBase stream, ClassMetadata clazz) {
        final IntByRef len = new IntByRef(stream.stringIO().shortLength(clazz.nameToWrite()) + 0 + 8 + 4);
        len.value += clazz.index().ownLength();
        clazz.traverseDeclaredAspects(new Procedure4(){

            public void apply(Object arg) {
                len.value += ClassMarshaller.this._family._field.marshalledLength(stream, (ClassAspect)arg);
            }
        });
        return len.value;
    }

    public void defrag(final ClassMetadata classMetadata, final LatinStringIO sio, final DefragmentContextImpl context, int classIndexID) {
        this.readName(sio, context.sourceBuffer());
        this.readName(sio, context.targetBuffer());
        int metaClassID = 0;
        context.writeInt(metaClassID);
        context.copyID();
        context.writeInt(classMetadata.hasClassIndex() ? this.indexIDForWriting(classIndexID) : 0);
        final int aspectCount = context.readInt();
        if (aspectCount > classMetadata.declaredAspectCount()) {
            throw new IllegalStateException();
        }
        final IntByRef processedAspectCount = new IntByRef(0);
        classMetadata.traverseDeclaredAspects(new Procedure4(){

            public void apply(Object arg) {
                if (processedAspectCount.value >= aspectCount) {
                    return;
                }
                ClassAspect aspect = (ClassAspect)arg;
                ClassMarshaller.this._family._field.defrag(classMetadata, aspect, sio, context);
                ++processedAspectCount.value;
            }
        });
    }
}

