/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.Closure4;
import com.db4o.foundation.Hashtable4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.SlotFormat0;
import com.db4o.internal.marshall.SlotFormat2;
import com.db4o.internal.marshall.SlotFormatCurrent;
import com.db4o.marshall.ReadBuffer;
import com.db4o.typehandlers.TypeHandler4;

public abstract class SlotFormat {
    private static final Hashtable4 _versions = new Hashtable4();
    private static final SlotFormat CURRENT_SLOT_FORMAT = new SlotFormatCurrent();

    protected SlotFormat() {
        _versions.put(this.handlerVersion(), (Object)this);
    }

    public static final SlotFormat forHandlerVersion(int handlerVersion) {
        if (handlerVersion == 10) {
            return CURRENT_SLOT_FORMAT;
        }
        if (handlerVersion < 0 || handlerVersion > CURRENT_SLOT_FORMAT.handlerVersion()) {
            throw new IllegalArgumentException();
        }
        SlotFormat slotFormat = (SlotFormat)_versions.get(handlerVersion);
        if (slotFormat != null) {
            return slotFormat;
        }
        return SlotFormat.forHandlerVersion(handlerVersion + 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SlotFormat)) {
            return false;
        }
        return this.handlerVersion() == ((SlotFormat)obj).handlerVersion();
    }

    public int hashCode() {
        return this.handlerVersion();
    }

    protected abstract int handlerVersion();

    public abstract boolean isIndirectedWithinSlot(TypeHandler4 var1);

    public static SlotFormat current() {
        return CURRENT_SLOT_FORMAT;
    }

    public Object doWithSlotIndirection(ReadBuffer buffer, TypeHandler4 typeHandler, Closure4 closure) {
        if (!this.isIndirectedWithinSlot(typeHandler)) {
            return closure.run();
        }
        return this.doWithSlotIndirection(buffer, closure);
    }

    public Object doWithSlotIndirection(ReadBuffer buffer, Closure4 closure) {
        int payLoadOffset = buffer.readInt();
        buffer.readInt();
        int savedOffset = buffer.offset();
        Object res = null;
        if (payLoadOffset != 0) {
            buffer.seek(payLoadOffset);
            res = closure.run();
        }
        buffer.seek(savedOffset);
        return res;
    }

    public void writeObjectClassID(ByteArrayBuffer buffer, int id) {
        buffer.writeInt(-id);
    }

    public void skipMarshallerInfo(ByteArrayBuffer reader) {
        reader.incrementOffset(1);
    }

    public ObjectHeaderAttributes readHeaderAttributes(ByteArrayBuffer reader) {
        return new ObjectHeaderAttributes(reader);
    }

    static {
        new SlotFormat0();
        new SlotFormat2();
    }
}

