/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.transactionlog;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.transactionlog.TransactionLogHandler;

public class EmbeddedTransactionLogHandler
extends TransactionLogHandler {
    private int _addressOfIncompleteCommit;

    public boolean checkForInterruptedTransaction(LocalTransaction trans, ByteArrayBuffer reader) {
        int transactionID1 = reader.readInt();
        int transactionID2 = reader.readInt();
        if (transactionID1 > 0 && transactionID1 == transactionID2) {
            this._addressOfIncompleteCommit = transactionID1;
            return true;
        }
        return false;
    }

    public void completeInterruptedTransaction(LocalTransaction trans) {
        StatefulBuffer bytes = new StatefulBuffer(trans, this._addressOfIncompleteCommit, 4);
        bytes.read();
        int length = bytes.readInt();
        if (length > 0) {
            bytes = new StatefulBuffer(trans, this._addressOfIncompleteCommit, length);
            bytes.read();
            bytes.incrementOffset(4);
            trans.readSlotChanges(bytes);
            if (trans.writeSlots()) {
                this.flushDatabaseFile(trans);
            }
            this.file(trans).writeTransactionPointer(0);
            this.flushDatabaseFile(trans);
            trans.freeSlotChanges(false);
        } else {
            this.file(trans).writeTransactionPointer(0);
            this.flushDatabaseFile(trans);
        }
    }

    public Slot allocateSlot(LocalTransaction trans, boolean appendToFile) {
        int blockedLength;
        Slot slot;
        int transactionLogByteCount = this.transactionLogSlotLength(trans);
        FreespaceManager freespaceManager = trans.freespaceManager();
        if (!appendToFile && freespaceManager != null && (slot = freespaceManager.allocateTransactionLogSlot(blockedLength = this.file(trans).bytesToBlocks(transactionLogByteCount))) != null) {
            return this.file(trans).toNonBlockedLength(slot);
        }
        return this.file(trans).appendBytes(transactionLogByteCount);
    }

    private void freeSlot(LocalTransaction trans, Slot slot) {
        if (slot == null) {
            return;
        }
        if (trans.freespaceManager() == null) {
            return;
        }
        trans.freespaceManager().freeTransactionLogSlot(this.file(trans).toBlockedLength(slot));
    }

    public void applySlotChanges(LocalTransaction trans, Slot reservedSlot) {
        int slotChangeCount = this.countSlotChanges(trans);
        if (slotChangeCount > 0) {
            Slot transactionLogSlot = this.slotLongEnoughForLog(trans, reservedSlot) ? reservedSlot : this.allocateSlot(trans, true);
            StatefulBuffer buffer = new StatefulBuffer((Transaction)trans, transactionLogSlot);
            buffer.writeInt(transactionLogSlot.length());
            buffer.writeInt(slotChangeCount);
            this.appendSlotChanges(trans, buffer);
            buffer.write();
            this.flushDatabaseFile(trans);
            this.file(trans).writeTransactionPointer(transactionLogSlot.address());
            this.flushDatabaseFile(trans);
            if (trans.writeSlots()) {
                this.flushDatabaseFile(trans);
            }
            this.file(trans).writeTransactionPointer(0);
            this.flushDatabaseFile(trans);
            if (transactionLogSlot != reservedSlot) {
                this.freeSlot(trans, transactionLogSlot);
            }
        }
        this.freeSlot(trans, reservedSlot);
    }

    private boolean slotLongEnoughForLog(LocalTransaction trans, Slot slot) {
        return slot != null && slot.length() >= this.transactionLogSlotLength(trans);
    }

    public void close() {
    }
}

