/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Function4;
import com.db4o.foundation.ObjectPool;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.SimpleObjectPool;
import com.db4o.internal.caching.Cache4;
import com.db4o.io.Bin;
import com.db4o.io.BinDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachingBin
extends BinDecorator {
    private final int _pageSize;
    private final Cache4<Long, Page> _cache;
    private final ObjectPool<Page> _pagePool;
    private long _fileLength;
    private Procedure4<Page> _onDiscardPage = new Procedure4<Page>(){

        @Override
        public void apply(Page discardedPage) {
            CachingBin.this.flushPage(discardedPage);
            CachingBin.this._pagePool.returnObject(discardedPage);
        }
    };
    final Function4<Long, Page> _producerFromDisk = new Function4<Long, Page>(){

        @Override
        public Page apply(Long pageAddress) {
            Page newPage = (Page)CachingBin.this._pagePool.borrowObject();
            CachingBin.this.loadPage(newPage, pageAddress);
            return newPage;
        }
    };
    final Function4<Long, Page> _producerFromPool = new Function4<Long, Page>(){

        @Override
        public Page apply(Long pageAddress) {
            Page newPage = (Page)CachingBin.this._pagePool.borrowObject();
            CachingBin.this.resetPageAddress(newPage, pageAddress);
            return newPage;
        }
    };

    public CachingBin(Bin bin, Cache4 cache, int pageCount, int pageSize) throws Db4oIOException {
        super(bin);
        this._pageSize = pageSize;
        this._pagePool = new SimpleObjectPool<Page>(this.newPagePool(pageCount));
        this._cache = cache;
        this._fileLength = this._bin.length();
    }

    private Page[] newPagePool(int pageCount) {
        Page[] pages = new Page[pageCount];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = new Page(this._pageSize);
        }
        return pages;
    }

    @Override
    public int read(long pos, byte[] buffer, int length) throws Db4oIOException {
        return this.readInternal(pos, buffer, length, false);
    }

    private int readInternal(long pos, byte[] buffer, int length, boolean syncRead) {
        Page page;
        int readBytes;
        long startAddress = pos;
        int bytesToRead = length;
        int totalRead = 0;
        while (bytesToRead > 0 && (readBytes = (page = syncRead ? this.syncReadPage(startAddress) : this.getPage(startAddress, this._producerFromDisk)).read(buffer, totalRead, startAddress, bytesToRead)) > 0) {
            bytesToRead -= readBytes;
            startAddress += (long)readBytes;
            totalRead += readBytes;
        }
        return totalRead == 0 ? -1 : totalRead;
    }

    @Override
    public void write(long pos, byte[] buffer, int length) throws Db4oIOException {
        long startAddress = pos;
        int bytesToWrite = length;
        int bufferOffset = 0;
        while (bytesToWrite > 0) {
            boolean loadFromDisk = bytesToWrite < this._pageSize || startAddress % (long)this._pageSize != 0L;
            Page page = this.getPage(startAddress, loadFromDisk);
            int writtenBytes = page.write(buffer, bufferOffset, startAddress, bytesToWrite);
            bytesToWrite -= writtenBytes;
            startAddress += (long)writtenBytes;
            bufferOffset += writtenBytes;
        }
        long endAddress = startAddress;
        this._fileLength = Math.max(endAddress, this._fileLength);
    }

    @Override
    public void sync() throws Db4oIOException {
        this.flushAllPages();
        super.sync();
    }

    @Override
    public int syncRead(long position, byte[] bytes, int bytesToRead) {
        return this.readInternal(position, bytes, bytesToRead, true);
    }

    @Override
    public long length() throws Db4oIOException {
        return this._fileLength;
    }

    private Page getPage(long startAddress, boolean loadFromDisk) throws Db4oIOException {
        Function4<Long, Page> producer = loadFromDisk ? this._producerFromDisk : this._producerFromPool;
        return this.getPage(startAddress, producer);
    }

    private Page getPage(long startAddress, Function4<Long, Page> producer) {
        Page page = this._cache.produce(this.pageAddressFor(startAddress), producer, this._onDiscardPage);
        page.ensureEndAddress(this._fileLength);
        return page;
    }

    private Page syncReadPage(long startAddress) {
        Page page = new Page(this._pageSize);
        this.loadPage(page, startAddress);
        page.ensureEndAddress(this._fileLength);
        return page;
    }

    private Long pageAddressFor(long startAddress) {
        return startAddress / (long)this._pageSize * (long)this._pageSize;
    }

    private void resetPageAddress(Page page, long startAddress) {
        page._startAddress = startAddress;
        page._endAddress = startAddress + (long)this._pageSize;
    }

    protected void flushAllPages() throws Db4oIOException {
        for (Page p : this._cache) {
            this.flushPage(p);
        }
    }

    private void flushPage(Page page) throws Db4oIOException {
        if (!page._dirty) {
            return;
        }
        this.writePageToDisk(page);
    }

    private void loadPage(Page page, long pos) throws Db4oIOException {
        long startAddress;
        page._startAddress = startAddress = pos - pos % (long)this._pageSize;
        int count = this._bin.read(page._startAddress, page._buffer, page._bufferSize);
        page._endAddress = count > 0 ? startAddress + (long)count : startAddress;
    }

    private void writePageToDisk(Page page) throws Db4oIOException {
        super.write(page._startAddress, page._buffer, page.size());
        page._dirty = false;
    }

    private static class Page {
        public final byte[] _buffer;
        public long _startAddress = -1L;
        public long _endAddress;
        public final int _bufferSize;
        public boolean _dirty;
        private byte[] zeroBytes;

        public Page(int size) {
            this._bufferSize = size;
            this._buffer = new byte[this._bufferSize];
        }

        void ensureEndAddress(long fileLength) {
            long bufferEndAddress = this._startAddress + (long)this._bufferSize;
            if (this._endAddress < bufferEndAddress && fileLength > this._endAddress) {
                long newEndAddress = Math.min(fileLength, bufferEndAddress);
                if (this.zeroBytes == null) {
                    this.zeroBytes = new byte[this._bufferSize];
                }
                System.arraycopy(this.zeroBytes, 0, this._buffer, (int)(this._endAddress - this._startAddress), (int)(newEndAddress - this._endAddress));
                this._endAddress = newEndAddress;
            }
        }

        int size() {
            return (int)(this._endAddress - this._startAddress);
        }

        int read(byte[] out, int outOffset, long startAddress, int length) {
            int bufferOffset = (int)(startAddress - this._startAddress);
            int pageAvailbeDataSize = (int)(this._endAddress - startAddress);
            int readBytes = Math.min(pageAvailbeDataSize, length);
            if (readBytes <= 0) {
                return -1;
            }
            System.arraycopy(this._buffer, bufferOffset, out, outOffset, readBytes);
            return readBytes;
        }

        int write(byte[] data, int dataOffset, long startAddress, int length) {
            int bufferOffset = (int)(startAddress - this._startAddress);
            int pageAvailabeBufferSize = this._bufferSize - bufferOffset;
            int writtenBytes = Math.min(pageAvailabeBufferSize, length);
            System.arraycopy(data, dataOffset, this._buffer, bufferOffset, writtenBytes);
            long endAddress = startAddress + (long)writtenBytes;
            if (endAddress > this._endAddress) {
                this._endAddress = endAddress;
            }
            this._dirty = true;
            return writtenBytes;
        }
    }
}

