/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.engine.http.io.ChunkedOutputStream;
import org.restlet.test.RestletTestCase;

public class ChunkedOutputStreamTestCase
extends RestletTestCase {
    public void testCallCloseTwice() throws IOException {
        String data = "test data";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out);
        chunked.write("test data".getBytes());
        chunked.close();
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"9\r\ntest data\r\n0\r\n\r\n", (String)result);
    }

    public void testCallFlushAndClose() throws IOException {
        String data = "test data";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out);
        chunked.write("test data".getBytes());
        chunked.flush();
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"9\r\ntest data\r\n0\r\n\r\n", (String)result);
    }

    public void testEmptyWrite() throws IOException {
        String data = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out);
        chunked.write("".getBytes());
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"0\r\n\r\n", (String)result);
    }

    public void testNoWrite() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out);
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"0\r\n\r\n", (String)result);
    }

    public void testWrite() throws IOException {
        String data = "test data";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out);
        chunked.write("test data".getBytes());
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"9\r\ntest data\r\n0\r\n\r\n", (String)result);
    }

    public void testWriteSmallBuffer() throws IOException {
        String data = "test data";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)out, 2);
        chunked.write("test data".getBytes());
        chunked.close();
        String result = new String(out.toByteArray());
        ChunkedOutputStreamTestCase.assertEquals((String)"2\r\nte\r\n2\r\nst\r\n2\r\n d\r\n2\r\nat\r\n1\r\na\r\n0\r\n\r\n", (String)result);
    }
}

