/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.velocity;

import java.io.File;
import java.io.FileWriter;
import java.util.TreeMap;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.engine.io.BioUtils;
import org.restlet.ext.velocity.TemplateRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.test.RestletTestCase;

public class VelocityTestCase
extends RestletTestCase {
    public void testRepresentationTemplate() throws Exception {
        File testDir = new File(System.getProperty("java.io.tmpdir"), "VelocityTestCase");
        testDir.mkdir();
        File testFile = File.createTempFile("test", ".vm", testDir);
        FileWriter fw = new FileWriter(testFile);
        fw.write("Value=$value");
        fw.close();
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("value", "myValue");
        LocalReference ref = LocalReference.createFileReference((File)testFile);
        ClientResource r = new ClientResource((Reference)ref);
        Representation templateFile = r.get();
        TemplateRepresentation tr = new TemplateRepresentation(templateFile, map, MediaType.TEXT_PLAIN);
        String result = tr.getText();
        VelocityTestCase.assertEquals((String)"Value=myValue", (String)result);
        BioUtils.delete((File)testFile);
        BioUtils.delete((File)testDir, (boolean)true);
    }

    public void testStandardTemplate() throws Exception {
        File testDir = new File(System.getProperty("java.io.tmpdir"), "VelocityTestCase");
        testDir.mkdir();
        File testFile = File.createTempFile("test", ".vm", testDir);
        FileWriter fw = new FileWriter(testFile);
        fw.write("Value=$value");
        fw.close();
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("value", "myValue");
        TemplateRepresentation tr = new TemplateRepresentation(testFile.getName(), map, MediaType.TEXT_PLAIN);
        tr.getEngine().setProperty("file.resource.loader.path", (Object)testDir.getAbsolutePath());
        String result = tr.getText();
        VelocityTestCase.assertEquals((String)"Value=myValue", (String)result);
        BioUtils.delete((File)testFile);
        BioUtils.delete((File)testDir, (boolean)true);
    }
}

