/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.resources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="matchedTest")
public class MatchedTestService {
    @Context
    private UriInfo mainUriInfo;

    private static Object getAttribute(UriInfo uriInfo, String attribute) {
        Method subMethod;
        String getterName = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
        try {
            subMethod = uriInfo.getClass().getMethod(getterName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (NoSuchMethodException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            return subMethod.invoke((Object)uriInfo, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvocationTargetException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String get(@Context UriInfo uriInfo) {
        int uriSize = uriInfo.getMatchedURIs().size();
        int resourcesSize = uriInfo.getMatchedResources().size();
        return uriSize + "\n" + resourcesSize;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="resourceClassNames")
    public String getResources(@Context UriInfo uriInfo) {
        StringBuilder stb = new StringBuilder();
        List resources = uriInfo.getMatchedResources();
        stb.append(resources.size());
        for (Object resource : resources) {
            stb.append('\n');
            stb.append(resource.getClass().getName());
        }
        return stb.toString();
    }

    @Path(value="sameSub")
    public MatchedTestService getSameSub() {
        return this.getSub();
    }

    @Path(value="sub")
    public MatchedTestService getSub() {
        MatchedTestService sub = new MatchedTestService();
        sub.mainUriInfo = this.mainUriInfo;
        return sub;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="uriInfo/{attribute}")
    public String getUriInfoAttribute(@Context UriInfo subUriInfo, @PathParam(value="attribute") String attribute) {
        Object mainAttrValue = MatchedTestService.getAttribute(this.mainUriInfo, attribute);
        Object subAttrValue = MatchedTestService.getAttribute(subUriInfo, attribute);
        return mainAttrValue + "\n" + subAttrValue;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="uris")
    public String getUris(@Context UriInfo uriInfo) {
        StringBuilder stb = new StringBuilder();
        List uris = uriInfo.getMatchedURIs();
        stb.append(uris.size());
        for (String uri : uris) {
            stb.append('\n');
            stb.append(uri);
        }
        return stb.toString();
    }
}

