/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.resources.MatrixParamTestService2;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class MatrixParamTest2
extends JaxRsTestCase {
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(MatrixParamTestService2.class);
            }
        };
    }

    public void testEncodedWithDefault() throws Exception {
        Response response = this.get("encodedWithDefault;m=1;m=2;x=3");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"[1, 2]", (String)response.getEntity().getText());
        response = this.get("encodedWithDefault;m=1;i=2;x=3");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"[1]", (String)response.getEntity().getText());
        response = this.get("encodedWithDefault;a=1;i=2;x=3");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"[default]", (String)response.getEntity().getText());
    }

    public void testWithoutPath() throws Exception {
        Response response = this.get(";firstname=Angela;lastname=Merkel");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
        response = this.get(";lastname=Merkel;firstname=Angela");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
        response = this.get(";firstname=Goofy");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"Goofy null", (String)response.getEntity().getText());
        response = this.get(";lastname=Goofy");
        MatrixParamTest2.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatrixParamTest2.assertEquals((String)"null Goofy", (String)response.getEntity().getText());
    }
}

