/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import junit.framework.TestCase;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ResourceException;
import org.restlet.test.resource.MyResource7;

public class AnnotatedResource7TestCase
extends TestCase {
    private ClientResource clientResource;

    protected void setUp() throws Exception {
        Finder finder = new Finder();
        finder.setTargetClass(MyResource7.class);
        this.clientResource = new ClientResource("http://local");
        this.clientResource.setNext((Uniform)finder);
    }

    protected void tearDown() throws Exception {
        this.clientResource = null;
        super.tearDown();
    }

    public void testGet() throws IOException, ResourceException {
        StringRepresentation input = new StringRepresentation((CharSequence)"[\"root\"]", MediaType.APPLICATION_JSON);
        Representation result = this.clientResource.post((Representation)input);
        AnnotatedResource7TestCase.assertNotNull((Object)result);
        AnnotatedResource7TestCase.assertEquals((String)"[\"root\"]1", (String)result.getText());
        AnnotatedResource7TestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)result.getMediaType());
        input = new StringRepresentation((CharSequence)"<root/>", MediaType.APPLICATION_XML);
        result = this.clientResource.post((Representation)input);
        AnnotatedResource7TestCase.assertNotNull((Object)result);
        AnnotatedResource7TestCase.assertEquals((String)"<root/>2", (String)result.getText());
        AnnotatedResource7TestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)result.getMediaType());
    }
}

