/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.routing;

import java.io.OutputStream;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.Redirector;
import org.restlet.test.RestletTestCase;

public class RedirectTestCase
extends RestletTestCase {
    private void testCall(Context context, Method method, String uri) throws Exception {
        Response response = context.getClientDispatcher().handle(new Request(method, uri));
        RedirectTestCase.assertNotNull((Object)response.getEntity());
        response.getEntity().write((OutputStream)System.out);
    }

    public void testRedirect() throws Exception {
        Component clientComponent = new Component();
        Component proxyComponent = new Component();
        Component originComponent = new Component();
        clientComponent.getClients().add(Protocol.HTTP);
        proxyComponent.getClients().add(Protocol.HTTP);
        String target = "http://localhost:" + (TEST_PORT + 1) + "{rr}";
        Redirector proxy = new Redirector(proxyComponent.getContext().createChildContext(), target, 6);
        Restlet trace = new Restlet(originComponent.getContext().createChildContext()){

            public void handle(Request request, Response response) {
                String message = "Resource URI:  " + request.getResourceRef() + '\n' + "Base URI:      " + request.getResourceRef().getBaseRef() + '\n' + "Remaining part: " + request.getResourceRef().getRemainingPart() + '\n' + "Method name:   " + request.getMethod() + '\n';
                response.setEntity((Representation)new StringRepresentation((CharSequence)message, MediaType.TEXT_PLAIN));
            }
        };
        proxyComponent.getDefaultHost().attach("", (Restlet)proxy);
        originComponent.getDefaultHost().attach("", trace);
        proxyComponent.getServers().add(Protocol.HTTP, TEST_PORT);
        originComponent.getServers().add(Protocol.HTTP, TEST_PORT + 1);
        originComponent.start();
        proxyComponent.start();
        clientComponent.start();
        Context context = clientComponent.getContext();
        String uri = "http://localhost:" + TEST_PORT + "/?foo=bar";
        this.testCall(context, Method.GET, uri);
        this.testCall(context, Method.DELETE, uri);
        uri = "http://localhost:" + TEST_PORT + "/abcd/efgh/ijkl?foo=bar&foo=beer";
        this.testCall(context, Method.GET, uri);
        this.testCall(context, Method.DELETE, uri);
        uri = "http://localhost:" + TEST_PORT + "/v1/client/kwse/CnJlNUQV9%252BNNqbUf7Lhs2BYEK2Y%253D" + "/user/johnm/uVGYTDK4kK4zsu96VHGeTCzfwso%253D/";
        this.testCall(context, Method.GET, uri);
        clientComponent.stop();
        originComponent.stop();
        proxyComponent.stop();
    }
}

