/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.connector;

import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.routing.Router;

public class RiapConnectorsTestCase
extends TestCase {
    public void testRiapConnectors() {
        Component component = new Component();
        component.getServers().add(Protocol.RIAP);
        component.getClients().add(Protocol.RIAP);
        Application app = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/testA", new Restlet(this.getContext()){

                    public void handle(Request request, Response response) {
                        response.setEntity("hello, world", MediaType.TEXT_PLAIN);
                    }
                });
                router.attach("/testB", new Restlet(this.getContext()){

                    public void handle(Request request, Response response) {
                        ClientResource resource = new ClientResource("riap://component/app/testA");
                        try {
                            response.setEntity(resource.get().getText(), MediaType.TEXT_PLAIN);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                });
                return router;
            }
        };
        component.getInternalRouter().attach("/app", (Restlet)app);
        try {
            component.start();
            ClientResource res = new ClientResource("riap://component/app/testA");
            Representation rep = res.get();
            RiapConnectorsTestCase.assertEquals((String)"hello, world", (String)rep.getText());
            rep = null;
            res = new ClientResource("riap://component/app/testB");
            rep = res.get();
            RiapConnectorsTestCase.assertEquals((String)"hello, world", (String)rep.getText());
            component.stop();
        }
        catch (Exception e) {
            RiapConnectorsTestCase.fail((String)e.getMessage());
        }
    }
}

